/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.client;

import is.codion.common.Configuration;
import is.codion.common.Text;
import is.codion.common.property.PropertyValue;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import javax.net.ssl.X509TrustManager;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.util.KeyStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Clients {
    private static final Logger LOG = LoggerFactory.getLogger(Clients.class);
    public static final String JAVAX_NET_TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String JAVAX_NET_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final PropertyValue<String> TRUSTSTORE = Configuration.stringValue((String)"codion.client.trustStore");
    public static final PropertyValue<String> TRUSTSTORE_PASSWORD = Configuration.stringValue((String)"codion.client.trustStorePassword");
    public static final PropertyValue<String> SERVER_HOSTNAME = Configuration.stringValue((String)"codion.server.hostname", (String)"localhost");
    private static final String DEFAULT_TRUSTSTORE_PASSWORD = "changeit";

    private Clients() {
    }

    public static void resolveTrustStore() {
        String trustStorePath = (String)TRUSTSTORE.get();
        if (Text.nullOrEmpty((String)trustStorePath)) {
            LOG.warn("No truststore specified via {}", (Object)TRUSTSTORE.propertyName());
            return;
        }
        String password = TRUSTSTORE_PASSWORD.optional().orElse(DEFAULT_TRUSTSTORE_PASSWORD);
        SSLFactory.Builder sslFactoryBuilder = SSLFactory.builder().withDefaultTrustMaterial();
        File trustStore = new File(trustStorePath);
        if (trustStore.exists()) {
            sslFactoryBuilder.withTrustMaterial(trustStore.toPath(), password.toCharArray());
        } else {
            sslFactoryBuilder.withTrustMaterial(trustStorePath, password.toCharArray());
        }
        X509TrustManager trustManager = (X509TrustManager)sslFactoryBuilder.build().getTrustManager().orElseThrow(() -> new RuntimeException("No TrustManager available after combining truststores"));
        KeyStore store = KeyStoreUtils.createTrustStore((X509TrustManager[])new X509TrustManager[]{trustManager});
        try {
            File file = File.createTempFile("combinedTrustStore", "tmp");
            file.deleteOnExit();
            try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                store.store(outputStream, password.toCharArray());
            }
            LOG.debug("Combined trust store written to file: {} -> {}", (Object)JAVAX_NET_TRUSTSTORE, (Object)file);
            System.setProperty(JAVAX_NET_TRUSTSTORE, file.getPath());
            System.setProperty(JAVAX_NET_TRUSTSTORE_PASSWORD, password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

