/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.client;

import is.codion.common.rmi.client.ConnectionRequest;
import is.codion.common.user.User;
import is.codion.common.version.Version;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

final class DefaultConnectionRequest
implements ConnectionRequest,
Serializable {
    private static final long serialVersionUID = 1L;
    private final User user;
    private final UUID clientId;
    private final String clientTypeId;
    private final Locale clientLocale = Locale.getDefault();
    private final ZoneId clientTimeZone = ZoneId.systemDefault();
    private final Version clientVersion;
    private final Version frameworkVersion = Version.version();
    private final Map<String, Object> parameters;

    private DefaultConnectionRequest(DefaultBuilder builder) {
        this.user = Objects.requireNonNull(builder.user, "user");
        this.clientId = builder.clientId == null ? UUID.randomUUID() : builder.clientId;
        this.clientTypeId = Objects.requireNonNull(builder.clientTypeId, "clientTypeId");
        this.clientVersion = builder.clientVersion;
        this.parameters = builder.parameters == null ? null : Collections.unmodifiableMap(builder.parameters);
    }

    @Override
    public User user() {
        return this.user;
    }

    @Override
    public UUID clientId() {
        return this.clientId;
    }

    @Override
    public String clientTypeId() {
        return this.clientTypeId;
    }

    @Override
    public Locale clientLocale() {
        return this.clientLocale;
    }

    @Override
    public ZoneId clientTimeZone() {
        return this.clientTimeZone;
    }

    @Override
    public Optional<Version> clientVersion() {
        return Optional.ofNullable(this.clientVersion);
    }

    @Override
    public Version frameworkVersion() {
        return this.frameworkVersion;
    }

    @Override
    public Map<String, Object> parameters() {
        return this.parameters == null ? Collections.emptyMap() : this.parameters;
    }

    @Override
    public ConnectionRequest copy() {
        ConnectionRequest.Builder builder = new DefaultBuilder().user(this.user.copy()).clientId(this.clientId).clientTypeId(this.clientTypeId).clientVersion(this.clientVersion);
        if (this.parameters != null) {
            this.parameters.forEach(builder::parameter);
        }
        return builder.build();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ConnectionRequest && this.clientId.equals(((ConnectionRequest)obj).clientId());
    }

    public int hashCode() {
        return this.clientId.hashCode();
    }

    public String toString() {
        return this.user + " [" + this.clientTypeId + "] - " + this.clientId;
    }

    static final class DefaultBuilder
    implements ConnectionRequest.Builder {
        private User user;
        private UUID clientId;
        private String clientTypeId;
        private Version clientVersion;
        private Map<String, Object> parameters;

        DefaultBuilder() {
        }

        @Override
        public ConnectionRequest.Builder user(User user) {
            this.user = Objects.requireNonNull(user);
            return this;
        }

        @Override
        public ConnectionRequest.Builder clientId(UUID clientId) {
            this.clientId = Objects.requireNonNull(clientId);
            return this;
        }

        @Override
        public ConnectionRequest.Builder clientTypeId(String clientTypeId) {
            this.clientTypeId = Objects.requireNonNull(clientTypeId);
            return this;
        }

        @Override
        public ConnectionRequest.Builder clientVersion(Version clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public ConnectionRequest.Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new HashMap<String, Object>();
            }
            this.parameters.put(key, value);
            return this;
        }

        @Override
        public ConnectionRequest build() {
            return new DefaultConnectionRequest(this);
        }
    }
}

