/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import is.codion.common.rmi.server.AuxiliaryServer;
import is.codion.common.rmi.server.Server;
import is.codion.common.rmi.server.ServerAdmin;
import java.rmi.Remote;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public interface AuxiliaryServerFactory<C extends Remote, A extends ServerAdmin, T extends AuxiliaryServer> {
    public T createServer(Server<C, A> var1);

    public static <C extends Remote, A extends ServerAdmin, T extends AuxiliaryServer> AuxiliaryServerFactory<C, A, T> instance(String classname) {
        Objects.requireNonNull(classname, "classname");
        try {
            return StreamSupport.stream(ServiceLoader.load(AuxiliaryServerFactory.class).spliterator(), false).filter(serverFactory -> serverFactory.getClass().getName().equals(classname)).findFirst().orElseThrow(() -> new IllegalStateException("No auxiliary server factory of type: " + classname + " available"));
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

