/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import is.codion.common.Text;
import is.codion.common.rmi.server.ServerConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultServerConfiguration
implements ServerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServerConfiguration.class);
    private final int port;
    private final int registryPort;
    private final Collection<String> auxiliaryServerFactoryClassNames;
    private final int adminPort;
    private final boolean sslEnabled;
    private final Supplier<String> serverNameSupplier;
    private final RMIClientSocketFactory rmiClientSocketFactory;
    private final RMIServerSocketFactory rmiServerSocketFactory;
    private final String objectInputFilterFactoryClassName;
    private final int connectionMaintenanceInterval;
    private final int connectionLimit;
    private String serverName;

    DefaultServerConfiguration(DefaultBuilder builder) {
        this.port = builder.serverPort;
        this.registryPort = builder.registryPort;
        this.auxiliaryServerFactoryClassNames = Collections.unmodifiableCollection(builder.auxiliaryServerFactoryClassNames);
        this.adminPort = builder.serverAdminPort;
        this.sslEnabled = builder.sslEnabled;
        this.serverName = builder.serverName;
        this.serverNameSupplier = builder.serverNameSupplier == null ? () -> this.serverName : builder.serverNameSupplier;
        this.rmiClientSocketFactory = builder.rmiClientSocketFactory;
        this.rmiServerSocketFactory = builder.rmiServerSocketFactory;
        this.objectInputFilterFactoryClassName = builder.objectInputFilterFactoryClassName;
        this.connectionMaintenanceInterval = builder.connectionMaintenanceInterval;
        this.connectionLimit = builder.connectionLimit;
    }

    @Override
    public String serverName() {
        if (this.serverName == null) {
            this.serverName = this.serverNameSupplier.get();
        }
        return this.serverName;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public int registryPort() {
        return this.registryPort;
    }

    @Override
    public int adminPort() {
        return this.adminPort;
    }

    @Override
    public Collection<String> auxiliaryServerFactoryClassNames() {
        return this.auxiliaryServerFactoryClassNames;
    }

    @Override
    public boolean sslEnabled() {
        return this.sslEnabled;
    }

    @Override
    public Optional<RMIClientSocketFactory> rmiClientSocketFactory() {
        return Optional.ofNullable(this.rmiClientSocketFactory);
    }

    @Override
    public Optional<RMIServerSocketFactory> rmiServerSocketFactory() {
        return Optional.ofNullable(this.rmiServerSocketFactory);
    }

    @Override
    public Optional<String> objectInputFilterFactoryClassName() {
        return Optional.ofNullable(this.objectInputFilterFactoryClassName);
    }

    @Override
    public int connectionMaintenanceInterval() {
        return this.connectionMaintenanceInterval;
    }

    @Override
    public int connectionLimit() {
        return this.connectionLimit;
    }

    static final class DefaultBuilder
    implements ServerConfiguration.Builder<DefaultBuilder> {
        private final int serverPort;
        private final int registryPort;
        private final Collection<String> auxiliaryServerFactoryClassNames = new HashSet<String>();
        private int serverAdminPort;
        private boolean sslEnabled = true;
        private String serverName;
        private Supplier<String> serverNameSupplier;
        private RMIClientSocketFactory rmiClientSocketFactory = new SslRMIClientSocketFactory();
        private RMIServerSocketFactory rmiServerSocketFactory = new SslRMIServerSocketFactory();
        private String objectInputFilterFactoryClassName;
        private Integer connectionMaintenanceInterval = 30000;
        private int connectionLimit = -1;

        DefaultBuilder(int serverPort, int registryPort) {
            this.serverPort = serverPort;
            this.registryPort = registryPort;
        }

        @Override
        public DefaultBuilder adminPort(int adminPort) {
            this.serverAdminPort = adminPort;
            return this;
        }

        @Override
        public DefaultBuilder serverName(Supplier<String> serverNameSupplier) {
            this.serverNameSupplier = Objects.requireNonNull(serverNameSupplier);
            return this;
        }

        @Override
        public DefaultBuilder serverName(String serverName) {
            this.serverName = Objects.requireNonNull(serverName);
            return this;
        }

        @Override
        public DefaultBuilder auxiliaryServerFactoryClassNames(Collection<String> auxiliaryServerFactoryClassNames) {
            this.auxiliaryServerFactoryClassNames.addAll(Objects.requireNonNull(auxiliaryServerFactoryClassNames));
            return this;
        }

        @Override
        public DefaultBuilder sslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            if (sslEnabled) {
                this.rmiClientSocketFactory(new SslRMIClientSocketFactory());
                this.rmiServerSocketFactory(new SslRMIServerSocketFactory());
            } else {
                this.rmiClientSocketFactory(null);
                this.rmiServerSocketFactory(null);
            }
            return this;
        }

        @Override
        public DefaultBuilder rmiClientSocketFactory(RMIClientSocketFactory rmiClientSocketFactory) {
            this.rmiClientSocketFactory = rmiClientSocketFactory;
            return this;
        }

        @Override
        public DefaultBuilder rmiServerSocketFactory(RMIServerSocketFactory rmiServerSocketFactory) {
            this.rmiServerSocketFactory = rmiServerSocketFactory;
            return this;
        }

        @Override
        public DefaultBuilder objectInputFilterFactoryClassName(String objectInputFilterFactoryClassName) {
            this.objectInputFilterFactoryClassName = objectInputFilterFactoryClassName;
            return this;
        }

        @Override
        public DefaultBuilder connectionMaintenanceInterval(int connectionMaintenanceInterval) {
            this.connectionMaintenanceInterval = connectionMaintenanceInterval;
            return this;
        }

        @Override
        public DefaultBuilder connectionLimit(int connectionLimit) {
            this.connectionLimit = connectionLimit;
            return this;
        }

        @Override
        public ServerConfiguration build() {
            return new DefaultServerConfiguration(this);
        }

        private static synchronized void resolveClasspathKeyStore() {
            String keystore = (String)ServerConfiguration.CLASSPATH_KEYSTORE.get();
            if (Text.nullOrEmpty((String)keystore)) {
                LOG.warn("No classpath key store specified via {}", (Object)ServerConfiguration.CLASSPATH_KEYSTORE.propertyName());
                return;
            }
            if (ServerConfiguration.KEYSTORE.isNotNull()) {
                throw new IllegalStateException("Classpath keystore (" + keystore + ") can not be specified when javax.net.ssl.keyStore is already set to " + (String)ServerConfiguration.KEYSTORE.get());
            }
            try (InputStream inputStream = DefaultServerConfiguration.class.getClassLoader().getResourceAsStream(keystore);){
                if (inputStream == null) {
                    LOG.warn("Specified key store not found on classpath: {}", (Object)keystore);
                    return;
                }
                File file = File.createTempFile("serverKeyStore", "tmp");
                Files.write(file.toPath(), DefaultBuilder.readBytes(inputStream), new OpenOption[0]);
                file.deleteOnExit();
                ServerConfiguration.KEYSTORE.set((Object)file.getPath());
                LOG.info("Classpath key store {} written to file {} and set as {}", new Object[]{ServerConfiguration.CLASSPATH_KEYSTORE.propertyName(), file, "javax.net.ssl.keyStore"});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static byte[] readBytes(InputStream stream) throws IOException {
            int line;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((line = stream.read(buffer)) != -1) {
                os.write(buffer, 0, line);
            }
            os.flush();
            return os.toByteArray();
        }

        static {
            DefaultBuilder.resolveClasspathKeyStore();
        }
    }
}

