/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import is.codion.common.rmi.client.ConnectionRequest;
import is.codion.common.rmi.server.DefaultServerLocator;
import is.codion.common.rmi.server.ServerAdmin;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.common.rmi.server.ServerInformation;
import is.codion.common.rmi.server.exception.ConnectionNotAvailableException;
import is.codion.common.rmi.server.exception.LoginException;
import is.codion.common.rmi.server.exception.ServerAuthenticationException;
import is.codion.common.user.User;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.UUID;

public interface Server<C extends Remote, A extends ServerAdmin>
extends Remote {
    public static final String CLIENT_HOST = "clientHost";

    public C connect(ConnectionRequest var1) throws RemoteException, ConnectionNotAvailableException, LoginException;

    public A serverAdmin(User var1) throws RemoteException, ServerAuthenticationException;

    public void disconnect(UUID var1) throws RemoteException;

    public ServerInformation serverInformation() throws RemoteException;

    public int serverLoad() throws RemoteException;

    public boolean connectionsAvailable() throws RemoteException;

    public static interface Locator {
        public <C extends Remote, A extends ServerAdmin> Server<C, A> locateServer() throws RemoteException, NotBoundException;

        public static Builder builder() {
            return new DefaultServerLocator.DefaultBuilder();
        }

        public static Registry registry() throws RemoteException {
            return Locator.registry((Integer)ServerConfiguration.REGISTRY_PORT.getOrThrow());
        }

        public static Registry registry(int registryPort) throws RemoteException {
            return DefaultServerLocator.initializeRegistry(registryPort);
        }

        public static interface Builder {
            public Builder hostName(String var1);

            public Builder namePrefix(String var1);

            public Builder registryPort(int var1);

            public Builder port(int var1);

            public Locator build();
        }
    }
}

