/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.rmi.server.exception.LoginException;
import java.util.List;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface Authenticator {
    default public Optional<String> clientTypeId() {
        return Optional.empty();
    }

    public RemoteClient login(RemoteClient var1) throws LoginException;

    default public void logout(RemoteClient remoteClient) {
    }

    default public void close() {
    }

    public static List<Authenticator> authenticators() {
        try {
            return StreamSupport.stream(ServiceLoader.load(Authenticator.class).spliterator(), false).collect(Collectors.toList());
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

