/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import is.codion.common.rmi.client.ConnectionRequest;
import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.user.User;
import is.codion.common.version.Version;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

final class DefaultRemoteClient
implements RemoteClient,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ConnectionRequest connectionRequest;
    private final User databaseUser;
    private final String clientHost;
    private final LocalDateTime creationTime;

    DefaultRemoteClient(DefaultBuilder builder) {
        this.connectionRequest = builder.connectionRequest;
        this.databaseUser = builder.databaseUser;
        this.clientHost = builder.clientHost;
        this.creationTime = LocalDateTime.now();
    }

    DefaultRemoteClient(DefaultRemoteClient remoteClient) {
        this.connectionRequest = remoteClient.connectionRequest.copy();
        this.databaseUser = remoteClient.databaseUser.copy();
        this.clientHost = remoteClient.clientHost;
        this.creationTime = remoteClient.creationTime;
    }

    DefaultRemoteClient(DefaultRemoteClient remoteClient, User databaseUser) {
        this.connectionRequest = remoteClient.connectionRequest;
        this.databaseUser = databaseUser;
        this.clientHost = remoteClient.clientHost;
        this.creationTime = remoteClient.creationTime;
    }

    @Override
    public ConnectionRequest connectionRequest() {
        return this.connectionRequest;
    }

    @Override
    public LocalDateTime creationTime() {
        return this.creationTime;
    }

    @Override
    public User user() {
        return this.connectionRequest.user();
    }

    @Override
    public User databaseUser() {
        return this.databaseUser;
    }

    @Override
    public UUID clientId() {
        return this.connectionRequest.clientId();
    }

    @Override
    public String clientTypeId() {
        return this.connectionRequest.clientTypeId();
    }

    @Override
    public Locale clientLocale() {
        return this.connectionRequest.clientLocale();
    }

    @Override
    public ZoneId clientTimeZone() {
        return this.connectionRequest.clientTimeZone();
    }

    @Override
    public Optional<Version> clientVersion() {
        return this.connectionRequest.clientVersion();
    }

    @Override
    public Version frameworkVersion() {
        return this.connectionRequest.frameworkVersion();
    }

    @Override
    public Map<String, Object> parameters() {
        return this.connectionRequest.parameters();
    }

    @Override
    public String clientHost() {
        return this.clientHost;
    }

    @Override
    public RemoteClient withDatabaseUser(User databaseUser) {
        return new DefaultRemoteClient(this, Objects.requireNonNull(databaseUser));
    }

    @Override
    public RemoteClient copy() {
        return new DefaultRemoteClient(this);
    }

    public int hashCode() {
        return this.connectionRequest.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RemoteClient && this.connectionRequest.equals(((RemoteClient)obj).connectionRequest());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.connectionRequest.user().toString());
        if (this.databaseUser != null && !this.connectionRequest.user().equals(this.databaseUser)) {
            builder.append(" (databaseUser: ").append(this.databaseUser).append(")");
        }
        builder.append("@").append(this.clientHost).append(" [").append(this.connectionRequest.clientTypeId()).append(this.connectionRequest.clientVersion().map(version -> "-" + version).orElse("")).append("] - ").append(this.connectionRequest.clientId());
        return builder.toString();
    }

    static final class DefaultBuilder
    implements RemoteClient.Builder {
        private final ConnectionRequest connectionRequest;
        private String clientHost = "unknown host";
        private User databaseUser;

        DefaultBuilder(ConnectionRequest connectionRequest) {
            this.connectionRequest = Objects.requireNonNull(connectionRequest);
            this.databaseUser = connectionRequest.user().copy();
        }

        @Override
        public RemoteClient.Builder clientHost(String clientHost) {
            this.clientHost = Objects.requireNonNull(clientHost);
            return this;
        }

        @Override
        public RemoteClient.Builder databaseUser(User databaseUser) {
            this.databaseUser = Objects.requireNonNull(databaseUser);
            return this;
        }

        @Override
        public RemoteClient build() {
            return new DefaultRemoteClient(this);
        }
    }
}

