/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import java.io.ObjectInputFilter;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public interface ObjectInputFilterFactory {
    public ObjectInputFilter createObjectInputFilter();

    public static ObjectInputFilterFactory instance(String classname) {
        Objects.requireNonNull(classname, "classname");
        try {
            return StreamSupport.stream(ServiceLoader.load(ObjectInputFilterFactory.class).spliterator(), false).filter(factory -> factory.getClass().getName().equals(classname)).findFirst().orElseThrow(() -> new IllegalStateException("No object input filter factory of type: " + classname + " available"));
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

