/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.h2;

import is.codion.common.Text;
import is.codion.common.db.database.Database;
import is.codion.common.db.database.DatabaseFactory;
import is.codion.dbms.h2.H2Database;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

public final class H2DatabaseFactory
implements DatabaseFactory {
    private static final String DRIVER_PACKAGE = "org.h2";
    private static final String RUN_TOOL_CLASS_NAME = "org.h2.tools.RunScript";
    private static final String SYSADMIN_USERNAME = "sa";

    public boolean driverCompatible(String driverClassName) {
        return Objects.requireNonNull(driverClassName, "driverClassName").startsWith(DRIVER_PACKAGE);
    }

    public Database createDatabase(String url) {
        return new H2Database(url, Text.parseCommaSeparatedValues((String)((String)Database.DATABASE_INIT_SCRIPTS.get())), (Boolean)Database.SELECT_FOR_UPDATE_NOWAIT.get());
    }

    public static Database createDatabase(String url, String ... initScripts) {
        return new H2Database(url, initScripts == null ? Collections.emptyList() : Arrays.asList(initScripts), (Boolean)Database.SELECT_FOR_UPDATE_NOWAIT.get());
    }

    public static void runScript(Database database, String scriptPath) throws SQLException {
        H2DatabaseFactory.runScript(database, scriptPath, SYSADMIN_USERNAME, "", Charset.defaultCharset());
    }

    public static void runScript(Database database, String scriptPath, String username, String password, Charset scriptCharset) throws SQLException {
        try {
            Class<?> runScriptToolClass = Class.forName(RUN_TOOL_CLASS_NAME);
            Method execute = runScriptToolClass.getMethod("execute", String.class, String.class, String.class, String.class, Charset.class, Boolean.TYPE);
            execute.invoke(runScriptToolClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), database.url(), username, password, scriptPath, scriptCharset, false);
        }
        catch (ClassNotFoundException cle) {
            throw new RuntimeException("org.h2.tools.RunScript must be on classpath for creating an embedded H2 database", cle);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof SQLException) {
                throw (SQLException)ite.getCause();
            }
            throw new RuntimeException(ite.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

