/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.hsqldb;

import is.codion.common.db.database.AbstractDatabase;
import java.util.Objects;

final class HSQLDatabase
extends AbstractDatabase {
    private static final String JDBC_URL_PREFIX = "jdbc:hsqldb:";
    private static final String JDBC_URL_PREFIX_MEM = "jdbc:hsqldb:mem:";
    private static final String JDBC_URL_PREFIX_FILE = "jdbc:hsqldb:file:";
    private static final String JDBC_URL_PREFIX_RES = "jdbc:hsqldb:res:";
    static final String AUTO_INCREMENT_QUERY = "IDENTITY()";
    static final String SEQUENCE_VALUE_QUERY = "SELECT NEXT VALUE FOR ";
    private final boolean nowait;

    HSQLDatabase(String url) {
        this(url, true);
    }

    HSQLDatabase(String url, boolean nowait) {
        super(url);
        this.nowait = nowait;
    }

    public String name() {
        String name = HSQLDatabase.removeUrlPrefixOptionsAndParameters((String)this.url(), (String[])new String[]{JDBC_URL_PREFIX_FILE, JDBC_URL_PREFIX_MEM, JDBC_URL_PREFIX_RES, JDBC_URL_PREFIX});
        return name.isEmpty() ? "private" : name;
    }

    public String selectForUpdateClause() {
        if (this.nowait) {
            return "FOR UPDATE NOWAIT";
        }
        return "FOR UPDATE";
    }

    public String limitOffsetClause(Integer limit, Integer offset) {
        return HSQLDatabase.createLimitOffsetClause((Integer)limit, (Integer)offset);
    }

    public String autoIncrementQuery(String idSource) {
        return AUTO_INCREMENT_QUERY;
    }

    public String sequenceQuery(String sequenceName) {
        return SEQUENCE_VALUE_QUERY + Objects.requireNonNull(sequenceName, "sequenceName");
    }
}

