/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.common.event.Event;
import is.codion.common.observable.Observer;
import is.codion.common.user.User;
import is.codion.common.version.Version;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.Entities;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityConnectionProvider
implements EntityConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEntityConnectionProvider.class);
    private final Lock lock = new Lock(){};
    private final Event<EntityConnection> connectedEvent = Event.event();
    private final User user;
    private final DomainType domainType;
    private final UUID clientId;
    private final Version clientVersion;
    private final String clientType;
    private final Consumer<EntityConnectionProvider> onClose;
    private EntityConnection entityConnection;
    private Entities entities;

    protected AbstractEntityConnectionProvider(AbstractBuilder<?, ?> builder) {
        Objects.requireNonNull(builder);
        this.user = Objects.requireNonNull(builder.user, "A user must be specified");
        this.domainType = Objects.requireNonNull(builder.domainType, "A domainType must be specified");
        this.clientId = Objects.requireNonNull(builder.clientId, "A clientId must be specified");
        this.clientType = builder.clientType;
        this.clientVersion = builder.clientVersion;
        this.onClose = builder.onClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Entities entities() {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.entities == null) {
                this.doConnect();
            }
            return this.entities;
        }
    }

    @Override
    public final User user() {
        return this.user;
    }

    @Override
    public final DomainType domainType() {
        return this.domainType;
    }

    @Override
    public final UUID clientId() {
        return this.clientId;
    }

    @Override
    public final Optional<String> clientType() {
        return Optional.ofNullable(this.clientType);
    }

    @Override
    public final Optional<Version> clientVersion() {
        return Optional.ofNullable(this.clientVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean connectionValid() {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.entityConnection == null) {
                return false;
            }
            try {
                return this.entityConnection.connected();
            }
            catch (RuntimeException e) {
                LOG.debug("Connection deemed invalid", (Throwable)e);
                return false;
            }
        }
    }

    @Override
    public final Observer<EntityConnection> connected() {
        return this.connectedEvent.observer();
    }

    @Override
    public EntityConnection connection() {
        return this.validConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.entityConnection != null) {
                if (this.connectionValid()) {
                    this.close(this.entityConnection);
                }
                this.entityConnection = null;
            }
        }
        if (this.onClose != null) {
            this.onClose.accept(this);
        }
    }

    protected abstract EntityConnection connect();

    protected abstract void close(EntityConnection var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final EntityConnection validConnection() {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.entityConnection == null) {
                this.doConnect();
            } else if (!this.connectionValid()) {
                LOG.info("Previous connection invalid, reconnecting");
                try {
                    this.entityConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.entityConnection = null;
                this.doConnect();
            }
            return this.entityConnection;
        }
    }

    private void doConnect() {
        this.entityConnection = this.connect();
        this.entities = this.entityConnection.entities();
        this.connectedEvent.accept((Object)this.entityConnection);
    }

    private static interface Lock {
    }

    public static abstract class AbstractBuilder<T extends EntityConnectionProvider, B extends EntityConnectionProvider.Builder<T, B>>
    implements EntityConnectionProvider.Builder<T, B> {
        private final String connectionType;
        private User user;
        private DomainType domainType;
        private UUID clientId = UUID.randomUUID();
        private String clientType;
        private Version clientVersion;
        private Consumer<EntityConnectionProvider> onClose;

        protected AbstractBuilder(String connectionType) {
            this.connectionType = Objects.requireNonNull(connectionType);
        }

        @Override
        public final String connectionType() {
            return this.connectionType;
        }

        @Override
        public final B user(User user) {
            this.user = Objects.requireNonNull(user);
            return this.self();
        }

        @Override
        public final B domainType(DomainType domainType) {
            this.domainType = Objects.requireNonNull(domainType);
            return this.self();
        }

        @Override
        public final B clientId(UUID clientId) {
            this.clientId = Objects.requireNonNull(clientId);
            return this.self();
        }

        @Override
        public final B clientType(String clientType) {
            this.clientType = Objects.requireNonNull(clientType);
            return this.self();
        }

        @Override
        public final B clientVersion(Version clientVersion) {
            this.clientVersion = clientVersion;
            return this.self();
        }

        @Override
        public final B onClose(Consumer<EntityConnectionProvider> onClose) {
            this.onClose = Objects.requireNonNull(onClose);
            return this.self();
        }

        private B self() {
            return (B)this;
        }
    }
}

