/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.framework.db.DefaultBatchInsert;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.condition.Condition;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class DefaultBatchCopy
implements EntityConnection.BatchCopy {
    private final EntityConnection source;
    private final EntityConnection destination;
    private final Map<EntityType, Condition> entityTypeConditions = new LinkedHashMap<EntityType, Condition>();
    private final int batchSize;
    private final boolean includePrimaryKeys;

    DefaultBatchCopy(DefaultBuilder builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.entityTypeConditions.putAll(builder.entityTypeConditions);
        this.batchSize = builder.batchSize;
        this.includePrimaryKeys = builder.includePrimaryKeys;
    }

    @Override
    public void execute() {
        for (Map.Entry<EntityType, Condition> entityTypeCondition : this.entityTypeConditions.entrySet()) {
            EntityConnection.Select.Builder conditionBuilder = entityTypeCondition.getValue() == null ? EntityConnection.Select.all(entityTypeCondition.getKey()) : EntityConnection.Select.where(entityTypeCondition.getValue());
            List entities = this.source.select(conditionBuilder.fetchDepth(0).build()).stream().map(entity -> this.includePrimaryKeys ? entity : entity.copy().builder().clearPrimaryKey().build()).collect(Collectors.toList());
            new DefaultBatchInsert.DefaultBuilder(this.destination, entities.iterator()).batchSize(this.batchSize).execute();
        }
    }

    static final class DefaultBuilder
    implements EntityConnection.BatchCopy.Builder {
        private final EntityConnection source;
        private final EntityConnection destination;
        private final Map<EntityType, Condition> entityTypeConditions = new LinkedHashMap<EntityType, Condition>();
        private boolean includePrimaryKeys = true;
        private int batchSize = 100;

        DefaultBuilder(EntityConnection source, EntityConnection destination) {
            this.source = Objects.requireNonNull(source);
            this.destination = Objects.requireNonNull(destination);
        }

        @Override
        public EntityConnection.BatchCopy.Builder entityTypes(EntityType ... entityTypes) {
            Objects.requireNonNull(entityTypes);
            Arrays.stream(entityTypes).forEach(entityType -> this.entityTypeConditions.put(Objects.requireNonNull(entityType), null));
            return this;
        }

        @Override
        public EntityConnection.BatchCopy.Builder conditions(Condition ... conditions) {
            Objects.requireNonNull(conditions);
            Arrays.stream(conditions).forEach(condition -> this.entityTypeConditions.put(Objects.requireNonNull(condition.entityType()), (Condition)condition));
            return this;
        }

        @Override
        public EntityConnection.BatchCopy.Builder batchSize(int batchSize) {
            if (batchSize <= 0) {
                throw new IllegalArgumentException("Batch size must be a positive integer: " + batchSize);
            }
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public EntityConnection.BatchCopy.Builder includePrimaryKeys(boolean includePrimaryKeys) {
            this.includePrimaryKeys = includePrimaryKeys;
            return this;
        }

        @Override
        public void execute() {
            this.build().execute();
        }

        @Override
        public EntityConnection.BatchCopy build() {
            return new DefaultBatchCopy(this);
        }
    }
}

