/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.Entity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

final class DefaultBatchInsert
implements EntityConnection.BatchInsert {
    private final EntityConnection connection;
    private final Iterator<Entity> entityIterator;
    private final int batchSize;
    private final Consumer<Integer> progressReporter;
    private final Consumer<Collection<Entity.Key>> onInsert;

    DefaultBatchInsert(DefaultBuilder builder) {
        this.connection = builder.connection;
        this.entityIterator = builder.entityIterator;
        this.batchSize = builder.batchSize;
        this.progressReporter = builder.progressReporter;
        this.onInsert = builder.onInsert;
    }

    @Override
    public void execute() {
        ArrayList<Entity> batch = new ArrayList<Entity>(this.batchSize);
        int progress = 0;
        while (this.entityIterator.hasNext()) {
            while (batch.size() < this.batchSize && this.entityIterator.hasNext()) {
                batch.add(this.entityIterator.next());
            }
            Collection<Entity.Key> insertedKeys = this.connection.insert(batch);
            progress += insertedKeys.size();
            batch.clear();
            if (this.progressReporter != null) {
                this.progressReporter.accept(progress);
            }
            if (this.onInsert == null) continue;
            this.onInsert.accept(insertedKeys);
        }
    }

    static final class DefaultBuilder
    implements EntityConnection.BatchInsert.Builder {
        private final EntityConnection connection;
        private final Iterator<Entity> entityIterator;
        private int batchSize = 100;
        private Consumer<Integer> progressReporter;
        private Consumer<Collection<Entity.Key>> onInsert;

        DefaultBuilder(EntityConnection connection, Iterator<Entity> entityIterator) {
            this.connection = Objects.requireNonNull(connection);
            this.entityIterator = Objects.requireNonNull(entityIterator);
        }

        @Override
        public EntityConnection.BatchInsert.Builder batchSize(int batchSize) {
            if (batchSize <= 0) {
                throw new IllegalArgumentException("Batch size must be a positive integer: " + batchSize);
            }
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public EntityConnection.BatchInsert.Builder progressReporter(Consumer<Integer> progressReporter) {
            this.progressReporter = Objects.requireNonNull(progressReporter);
            return this;
        }

        @Override
        public EntityConnection.BatchInsert.Builder onInsert(Consumer<Collection<Entity.Key>> onInsert) {
            this.onInsert = Objects.requireNonNull(onInsert);
            return this;
        }

        @Override
        public void execute() {
            this.build().execute();
        }

        @Override
        public EntityConnection.BatchInsert build() {
            return new DefaultBatchInsert(this);
        }
    }
}

