/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

final class DefaultUpdate
implements EntityConnection.Update,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Condition where;
    private final Map<Column<?>, Object> values;

    private DefaultUpdate(DefaultBuilder builder) {
        this.where = builder.where;
        this.values = Collections.unmodifiableMap(builder.values);
    }

    @Override
    public Condition where() {
        return this.where;
    }

    @Override
    public Map<Column<?>, Object> values() {
        return this.values;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultUpdate)) {
            return false;
        }
        DefaultUpdate that = (DefaultUpdate)object;
        return Objects.equals(this.where, that.where) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.where, this.values);
    }

    public String toString() {
        return "Update{where=" + String.valueOf(this.where) + ", values=" + String.valueOf(this.values) + "}";
    }

    static final class DefaultBuilder
    implements EntityConnection.Update.Builder {
        private final Condition where;
        private final Map<Column<?>, Object> values = new LinkedHashMap();

        DefaultBuilder(Condition where) {
            this.where = Objects.requireNonNull(where);
        }

        @Override
        public <T> EntityConnection.Update.Builder set(Column<?> column, T value) {
            if (this.values.containsKey(Objects.requireNonNull(column))) {
                throw new IllegalStateException("Update already contains a value for column: " + String.valueOf(column));
            }
            this.values.put(column, value);
            return this;
        }

        @Override
        public EntityConnection.Update build() {
            if (this.values.isEmpty()) {
                throw new IllegalStateException("No values provided for update");
            }
            return new DefaultUpdate(this);
        }
    }
}

