/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db;

import is.codion.common.db.operation.FunctionType;
import is.codion.common.db.operation.ProcedureType;
import is.codion.common.db.report.ReportType;
import is.codion.common.user.User;
import is.codion.framework.db.DefaultBatchCopy;
import is.codion.framework.db.DefaultBatchInsert;
import is.codion.framework.db.DefaultCount;
import is.codion.framework.db.DefaultSelect;
import is.codion.framework.db.DefaultUpdate;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.Condition;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;

public interface EntityConnection
extends AutoCloseable {
    public static final int DEFAULT_QUERY_TIMEOUT_SECONDS = 120;

    public Entities entities();

    public User user();

    public boolean connected();

    @Override
    public void close();

    public boolean transactionOpen();

    public void startTransaction();

    public void rollbackTransaction();

    public void commitTransaction();

    public void setQueryCacheEnabled(boolean var1);

    public boolean isQueryCacheEnabled();

    public <C extends EntityConnection, T, R> R execute(FunctionType<C, T, R> var1);

    public <C extends EntityConnection, T, R> R execute(FunctionType<C, T, R> var1, T var2);

    public <C extends EntityConnection, T> void execute(ProcedureType<C, T> var1);

    public <C extends EntityConnection, T> void execute(ProcedureType<C, T> var1, T var2);

    public Entity.Key insert(Entity var1);

    public Entity insertSelect(Entity var1);

    public Collection<Entity.Key> insert(Collection<Entity> var1);

    public Collection<Entity> insertSelect(Collection<Entity> var1);

    public void update(Entity var1);

    public Entity updateSelect(Entity var1);

    public void update(Collection<Entity> var1);

    public Collection<Entity> updateSelect(Collection<Entity> var1);

    public int update(Update var1);

    public void delete(Entity.Key var1);

    public void delete(Collection<Entity.Key> var1);

    public int delete(Condition var1);

    public <T> List<T> select(Column<T> var1);

    public <T> List<T> select(Column<T> var1, Condition var2);

    public <T> List<T> select(Column<T> var1, Select var2);

    public Entity select(Entity.Key var1);

    public Entity selectSingle(Condition var1);

    public Entity selectSingle(Select var1);

    public Collection<Entity> select(Collection<Entity.Key> var1);

    public List<Entity> select(Condition var1);

    public List<Entity> select(Select var1);

    public Map<EntityType, Collection<Entity>> dependencies(Collection<Entity> var1);

    public int count(Count var1);

    public <T, R, P> R report(ReportType<T, R, P> var1, P var2);

    public static void transaction(EntityConnection connection, Transactional transactional) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(transactional);
        EntityConnection.transaction(connection, () -> {
            transactional.execute();
            return null;
        });
    }

    public static <T> T transaction(EntityConnection connection, TransactionalResult<T> transactional) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(transactional);
        connection.startTransaction();
        try {
            T result = transactional.execute();
            connection.commitTransaction();
            return result;
        }
        catch (Throwable e) {
            connection.rollbackTransaction();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static BatchCopy.Builder batchCopy(EntityConnection source, EntityConnection destination) {
        return new DefaultBatchCopy.DefaultBuilder(source, destination);
    }

    public static BatchInsert.Builder batchInsert(EntityConnection connection, Iterator<Entity> entities) {
        return new DefaultBatchInsert.DefaultBuilder(connection, entities);
    }

    public static interface Transactional {
        public void execute() throws Exception;
    }

    public static interface TransactionalResult<T> {
        public T execute() throws Exception;
    }

    public static interface Count {
        public Condition where();

        public Condition having();

        public static Count all(EntityType entityType) {
            return Count.where(Condition.all((EntityType)entityType));
        }

        public static Count where(Condition condition) {
            Objects.requireNonNull(condition);
            return new DefaultCount.DefaultBuilder(condition).build();
        }

        public static Count having(Condition condition) {
            Objects.requireNonNull(condition);
            return new DefaultCount.DefaultBuilder(Condition.all((EntityType)condition.entityType())).having(condition).build();
        }

        public static Builder builder(Condition where) {
            return new DefaultCount.DefaultBuilder(where);
        }

        public static interface Builder {
            public Builder having(Condition var1);

            public Count build();
        }
    }

    public static interface Update {
        public Condition where();

        public Map<Column<?>, Object> values();

        public static Builder all(EntityType entityType) {
            return new DefaultUpdate.DefaultBuilder(Condition.all((EntityType)entityType));
        }

        public static Builder where(Condition condition) {
            return new DefaultUpdate.DefaultBuilder(condition);
        }

        public static interface Builder {
            public <T> Builder set(Column<?> var1, T var2);

            public Update build();
        }
    }

    public static interface Select {
        public Condition where();

        public Condition having();

        public Optional<OrderBy> orderBy();

        public OptionalInt limit();

        public OptionalInt offset();

        public boolean forUpdate();

        public int queryTimeout();

        public OptionalInt fetchDepth();

        public OptionalInt fetchDepth(ForeignKey var1);

        public Map<ForeignKey, Integer> foreignKeyFetchDepths();

        public Collection<Attribute<?>> attributes();

        public static Builder all(EntityType entityType) {
            return new DefaultSelect.DefaultBuilder(Condition.all((EntityType)entityType));
        }

        public static Builder where(Condition condition) {
            return new DefaultSelect.DefaultBuilder(condition);
        }

        public static interface Builder {
            public Builder orderBy(OrderBy var1);

            public Builder limit(Integer var1);

            public Builder offset(Integer var1);

            public Builder forUpdate();

            public Builder fetchDepth(int var1);

            public Builder fetchDepth(ForeignKey var1, int var2);

            public <T extends Attribute<?>> Builder attributes(T ... var1);

            public Builder attributes(Collection<? extends Attribute<?>> var1);

            public Builder queryTimeout(int var1);

            public Builder having(Condition var1);

            public Select build();
        }
    }

    public static interface BatchInsert {
        public void execute();

        public static interface Builder {
            public Builder batchSize(int var1);

            public Builder progressReporter(Consumer<Integer> var1);

            public Builder onInsert(Consumer<Collection<Entity.Key>> var1);

            public void execute();

            public BatchInsert build();
        }
    }

    public static interface BatchCopy {
        public void execute();

        public static interface Builder {
            public Builder entityTypes(EntityType ... var1);

            public Builder conditions(Condition ... var1);

            public Builder batchSize(int var1);

            public Builder includePrimaryKeys(boolean var1);

            public void execute();

            public BatchCopy build();
        }
    }
}

