/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.common.db.connection.DatabaseConnection;
import is.codion.common.db.database.Database;
import is.codion.framework.domain.entity.AbstractQueriedKeyGenerator;
import is.codion.framework.domain.entity.Entity;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;

final class AutomaticKeyGenerator
extends AbstractQueriedKeyGenerator {
    private final String valueSource;

    AutomaticKeyGenerator(String valueSource) {
        this.valueSource = Objects.requireNonNull(valueSource, "valueSource");
    }

    @Override
    public boolean inserted() {
        return false;
    }

    @Override
    public void afterInsert(Entity entity, DatabaseConnection connection, Statement insertStatement) throws SQLException {
        this.selectAndPopulate(entity, entity.definition().primaryKey().columnDefinitions().get(0), connection);
    }

    @Override
    protected String query(Database database) {
        return database.autoIncrementQuery(this.valueSource);
    }
}

