/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.entity.DefaultKeyBuilder;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntitySerializer;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

class DefaultKey
implements Entity.Key,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, EntitySerializer> SERIALIZERS = new ConcurrentHashMap<String, EntitySerializer>();
    List<Column<?>> columns;
    boolean primaryKey;
    Map<Column<?>, Object> values;
    boolean singleIntegerKey;
    private Integer cachedHashCode = null;
    boolean hashCodeDirty = true;
    EntityDefinition definition;

    DefaultKey(EntityDefinition definition, List<Column<?>> columns, boolean primaryKey) {
        this(definition, DefaultKey.createNullValueMap(columns), primaryKey);
        this.hashCodeDirty = false;
    }

    DefaultKey(EntityDefinition definition, Column<?> column, Object value, boolean primaryKey) {
        this(definition, Collections.singletonMap(column, value), primaryKey);
    }

    DefaultKey(EntityDefinition definition, Map<Column<?>, Object> values, boolean primaryKey) {
        values.forEach((column, value) -> column.type().validateType(value));
        this.values = Collections.unmodifiableMap(values);
        this.columns = Collections.unmodifiableList(new ArrayList(values.keySet()));
        this.definition = definition;
        this.primaryKey = primaryKey;
        if (!this.columns.isEmpty()) {
            this.singleIntegerKey = this.columns.size() == 1 && this.columns.get(0).type().isInteger();
        }
    }

    @Override
    public EntityType entityType() {
        return this.definition.entityType();
    }

    @Override
    public EntityDefinition entityDefinition() {
        return this.definition;
    }

    @Override
    public Collection<Column<?>> columns() {
        return this.columns;
    }

    @Override
    public boolean primaryKey() {
        return this.primaryKey;
    }

    @Override
    public <T> Column<T> column() {
        this.assertSingleValueKey();
        return this.columns.get(0);
    }

    @Override
    public <T> T get() {
        this.assertSingleValueKey();
        return (T)this.values.get(this.columns.get(0));
    }

    @Override
    public <T> Optional<T> optional() {
        return Optional.ofNullable(this.get());
    }

    @Override
    public <T> T get(Column<T> column) {
        if (!this.values.containsKey(Objects.requireNonNull(column))) {
            throw new IllegalArgumentException("Column " + column + " is not part of key: " + this.definition.entityType());
        }
        return (T)this.values.get(this.definition.columns().definition(column).attribute());
    }

    @Override
    public <T> Optional<T> optional(Column<T> column) {
        return Optional.ofNullable(this.get(column));
    }

    @Override
    public Entity.Key.Builder copyBuilder() {
        return new DefaultKeyBuilder(this);
    }

    public String toString() {
        return this.columns.stream().map(attribute -> attribute.name() + ":" + this.values.get(attribute)).collect(Collectors.joining(","));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.values.isEmpty()) {
            return false;
        }
        if (object.getClass() == DefaultKey.class) {
            DefaultKey otherKey = (DefaultKey)object;
            if (this.isNull() || otherKey.isNull()) {
                return false;
            }
            if (this.columns.size() == 1 && otherKey.columns.size() == 1) {
                Column<?> column = this.columns.get(0);
                Column<?> otherColumn = otherKey.columns.get(0);
                return Objects.equals(this.values.get(column), otherKey.values.get(otherColumn)) && column.equals(otherColumn);
            }
            return this.values.equals(otherKey.values);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCodeDirty) {
            this.cachedHashCode = this.computeHashCode();
            this.hashCodeDirty = false;
        }
        return this.cachedHashCode == null ? 0 : this.cachedHashCode;
    }

    @Override
    public boolean isNull() {
        if (this.hashCodeDirty) {
            this.cachedHashCode = this.computeHashCode();
            this.hashCodeDirty = false;
        }
        return this.cachedHashCode == null;
    }

    @Override
    public boolean isNotNull() {
        return !this.isNull();
    }

    @Override
    public boolean isNull(Column<?> column) {
        return this.values.get(column) == null;
    }

    @Override
    public boolean isNotNull(Column<?> column) {
        return !this.isNull(column);
    }

    private Integer computeHashCode() {
        if (this.values.isEmpty()) {
            return null;
        }
        if (this.columns.size() > 1) {
            return this.computeMultipleValueHashCode();
        }
        return this.computeSingleValueHashCode();
    }

    private Integer computeMultipleValueHashCode() {
        int hash = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnDefinition<?> columnDefinition = this.definition.columns().definition(this.columns.get(i));
            Object value = this.values.get(columnDefinition.attribute());
            if (!columnDefinition.nullable() && value == null) {
                return null;
            }
            if (value == null) continue;
            hash += value.hashCode();
        }
        return hash;
    }

    private Integer computeSingleValueHashCode() {
        Object value = this.get();
        if (value == null) {
            return null;
        }
        if (this.singleIntegerKey) {
            return (Integer)value;
        }
        return value.hashCode();
    }

    private void assertSingleValueKey() {
        if (this.columns.isEmpty()) {
            throw new NoSuchElementException("Key contains no values");
        }
        if (this.columns.size() > 1) {
            throw new IllegalStateException("Key is a composite key");
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.definition.entityType().domainType().name());
        EntitySerializer.serialize(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        DefaultKey.serializerForDomain((String)stream.readObject()).deserialize(this, stream);
    }

    private static Map<Column<?>, Object> createNullValueMap(List<Column<?>> columns) {
        HashMap values = new HashMap(columns.size());
        for (Column<?> column : columns) {
            values.put(column, null);
        }
        return values;
    }

    static void setSerializer(String domainName, EntitySerializer serializer) {
        SERIALIZERS.put(Objects.requireNonNull(domainName), Objects.requireNonNull(serializer));
    }

    static EntitySerializer serializerForDomain(String domainName) {
        EntitySerializer serializer = SERIALIZERS.get(Objects.requireNonNull(domainName));
        if (serializer == null) {
            throw new IllegalArgumentException("No EntitySerializer found for domain: " + domainName);
        }
        return serializer;
    }
}

