/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.condition;

import is.codion.common.Operator;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import is.codion.framework.domain.entity.condition.DualValueColumnCondition;
import is.codion.framework.domain.entity.condition.MultiValueColumnCondition;
import is.codion.framework.domain.entity.condition.SingleValueColumnCondition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

final class DefaultColumnConditionFactory<T>
implements ColumnCondition.Factory<T> {
    private static final String VALUES_PARAMETER = "values";
    private final Column<T> column;

    DefaultColumnConditionFactory(Column<T> column) {
        this.column = Objects.requireNonNull(column, "column");
    }

    @Override
    public ColumnCondition<T> equalTo(T value) {
        if (value == null) {
            return this.isNull();
        }
        return new SingleValueColumnCondition<T>(this.column, value, Operator.EQUAL);
    }

    @Override
    public ColumnCondition<T> notEqualTo(T value) {
        if (value == null) {
            return this.isNotNull();
        }
        return new SingleValueColumnCondition<T>(this.column, value, Operator.NOT_EQUAL);
    }

    @Override
    public ColumnCondition<String> equalToIgnoreCase(String value) {
        if (value == null) {
            return this.isNull();
        }
        return new SingleValueColumnCondition<String>(this.column, value, Operator.EQUAL, false, false);
    }

    @Override
    public ColumnCondition<Character> equalToIgnoreCase(Character value) {
        if (value == null) {
            return this.isNull();
        }
        return new SingleValueColumnCondition<Character>(this.column, value, Operator.EQUAL, false, false);
    }

    @Override
    public ColumnCondition<String> notEqualToIgnoreCase(String value) {
        if (value == null) {
            return this.isNotNull();
        }
        return new SingleValueColumnCondition<String>(this.column, value, Operator.NOT_EQUAL, false, false);
    }

    @Override
    public ColumnCondition<Character> notEqualToIgnoreCase(Character value) {
        if (value == null) {
            return this.isNotNull();
        }
        return new SingleValueColumnCondition<Character>(this.column, value, Operator.NOT_EQUAL, false, false);
    }

    @Override
    public ColumnCondition<String> like(String value) {
        if (value == null) {
            return this.isNull();
        }
        return new SingleValueColumnCondition<String>(this.column, value, Operator.EQUAL, true, true);
    }

    @Override
    public ColumnCondition<String> notLike(String value) {
        if (value == null) {
            return this.isNotNull();
        }
        return new SingleValueColumnCondition<String>(this.column, value, Operator.NOT_EQUAL, true, true);
    }

    @Override
    public ColumnCondition<String> likeIgnoreCase(String value) {
        if (value == null) {
            return this.isNull();
        }
        return new SingleValueColumnCondition<String>(this.column, value, Operator.EQUAL, false, true);
    }

    @Override
    public ColumnCondition<String> notLikeIgnoreCase(String value) {
        if (value == null) {
            return this.isNotNull();
        }
        return new SingleValueColumnCondition<String>(this.column, value, Operator.NOT_EQUAL, false, true);
    }

    @Override
    public ColumnCondition<T> in(T ... values) {
        return this.in((Collection<? extends T>)Arrays.asList(Objects.requireNonNull(values, VALUES_PARAMETER)));
    }

    @Override
    public ColumnCondition<T> notIn(T ... values) {
        return this.notIn((Collection<? extends T>)Arrays.asList(Objects.requireNonNull(values, VALUES_PARAMETER)));
    }

    @Override
    public ColumnCondition<T> in(Collection<? extends T> values) {
        return new MultiValueColumnCondition<T>(this.column, values, Operator.EQUAL);
    }

    @Override
    public ColumnCondition<T> notIn(Collection<? extends T> values) {
        return new MultiValueColumnCondition<T>(this.column, values, Operator.NOT_EQUAL);
    }

    @Override
    public ColumnCondition<String> inIgnoreCase(String ... values) {
        return this.inIgnoreCase(Arrays.asList(Objects.requireNonNull(values, VALUES_PARAMETER)));
    }

    @Override
    public ColumnCondition<String> notInIgnoreCase(String ... values) {
        return this.notInIgnoreCase(Arrays.asList(Objects.requireNonNull(values, VALUES_PARAMETER)));
    }

    @Override
    public ColumnCondition<String> inIgnoreCase(Collection<String> values) {
        return new MultiValueColumnCondition<String>(this.column, values, Operator.EQUAL, false);
    }

    @Override
    public ColumnCondition<String> notInIgnoreCase(Collection<String> values) {
        return new MultiValueColumnCondition<String>(this.column, values, Operator.NOT_EQUAL, false);
    }

    @Override
    public ColumnCondition<T> lessThan(T value) {
        return new SingleValueColumnCondition<T>(this.column, value, Operator.LESS_THAN);
    }

    @Override
    public ColumnCondition<T> lessThanOrEqualTo(T value) {
        return new SingleValueColumnCondition<T>(this.column, value, Operator.LESS_THAN_OR_EQUAL);
    }

    @Override
    public ColumnCondition<T> greaterThan(T value) {
        return new SingleValueColumnCondition<T>(this.column, value, Operator.GREATER_THAN);
    }

    @Override
    public ColumnCondition<T> greaterThanOrEqualTo(T value) {
        return new SingleValueColumnCondition<T>(this.column, value, Operator.GREATER_THAN_OR_EQUAL);
    }

    @Override
    public ColumnCondition<T> betweenExclusive(T lowerBound, T upperBound) {
        return new DualValueColumnCondition<T>(this.column, lowerBound, upperBound, Operator.BETWEEN_EXCLUSIVE);
    }

    @Override
    public ColumnCondition<T> between(T lowerBound, T upperBound) {
        return new DualValueColumnCondition<T>(this.column, lowerBound, upperBound, Operator.BETWEEN);
    }

    @Override
    public ColumnCondition<T> notBetweenExclusive(T lowerBound, T upperBound) {
        return new DualValueColumnCondition<T>(this.column, lowerBound, upperBound, Operator.NOT_BETWEEN_EXCLUSIVE);
    }

    @Override
    public ColumnCondition<T> notBetween(T lowerBound, T upperBound) {
        return new DualValueColumnCondition<T>(this.column, lowerBound, upperBound, Operator.NOT_BETWEEN);
    }

    @Override
    public ColumnCondition<T> isNull() {
        return new SingleValueColumnCondition<Object>(this.column, null, Operator.EQUAL);
    }

    @Override
    public ColumnCondition<T> isNotNull() {
        return new SingleValueColumnCondition<Object>(this.column, null, Operator.NOT_EQUAL);
    }
}

