/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.condition;

import is.codion.common.Conjunction;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.AbstractCondition;
import is.codion.framework.domain.entity.condition.Condition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class DefaultConditionCombination
extends AbstractCondition
implements Condition.Combination,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Condition> conditions;
    private final Conjunction conjunction;

    DefaultConditionCombination(Conjunction conjunction, Collection<Condition> conditions) {
        super(DefaultConditionCombination.entityType(conditions), DefaultConditionCombination.columns(conditions), DefaultConditionCombination.values(conditions));
        this.conjunction = Objects.requireNonNull(conjunction);
        this.conditions = Collections.unmodifiableList(new ArrayList<Condition>(conditions));
    }

    @Override
    public Collection<Condition> conditions() {
        return this.conditions;
    }

    @Override
    public Conjunction conjunction() {
        return this.conjunction;
    }

    @Override
    public String toString(EntityDefinition definition) {
        Objects.requireNonNull(definition);
        if (this.conditions.isEmpty()) {
            return "";
        }
        if (this.conditions.size() == 1) {
            return this.conditions.get(0).toString(definition);
        }
        return this.conditions.stream().map(condition -> condition.toString(definition)).filter(string -> !string.isEmpty()).collect(Collectors.joining(DefaultConditionCombination.toString(this.conjunction), "(", ")"));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultConditionCombination)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DefaultConditionCombination that = (DefaultConditionCombination)object;
        return this.conjunction == that.conjunction && this.conditions.equals(that.conditions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.conditions, this.conjunction);
    }

    public String toString() {
        return "DefaultConditionCombination{conditions=" + this.conditions + ", conjunction=" + this.conjunction + "}";
    }

    private static String toString(Conjunction conjunction) {
        switch (conjunction) {
            case AND: {
                return " AND ";
            }
            case OR: {
                return " OR ";
            }
        }
        throw new IllegalArgumentException("Unknown conjunction: " + conjunction);
    }

    private static EntityType entityType(Collection<Condition> conditions) {
        if (Objects.requireNonNull(conditions).isEmpty()) {
            throw new IllegalArgumentException("One or more conditions must be specified for a condition combination");
        }
        return conditions.iterator().next().entityType();
    }

    private static List<?> values(Collection<Condition> conditions) {
        return conditions.stream().flatMap(condition -> condition.values().stream()).collect(Collectors.toList());
    }

    private static List<Column<?>> columns(Collection<Condition> conditions) {
        return conditions.stream().flatMap(condition -> condition.columns().stream()).collect(Collectors.toList());
    }
}

