/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.condition;

import is.codion.common.Conjunction;
import is.codion.common.Operator;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.domain.entity.condition.DefaultColumnConditionFactory;
import is.codion.framework.domain.entity.condition.DefaultConditionCombination;
import is.codion.framework.domain.entity.condition.ForeignKeyCondition;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DefaultForeignKeyConditionFactory
implements ForeignKeyCondition.Factory {
    private static final String VALUES_PARAMETER = "values";
    private final ForeignKey foreignKey;

    DefaultForeignKeyConditionFactory(ForeignKey foreignKey) {
        this.foreignKey = Objects.requireNonNull(foreignKey, "foreignKey");
    }

    @Override
    public Condition equalTo(Entity value) {
        if (value == null) {
            return this.isNull();
        }
        List<ForeignKey.Reference<?>> references = this.foreignKey.references();
        if (references.size() == 1) {
            ForeignKey.Reference<?> reference2 = references.get(0);
            return new DefaultColumnConditionFactory(reference2.column()).equalTo(value.get(reference2.foreign()));
        }
        List<Condition> conditions = references.stream().map(reference -> reference).map(reference -> new DefaultColumnConditionFactory(reference.column()).equalTo(value.get(reference.foreign()))).collect(Collectors.toList());
        return new DefaultConditionCombination(Conjunction.AND, conditions);
    }

    @Override
    public Condition notEqualTo(Entity value) {
        if (value == null) {
            return this.isNotNull();
        }
        List<ForeignKey.Reference<?>> references = this.foreignKey.references();
        if (references.size() == 1) {
            ForeignKey.Reference<?> reference2 = references.get(0);
            return new DefaultColumnConditionFactory(reference2.column()).notEqualTo(value.get(reference2.foreign()));
        }
        List<Condition> conditions = references.stream().map(reference -> reference).map(reference -> new DefaultColumnConditionFactory(reference.column()).notEqualTo(value.get(reference.foreign()))).collect(Collectors.toList());
        return new DefaultConditionCombination(Conjunction.AND, conditions);
    }

    @Override
    public Condition in(Entity ... values) {
        return this.in(Arrays.asList(Objects.requireNonNull(values, VALUES_PARAMETER)));
    }

    @Override
    public Condition notIn(Entity ... values) {
        return this.notIn(Arrays.asList(Objects.requireNonNull(values, VALUES_PARAMETER)));
    }

    @Override
    public Condition in(Collection<? extends Entity> values) {
        return DefaultForeignKeyConditionFactory.foreignKeyCondition(this.foreignKey, Operator.EQUAL, this.createValueMaps(values));
    }

    @Override
    public Condition notIn(Collection<? extends Entity> values) {
        return DefaultForeignKeyConditionFactory.foreignKeyCondition(this.foreignKey, Operator.NOT_EQUAL, this.createValueMaps(values));
    }

    @Override
    public Condition isNull() {
        List columns = this.foreignKey.references().stream().map(ForeignKey.Reference::column).collect(Collectors.toList());
        if (columns.size() == 1) {
            Column column2 = (Column)columns.get(0);
            return new DefaultColumnConditionFactory(column2).isNull();
        }
        List<Condition> conditions = columns.stream().map(column -> column).map(column -> new DefaultColumnConditionFactory(column).isNull()).collect(Collectors.toList());
        return new DefaultConditionCombination(Conjunction.AND, conditions);
    }

    @Override
    public Condition isNotNull() {
        List columns = this.foreignKey.references().stream().map(ForeignKey.Reference::column).collect(Collectors.toList());
        if (columns.size() == 1) {
            Column column2 = (Column)columns.get(0);
            return new DefaultColumnConditionFactory(column2).isNotNull();
        }
        List<Condition> conditions = columns.stream().map(column -> column).map(column -> new DefaultColumnConditionFactory(column).isNotNull()).collect(Collectors.toList());
        return new DefaultConditionCombination(Conjunction.AND, conditions);
    }

    private List<Map<Column<?>, ?>> createValueMaps(Collection<? extends Entity> values) {
        List referencedColumns = this.foreignKey.references().stream().map(ForeignKey.Reference::foreign).collect(Collectors.toList());
        return values.stream().map(entity -> DefaultForeignKeyConditionFactory.valueMap(entity, referencedColumns)).collect(Collectors.toList());
    }

    static Condition compositeKeyCondition(Map<Column<?>, Column<?>> columnReferenceMap, Operator operator, List<Map<Column<?>, ?>> valueMaps) {
        if (valueMaps.size() == 1) {
            return DefaultForeignKeyConditionFactory.compositeEqualCondition(columnReferenceMap, operator, valueMaps.get(0));
        }
        List<Condition> conditions = valueMaps.stream().map(valueMap -> DefaultForeignKeyConditionFactory.compositeEqualCondition(columnReferenceMap, operator, valueMap)).collect(Collectors.toList());
        return new DefaultConditionCombination(Conjunction.OR, conditions);
    }

    static Condition compositeEqualCondition(Map<Column<?>, Column<?>> columnReferenceMap, Operator operator, Map<Column<?>, ?> valueMap) {
        List<Condition> conditions = columnReferenceMap.entrySet().stream().map(entry -> DefaultForeignKeyConditionFactory.equalCondition((Column)entry.getKey(), operator, valueMap.get(entry.getValue()))).collect(Collectors.toList());
        return new DefaultConditionCombination(Conjunction.AND, conditions);
    }

    private static Condition foreignKeyCondition(ForeignKey foreignKey, Operator operator, List<Map<Column<?>, ?>> valueMaps) {
        if (foreignKey.references().size() > 1) {
            return DefaultForeignKeyConditionFactory.compositeKeyCondition(DefaultForeignKeyConditionFactory.columnReferenceMap(foreignKey.references()), operator, valueMaps);
        }
        List<Object> values = valueMaps.stream().map(map -> map.get(foreignKey.references().get(0).foreign())).collect(Collectors.toList());
        return DefaultForeignKeyConditionFactory.inCondition(foreignKey.references().get(0), operator, values);
    }

    private static Map<Column<?>, Column<?>> columnReferenceMap(List<ForeignKey.Reference<?>> references) {
        return references.stream().collect(Collectors.toMap(ForeignKey.Reference::column, ForeignKey.Reference::foreign, (column, column2) -> column, LinkedHashMap::new));
    }

    private static Map<Column<?>, Object> valueMap(Entity entity, List<Column<?>> columns) {
        return columns.stream().collect(Collectors.toMap(Function.identity(), entity::get));
    }

    private static ColumnCondition<Object> inCondition(ForeignKey.Reference<?> reference, Operator operator, List<Object> values) {
        Column<?> column = reference.column();
        switch (operator) {
            case EQUAL: {
                return column.in((Collection<?>)values);
            }
            case NOT_EQUAL: {
                return column.notIn((Collection<?>)values);
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + operator);
    }

    private static Condition equalCondition(Column<?> conditionColumn, Operator operator, Object value) {
        Column<?> column = conditionColumn;
        switch (operator) {
            case EQUAL: {
                return column.equalTo(value);
            }
            case NOT_EQUAL: {
                return column.notEqualTo(value);
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + operator);
    }
}

