/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.DefaultEntityBuilder;
import is.codion.framework.domain.entity.DefaultEntityDefinition;
import is.codion.framework.domain.entity.DefaultKey;
import is.codion.framework.domain.entity.DefaultKeyBuilder;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntitySerializer;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class DefaultEntities
implements Entities,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DomainType domainType;
    private final Map<String, DefaultEntityDefinition> entityDefinitions = new LinkedHashMap<String, DefaultEntityDefinition>();
    private transient boolean strictForeignKeys = (Boolean)STRICT_FOREIGN_KEYS.get();

    protected DefaultEntities(DomainType domainType) {
        this.domainType = Objects.requireNonNull(domainType, "domainType");
        DefaultKey.setSerializer(domainType.name(), DefaultEntities.createSerializer(this));
    }

    @Override
    public final DomainType domainType() {
        return this.domainType;
    }

    @Override
    public final EntityDefinition definition(EntityType entityType) {
        return this.definitionInternal(Objects.requireNonNull(entityType, "entityType").name());
    }

    @Override
    public final EntityDefinition definition(String entityTypeName) {
        return this.definitionInternal(Objects.requireNonNull(entityTypeName, "entityTypeName"));
    }

    @Override
    public final boolean contains(EntityType entityType) {
        return this.entityDefinitions.containsKey(Objects.requireNonNull(entityType).name());
    }

    @Override
    public final Collection<EntityDefinition> definitions() {
        return Collections.unmodifiableCollection(this.entityDefinitions.values());
    }

    @Override
    public final Entity entity(EntityType entityType) {
        return this.definition(entityType).entity();
    }

    @Override
    public final Entity.Builder builder(EntityType entityType) {
        return new DefaultEntityBuilder(this.definition(entityType));
    }

    @Override
    public final <T> Entity.Key primaryKey(EntityType entityType, T value) {
        return this.definition(entityType).primaryKey(value);
    }

    @Override
    public final <T> List<Entity.Key> primaryKeys(EntityType entityType, T ... values) {
        EntityDefinition definition = this.definition(entityType);
        return Arrays.stream(Objects.requireNonNull(values, "values")).map(definition::primaryKey).collect(Collectors.toList());
    }

    @Override
    public final Entity.Key.Builder keyBuilder(EntityType entityType) {
        return new DefaultKeyBuilder(this.definition(entityType));
    }

    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.domainType;
    }

    protected final void setStrictForeignKeys(boolean strictForeignKeys) {
        this.strictForeignKeys = strictForeignKeys;
    }

    protected final void add(EntityDefinition definition) {
        if (this.entityDefinitions.containsKey(definition.entityType().name())) {
            throw new IllegalArgumentException("Entity has already been defined: " + definition.entityType() + ", for table: " + definition.tableName());
        }
        this.validateForeignKeys(definition);
        this.entityDefinitions.put(definition.entityType().name(), (DefaultEntityDefinition)definition);
        this.populateForeignDefinitions();
    }

    private EntityDefinition definitionInternal(String entityTypeName) {
        EntityDefinition definition = this.entityDefinitions.get(entityTypeName);
        if (definition == null) {
            throw new IllegalArgumentException("Undefined entity: " + entityTypeName);
        }
        return definition;
    }

    private void validateForeignKeys(EntityDefinition definition) {
        EntityType entityType = definition.entityType();
        for (ForeignKey foreignKey : definition.foreignKeys().get()) {
            EntityDefinition referencedEntity;
            EntityType referencedType = foreignKey.referencedType();
            EntityDefinition entityDefinition = referencedEntity = referencedType.equals(entityType) ? definition : (EntityDefinition)this.entityDefinitions.get(referencedType.name());
            if (referencedEntity == null && this.strictForeignKeys) {
                throw new IllegalArgumentException("Entity '" + referencedType + "' referenced by entity '" + entityType + "' via foreign key '" + foreignKey + "' has not been defined");
            }
            if (referencedEntity == null) continue;
            foreignKey.references().stream().map(ForeignKey.Reference::foreign).forEach(referencedAttribute -> DefaultEntities.validateReference(foreignKey, referencedAttribute, referencedEntity));
        }
    }

    private void populateForeignDefinitions() {
        for (DefaultEntityDefinition definition : this.entityDefinitions.values()) {
            for (ForeignKey foreignKey : definition.foreignKeys().get()) {
                EntityDefinition referencedDefinition = this.entityDefinitions.get(foreignKey.referencedType().name());
                if (referencedDefinition == null || definition.hasReferencedEntityDefinition(foreignKey)) continue;
                definition.setReferencedEntityDefinition(foreignKey, referencedDefinition);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        DefaultKey.setSerializer(this.domainType.name(), DefaultEntities.createSerializer(this));
    }

    private static EntitySerializer createSerializer(Entities entities) {
        return new EntitySerializer(entities, (Boolean)STRICT_DESERIALIZATION.get());
    }

    private static void validateReference(ForeignKey foreignKey, Attribute<?> referencedAttribute, EntityDefinition referencedEntity) {
        if (!referencedEntity.attributes().contains(referencedAttribute)) {
            throw new IllegalArgumentException("Attribute " + referencedAttribute + " referenced by foreign key " + foreignKey + " not found in referenced entity");
        }
    }
}

