/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityValidator;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.exception.ItemValidationException;
import is.codion.framework.domain.entity.exception.LengthValidationException;
import is.codion.framework.domain.entity.exception.NullValidationException;
import is.codion.framework.domain.entity.exception.RangeValidationException;
import is.codion.framework.domain.entity.exception.ValidationException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class DefaultEntityValidator
implements EntityValidator,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(DefaultEntityValidator.class.getName());
    private static final String ENTITY_PARAM = "entity";
    private static final String ATTRIBUTE_PARAM = "attribute";
    private static final String VALUE_REQUIRED_KEY = "value_is_required";
    private static final String INVALID_ITEM_VALUE_KEY = "invalid_item_value";
    private final boolean strictValidation;

    public DefaultEntityValidator() {
        this((Boolean)STRICT_VALIDATION.get());
    }

    public DefaultEntityValidator(boolean strictValidation) {
        this.strictValidation = strictValidation;
    }

    @Override
    public boolean valid(Entity entity) {
        try {
            this.validate(entity);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public <T> boolean nullable(Entity entity, Attribute<T> attribute) {
        return Objects.requireNonNull(entity).definition().attributes().definition(attribute).nullable();
    }

    @Override
    public void validate(Entity entity) throws ValidationException {
        Objects.requireNonNull(entity, ENTITY_PARAM);
        List attributes = entity.definition().attributes().definitions().stream().filter(definition -> this.validationRequired(entity, (AttributeDefinition<?>)definition)).map(AttributeDefinition::attribute).collect(Collectors.toList());
        for (Attribute attribute : attributes) {
            this.validate(entity, attribute);
        }
    }

    @Override
    public <T> void validate(Entity entity, Attribute<T> attribute) throws ValidationException {
        Objects.requireNonNull(entity, ENTITY_PARAM);
        Objects.requireNonNull(attribute, ATTRIBUTE_PARAM);
        AttributeDefinition<T> definition = entity.definition().attributes().definition(attribute);
        if (!(attribute instanceof Column) || !entity.definition().foreignKeys().foreignKeyColumn((Column)attribute)) {
            this.performNullValidation(entity, definition);
        }
        if (!definition.items().isEmpty()) {
            this.performItemValidation(entity, definition);
        }
        if (attribute.type().isNumerical()) {
            DefaultEntityValidator.performRangeValidation(entity, attribute);
        } else if (attribute.type().isString()) {
            DefaultEntityValidator.performLengthValidation(entity, attribute);
        }
    }

    private boolean validationRequired(Entity entity, AttributeDefinition<?> definition) {
        if (definition.derived()) {
            return false;
        }
        if (definition instanceof ColumnDefinition && ((ColumnDefinition)definition).readOnly()) {
            return false;
        }
        if (!entity.exists() || this.strictValidation) {
            return true;
        }
        return entity.modified(definition.attribute());
    }

    private <T> void performNullValidation(Entity entity, AttributeDefinition<T> attributeDefinition) throws NullValidationException {
        Objects.requireNonNull(entity, ENTITY_PARAM);
        Objects.requireNonNull(attributeDefinition, "attributeDefinition");
        Attribute<T> attribute = attributeDefinition.attribute();
        if (!this.nullable(entity, attribute) && entity.isNull(attribute)) {
            if ((entity.primaryKey().isNull() || entity.originalPrimaryKey().isNull()) && !(attributeDefinition instanceof ForeignKeyDefinition)) {
                boolean nonKeyColumnWithoutDefaultValue = DefaultEntityValidator.isNonKeyColumnWithoutDefaultValue(attributeDefinition);
                boolean primaryKeyColumnWithoutAutoGenerate = DefaultEntityValidator.isNonGeneratedPrimaryKeyColumn(entity.definition(), attributeDefinition);
                if (nonKeyColumnWithoutDefaultValue || primaryKeyColumnWithoutAutoGenerate) {
                    throw new NullValidationException(attribute, MessageFormat.format(MESSAGES.getString(VALUE_REQUIRED_KEY), attributeDefinition.caption()));
                }
            } else {
                throw new NullValidationException(attribute, MessageFormat.format(MESSAGES.getString(VALUE_REQUIRED_KEY), attributeDefinition.caption()));
            }
        }
    }

    private <T> void performItemValidation(Entity entity, AttributeDefinition<T> attributeDefinition) throws ItemValidationException {
        if (entity.isNull(attributeDefinition.attribute()) && this.nullable(entity, attributeDefinition.attribute())) {
            return;
        }
        T value = entity.get(attributeDefinition.attribute());
        if (!attributeDefinition.validItem(value)) {
            throw new ItemValidationException(attributeDefinition.attribute(), value, MESSAGES.getString(INVALID_ITEM_VALUE_KEY) + ": " + value);
        }
    }

    private static <T extends Number> void performRangeValidation(Entity entity, Attribute<T> attribute) throws RangeValidationException {
        Objects.requireNonNull(entity, ENTITY_PARAM);
        Objects.requireNonNull(attribute, ATTRIBUTE_PARAM);
        if (entity.isNull(attribute)) {
            return;
        }
        AttributeDefinition<T> definition = entity.definition().attributes().definition(attribute);
        Number value = (Number)entity.get(definition.attribute());
        Number minimumValue = definition.minimumValue();
        if (minimumValue != null && value.doubleValue() < minimumValue.doubleValue()) {
            throw new RangeValidationException(definition.attribute(), value, "'" + definition.caption() + "' " + MESSAGES.getString("value_too_small") + " " + minimumValue);
        }
        Number maximumValue = definition.maximumValue();
        if (maximumValue != null && value.doubleValue() > maximumValue.doubleValue()) {
            throw new RangeValidationException(definition.attribute(), value, "'" + definition.caption() + "' " + MESSAGES.getString("value_too_large") + " " + maximumValue);
        }
    }

    private static void performLengthValidation(Entity entity, Attribute<String> attribute) throws LengthValidationException {
        Objects.requireNonNull(entity, ENTITY_PARAM);
        Objects.requireNonNull(attribute, ATTRIBUTE_PARAM);
        if (entity.isNull(attribute)) {
            return;
        }
        AttributeDefinition<String> definition = entity.definition().attributes().definition(attribute);
        int maximumLength = definition.maximumLength();
        String value = entity.get(attribute);
        if (maximumLength != -1 && value.length() > maximumLength) {
            throw new LengthValidationException(definition.attribute(), value, "'" + definition.caption() + "' " + MESSAGES.getString("value_too_long") + " " + maximumLength + "\n:'" + value + "'");
        }
    }

    private static boolean isNonGeneratedPrimaryKeyColumn(EntityDefinition definition, AttributeDefinition<?> attributeDefinition) {
        return attributeDefinition instanceof ColumnDefinition && ((ColumnDefinition)attributeDefinition).primaryKey() && !definition.primaryKey().generated();
    }

    private static boolean isNonKeyColumnWithoutDefaultValue(AttributeDefinition<?> definition) {
        return definition instanceof ColumnDefinition && !((ColumnDefinition)definition).primaryKey() && !((ColumnDefinition)definition).columnHasDefaultValue();
    }
}

