/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.attribute;

import is.codion.common.Text;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.DefaultDerivedAttributeDefinition;
import is.codion.framework.domain.entity.attribute.DefaultTransientAttributeDefinition;
import is.codion.framework.domain.entity.attribute.DenormalizedValueProvider;
import is.codion.framework.domain.entity.attribute.DerivedAttribute;
import is.codion.framework.domain.entity.attribute.TransientAttributeDefinition;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.Objects;

final class DefaultAttribute<T>
implements Attribute<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final DefaultType<T> type;
    private final int hashCode;

    DefaultAttribute(String name, Class<T> valueClass, EntityType entityType) {
        if (Text.nullOrEmpty((String)name)) {
            throw new IllegalArgumentException("name must be a non-empty string");
        }
        Objects.requireNonNull(entityType, "entityType");
        Objects.requireNonNull(valueClass, "valueClass");
        this.name = name;
        this.type = new DefaultType<T>(entityType, valueClass);
        this.hashCode = Objects.hash(name, entityType);
    }

    @Override
    public Attribute.AttributeDefiner<T> define() {
        return new DefaultAttributeDefiner(this);
    }

    @Override
    public Attribute.Type<T> type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public EntityType entityType() {
        return this.type.entityType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultAttribute)) {
            return false;
        }
        DefaultAttribute that = (DefaultAttribute)object;
        return this.hashCode == that.hashCode && this.name.equals(that.name) && this.type.entityType.equals(that.type.entityType);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.type.entityType.name() + "." + this.name;
    }

    private static final class DefaultType<T>
    implements Attribute.Type<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final EntityType entityType;
        private final Class<T> valueClass;

        private DefaultType(EntityType entityType, Class<T> valueClass) {
            this.entityType = entityType;
            this.valueClass = valueClass;
        }

        @Override
        public Class<T> valueClass() {
            return this.valueClass;
        }

        @Override
        public T validateType(T value) {
            if (value != null && this.valueClass != value.getClass() && !this.valueClass.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Value of type " + this.valueClass + " expected for attribute " + this + " in entity " + this.entityType + ", got: " + value.getClass());
            }
            return value;
        }

        @Override
        public boolean isNumerical() {
            return Number.class.isAssignableFrom(this.valueClass);
        }

        @Override
        public boolean isTemporal() {
            return Temporal.class.isAssignableFrom(this.valueClass);
        }

        @Override
        public boolean isLocalDate() {
            return this.isType(LocalDate.class);
        }

        @Override
        public boolean isLocalDateTime() {
            return this.isType(LocalDateTime.class);
        }

        @Override
        public boolean isLocalTime() {
            return this.isType(LocalTime.class);
        }

        @Override
        public boolean isOffsetDateTime() {
            return this.isType(OffsetDateTime.class);
        }

        @Override
        public boolean isCharacter() {
            return this.isType(Character.class);
        }

        @Override
        public boolean isString() {
            return this.isType(String.class);
        }

        @Override
        public boolean isLong() {
            return this.isType(Long.class);
        }

        @Override
        public boolean isInteger() {
            return this.isType(Integer.class);
        }

        @Override
        public boolean isShort() {
            return this.isType(Short.class);
        }

        @Override
        public boolean isDouble() {
            return this.isType(Double.class);
        }

        @Override
        public boolean isBigDecimal() {
            return this.isType(BigDecimal.class);
        }

        @Override
        public boolean isDecimal() {
            return this.isDouble() || this.isBigDecimal();
        }

        @Override
        public boolean isBoolean() {
            return this.isType(Boolean.class);
        }

        @Override
        public boolean isByteArray() {
            return this.isType(byte[].class);
        }

        @Override
        public boolean isEnum() {
            return this.valueClass.isEnum();
        }

        @Override
        public boolean isEntity() {
            return this.isType(Entity.class);
        }

        private boolean isType(Class<?> valueClass) {
            return this.valueClass.equals(valueClass);
        }
    }

    static class DefaultAttributeDefiner<T>
    implements Attribute.AttributeDefiner<T> {
        private final Attribute<T> attribute;

        DefaultAttributeDefiner(Attribute<T> attribute) {
            this.attribute = attribute;
        }

        @Override
        public final <B extends TransientAttributeDefinition.Builder<T, B>> TransientAttributeDefinition.Builder<T, B> attribute() {
            return new DefaultTransientAttributeDefinition.DefaultTransientAttributeDefinitionBuilder(this.attribute);
        }

        @Override
        public final <B extends AttributeDefinition.Builder<T, B>> AttributeDefinition.Builder<T, B> denormalized(Attribute<Entity> entityAttribute, Attribute<T> denormalizedAttribute) {
            return new DefaultDerivedAttributeDefinition.DefaultDerivedAttributeDefinitionBuilder(this.attribute, new DenormalizedValueProvider<T>(entityAttribute, denormalizedAttribute), entityAttribute);
        }

        @Override
        public final <B extends AttributeDefinition.Builder<T, B>> AttributeDefinition.Builder<T, B> derived(DerivedAttribute.Provider<T> valueProvider, Attribute<?> ... sourceAttributes) {
            return new DefaultDerivedAttributeDefinition.DefaultDerivedAttributeDefinitionBuilder(this.attribute, valueProvider, sourceAttributes);
        }
    }
}

