/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.query;

import is.codion.framework.domain.entity.query.SelectQuery;
import java.util.Objects;

final class DefaultSelectQuery
implements SelectQuery {
    private final String columns;
    private final String from;
    private final String where;
    private final String groupBy;
    private final String having;
    private final String orderBy;

    DefaultSelectQuery(DefaultSelectQueryBuilder builder) {
        this.columns = builder.columns;
        this.from = builder.from;
        this.where = builder.where;
        this.groupBy = builder.groupBy;
        this.having = builder.having;
        this.orderBy = builder.orderBy;
    }

    @Override
    public String columns() {
        return this.columns;
    }

    @Override
    public String from() {
        return this.from;
    }

    @Override
    public String where() {
        return this.where;
    }

    @Override
    public String groupBy() {
        return this.groupBy;
    }

    @Override
    public String having() {
        return this.having;
    }

    @Override
    public String orderBy() {
        return this.orderBy;
    }

    static class DefaultSelectQueryBuilder
    implements SelectQuery.Builder {
        private String from;
        private String columns;
        private String where;
        private String groupBy;
        private String having;
        private String orderBy;

        DefaultSelectQueryBuilder() {
        }

        @Override
        public SelectQuery.Builder columns(String columns) {
            if (Objects.requireNonNull(columns, "columns").trim().toLowerCase().startsWith("select")) {
                throw new IllegalArgumentException("columns clause should not include the 'SELECT' keyword");
            }
            this.columns = columns;
            return this;
        }

        @Override
        public SelectQuery.Builder from(String from) {
            if (Objects.requireNonNull(from, "from").trim().toLowerCase().startsWith("from")) {
                throw new IllegalArgumentException("from clause should not include the 'FROM' keyword");
            }
            this.from = from;
            return this;
        }

        @Override
        public SelectQuery.Builder where(String where) {
            if (Objects.requireNonNull(where, "where").trim().toLowerCase().startsWith("where")) {
                throw new IllegalArgumentException("where clause should not include the 'WHERE' keyword");
            }
            this.where = where;
            return this;
        }

        @Override
        public SelectQuery.Builder groupBy(String groupBy) {
            if (Objects.requireNonNull(groupBy, "groupBy").trim().toLowerCase().startsWith("group by")) {
                throw new IllegalArgumentException("group by clause should not include the 'GROUP BY' keywords");
            }
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public SelectQuery.Builder having(String having) {
            if (Objects.requireNonNull(having, "having").trim().toLowerCase().startsWith("having")) {
                throw new IllegalArgumentException("having clause should not include the 'HAVING' keywords");
            }
            this.having = having;
            return this;
        }

        @Override
        public SelectQuery.Builder orderBy(String orderBy) {
            if (Objects.requireNonNull(orderBy, "orderBy").trim().toLowerCase().startsWith("order by")) {
                throw new IllegalArgumentException("orderBy clause should not include the 'ORDER BY' keywords");
            }
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public SelectQuery build() {
            return new DefaultSelectQuery(this);
        }
    }
}

