/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.db;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

final class UpdateDeserializer
extends StdDeserializer<EntityConnection.Update> {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;

    UpdateDeserializer(EntityObjectMapper entityObjectMapper) {
        super(EntityConnection.Update.class);
        this.entityObjectMapper = entityObjectMapper;
    }

    public EntityConnection.Update deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode jsonNode = (JsonNode)parser.getCodec().readTree(parser);
        EntityType entityType = this.entityObjectMapper.entities().domainType().entityType(jsonNode.get("entityType").asText());
        EntityDefinition definition = this.entityObjectMapper.entities().definition(entityType);
        JsonNode conditionNode = jsonNode.get("condition");
        Condition condition = this.entityObjectMapper.deserializeCondition(definition, conditionNode);
        EntityConnection.Update.Builder updateBuilder = EntityConnection.Update.where((Condition)condition);
        JsonNode values = jsonNode.get("values");
        Iterator fields = values.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            Column column = definition.columns().definition((Column)definition.attributes().get((String)field.getKey())).attribute();
            updateBuilder.set(column, this.entityObjectMapper.readValue(((JsonNode)field.getValue()).toString(), column.type().valueClass()));
        }
        return updateBuilder.build();
    }
}

