/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.databind.JsonNode;
import is.codion.common.Operator;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class ColumnConditionDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;

    ColumnConditionDeserializer(EntityObjectMapper entityObjectMapper) {
        this.entityObjectMapper = Objects.requireNonNull(entityObjectMapper);
    }

    <T> ColumnCondition<T> deserialize(EntityDefinition definition, JsonNode conditionNode) throws IOException {
        String columnName = conditionNode.get("column").asText();
        ColumnDefinition columnDefinition = definition.columns().definition((Column)definition.attributes().get(columnName));
        boolean caseSensitive = conditionNode.get("caseSensitive").asBoolean();
        JsonNode valuesNode = conditionNode.get("values");
        ArrayList<Object> values = new ArrayList<Object>();
        for (JsonNode valueNode : valuesNode) {
            values.add(this.entityObjectMapper.readValue(valueNode.toString(), columnDefinition.attribute().type().valueClass()));
        }
        Column column = columnDefinition.attribute();
        switch (Operator.valueOf((String)conditionNode.get("operator").asText())) {
            case EQUAL: {
                return ColumnConditionDeserializer.equalColumnCondition(values, column, caseSensitive);
            }
            case NOT_EQUAL: {
                return ColumnConditionDeserializer.notEqualColumnCondition(values, column, caseSensitive);
            }
            case LESS_THAN: {
                return column.lessThan(values.get(0));
            }
            case LESS_THAN_OR_EQUAL: {
                return column.lessThanOrEqualTo(values.get(0));
            }
            case GREATER_THAN: {
                return column.greaterThan(values.get(0));
            }
            case GREATER_THAN_OR_EQUAL: {
                return column.greaterThanOrEqualTo(values.get(0));
            }
            case BETWEEN_EXCLUSIVE: {
                return column.betweenExclusive(values.get(0), values.get(1));
            }
            case BETWEEN: {
                return column.between(values.get(0), values.get(1));
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return column.notBetweenExclusive(values.get(0), values.get(1));
            }
            case NOT_BETWEEN: {
                return column.notBetween(values.get(0), values.get(1));
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + Operator.valueOf((String)conditionNode.get("operator").asText()));
    }

    private static <T> ColumnCondition<T> equalColumnCondition(List<T> values, Column<T> column, boolean caseSensitive) {
        if (values.isEmpty()) {
            return column.isNull();
        }
        if (caseSensitive) {
            return ColumnConditionDeserializer.caseSensitiveEqualColumnCondition(values, column);
        }
        return ColumnConditionDeserializer.caseInsitiveEqualColumnCondition(values, column);
    }

    private static <T> ColumnCondition<T> notEqualColumnCondition(List<T> values, Column<T> column, boolean caseSensitive) {
        if (values.isEmpty()) {
            return column.isNotNull();
        }
        if (caseSensitive) {
            return ColumnConditionDeserializer.caseSensitiveNotEqualColumnCondition(values, column);
        }
        return ColumnConditionDeserializer.caseInsensitiveNotEqualColumnCondition(values, column);
    }

    private static <T> ColumnCondition<T> caseSensitiveEqualColumnCondition(List<T> values, Column<T> column) {
        if (values.size() == 1) {
            return column.equalTo(values.iterator().next());
        }
        return column.in(values);
    }

    private static <T> ColumnCondition<T> caseSensitiveNotEqualColumnCondition(List<T> values, Column<T> column) {
        if (values.size() == 1) {
            return column.notEqualTo(values.iterator().next());
        }
        return column.notIn(values);
    }

    private static <T> ColumnCondition<T> caseInsitiveEqualColumnCondition(List<T> values, Column<T> column) {
        if (values.size() == 1) {
            return column.equalToIgnoreCase((String)values.iterator().next());
        }
        return column.inIgnoreCase(values);
    }

    private static <T> ColumnCondition<T> caseInsensitiveNotEqualColumnCondition(List<T> values, Column<T> column) {
        if (values.size() == 1) {
            return column.notEqualToIgnoreCase((String)values.iterator().next());
        }
        return column.notInIgnoreCase(values);
    }
}

