/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.databind.JsonNode;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.domain.entity.condition.ConditionType;
import is.codion.framework.domain.entity.condition.CustomCondition;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class CustomConditionDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;

    CustomConditionDeserializer(EntityObjectMapper entityObjectMapper) {
        this.entityObjectMapper = Objects.requireNonNull(entityObjectMapper);
    }

    CustomCondition deserialize(EntityDefinition definition, JsonNode conditionNode) throws IOException {
        String conditionTypeName = conditionNode.get("conditionType").asText();
        JsonNode columnsNode = conditionNode.get("columns");
        List columns = Arrays.stream((String[])this.entityObjectMapper.readValue(columnsNode.toString(), String[].class)).map(arg_0 -> ((EntityDefinition.Attributes)definition.attributes()).get(arg_0)).map(attribute -> (Column)attribute).collect(Collectors.toList());
        JsonNode valuesNode = conditionNode.get("values");
        ArrayList<Object> values = new ArrayList<Object>();
        int attributeIndex = 0;
        for (JsonNode valueNode : valuesNode) {
            ColumnDefinition attributeDefinition = definition.columns().definition((Column)columns.get(attributeIndex++));
            values.add(this.entityObjectMapper.readValue(valueNode.toString(), attributeDefinition.attribute().type().valueClass()));
        }
        return Condition.custom((ConditionType)definition.entityType().conditionType(conditionTypeName), columns, values);
    }
}

