/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.core.JsonGenerator;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.condition.CustomCondition;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Collectors;

final class CustomConditionSerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;

    CustomConditionSerializer(EntityObjectMapper entityObjectMapper) {
        this.entityObjectMapper = Objects.requireNonNull(entityObjectMapper);
    }

    void serialize(CustomCondition condition, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", "custom");
        generator.writeStringField("conditionType", condition.conditionType().name());
        generator.writeFieldName("columns");
        this.entityObjectMapper.writeValue(generator, condition.columns().stream().map(Attribute::name).collect(Collectors.toList()));
        generator.writeFieldName("values");
        this.entityObjectMapper.writeValue(generator, condition.values());
        generator.writeEndObject();
    }
}

