/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model.test;

import is.codion.common.user.User;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.db.local.LocalEntityConnectionProvider;
import is.codion.framework.domain.Domain;
import is.codion.framework.model.AbstractEntityEditModel;
import is.codion.framework.model.DefaultEntityApplicationModel;
import is.codion.framework.model.DefaultEntityModel;
import is.codion.framework.model.EntityApplicationModel;
import is.codion.framework.model.EntityModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.framework.model.test.TestDomain;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractEntityApplicationModelTest<Model extends DefaultEntityModel<Model, EditModel, TableModel>, EditModel extends AbstractEntityEditModel, TableModel extends EntityTableModel<EditModel>> {
    private static final User UNIT_TEST_USER = User.parse((String)System.getProperty("codion.test.user", "scott:tiger"));
    private static final EntityConnectionProvider CONNECTION_PROVIDER = ((LocalEntityConnectionProvider.Builder)LocalEntityConnectionProvider.builder().user(UNIT_TEST_USER)).domain((Domain)new TestDomain()).build();
    private final EntityConnectionProvider connectionProvider = CONNECTION_PROVIDER;

    protected AbstractEntityApplicationModelTest() {
    }

    @Test
    public void test() {
        DefaultEntityApplicationModel model = new DefaultEntityApplicationModel(this.connectionProvider);
        Model deptModel = this.createDepartmentModel();
        model.entityModels().add(deptModel);
        Assertions.assertThrows(IllegalArgumentException.class, () -> AbstractEntityApplicationModelTest.lambda$test$0((EntityApplicationModel)model, deptModel));
        Assertions.assertNotNull((Object)model.entityModels().get(TestDomain.Department.TYPE));
        Assertions.assertEquals((int)1, (int)model.entityModels().get().size());
        Assertions.assertEquals((Object)UNIT_TEST_USER, (Object)model.user());
        Assertions.assertThrows(IllegalArgumentException.class, () -> AbstractEntityApplicationModelTest.lambda$test$1((EntityApplicationModel)model));
        if (!deptModel.containsTableModel()) {
            return;
        }
        ((DefaultEntityModel)deptModel.detailModels().get(TestDomain.Employee.TYPE)).tableModel().queryModel().conditionRequired().set((Object)false);
        model.refresh();
        Assertions.assertTrue((deptModel.tableModel().items().visible().count() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void constructorNullConnectionProvider() {
        Assertions.assertThrows(NullPointerException.class, () -> new DefaultEntityApplicationModel(null));
    }

    @Test
    public void entityModelByEntityTypeNotFound() {
        DefaultEntityApplicationModel model = new DefaultEntityApplicationModel(this.connectionProvider);
        Assertions.assertThrows(IllegalArgumentException.class, () -> AbstractEntityApplicationModelTest.lambda$entityModelByEntityTypeNotFound$3((EntityApplicationModel)model));
    }

    @Test
    public void entityModelByEntityType() {
        DefaultEntityApplicationModel model = new DefaultEntityApplicationModel(this.connectionProvider);
        Model departmentModel = this.createDepartmentModel();
        model.entityModels().add(departmentModel);
        Assertions.assertEquals(departmentModel, (Object)model.entityModels().get(TestDomain.Department.TYPE));
    }

    @Test
    public void entityModelByClass() {
        DefaultEntityApplicationModel model = new DefaultEntityApplicationModel(this.connectionProvider);
        Model departmentModel = this.createDepartmentModel();
        Assertions.assertThrows(IllegalArgumentException.class, () -> AbstractEntityApplicationModelTest.lambda$entityModelByClass$4((EntityApplicationModel)model, departmentModel));
        model.entityModels().add(departmentModel);
        Assertions.assertEquals(departmentModel, (Object)model.entityModels().get(departmentModel.getClass()));
    }

    @Test
    public void containsEntityModel() {
        DefaultEntityApplicationModel model = new DefaultEntityApplicationModel(this.connectionProvider);
        Model departmentModel = this.createDepartmentModel();
        model.entityModels().add(departmentModel);
        Assertions.assertTrue((boolean)model.entityModels().contains(TestDomain.Department.TYPE));
        Assertions.assertTrue((boolean)model.entityModels().contains(departmentModel.getClass()));
        Assertions.assertTrue((boolean)model.entityModels().contains(departmentModel));
        Assertions.assertFalse((boolean)model.entityModels().contains(TestDomain.Employee.TYPE));
        DefaultEntityModel detailModel = (DefaultEntityModel)departmentModel.detailModels().get(TestDomain.Employee.TYPE);
        Assertions.assertFalse((boolean)model.entityModels().contains((EntityModel)detailModel));
    }

    protected final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    protected abstract Model createDepartmentModel();

    private static /* synthetic */ void lambda$entityModelByClass$4(EntityApplicationModel model, DefaultEntityModel departmentModel) throws Throwable {
        model.entityModels().get(departmentModel.getClass());
    }

    private static /* synthetic */ void lambda$entityModelByEntityTypeNotFound$3(EntityApplicationModel model) throws Throwable {
        model.entityModels().get(TestDomain.Department.TYPE);
    }

    private static /* synthetic */ void lambda$test$1(EntityApplicationModel model) throws Throwable {
        model.entityModels().get(TestDomain.Employee.TYPE);
    }

    private static /* synthetic */ void lambda$test$0(EntityApplicationModel model, DefaultEntityModel deptModel) throws Throwable {
        model.entityModels().add((EntityModel)deptModel);
    }
}

