/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model.test;

import is.codion.common.model.condition.ConditionModel;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.db.local.LocalEntityConnectionProvider;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.AbstractEntityEditModel;
import is.codion.framework.model.DefaultEntityModel;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.framework.model.ForeignKeyDetailModelLink;
import is.codion.framework.model.test.TestDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractEntityModelTest<Model extends DefaultEntityModel<Model, EditModel, TableModel>, EditModel extends AbstractEntityEditModel, TableModel extends EntityTableModel<EditModel>> {
    private static final User UNIT_TEST_USER = User.parse((String)System.getProperty("codion.test.user", "scott:tiger"));
    protected static final EntityConnectionProvider CONNECTION_PROVIDER = ((LocalEntityConnectionProvider.Builder)LocalEntityConnectionProvider.builder().user(UNIT_TEST_USER)).domain((Domain)new TestDomain()).build();
    private final EntityConnectionProvider connectionProvider = CONNECTION_PROVIDER;
    protected final Model departmentModel = this.createDepartmentModel();

    protected AbstractEntityModelTest() {
    }

    @Test
    public void testUpdatePrimaryKey() {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        this.departmentModel.tableModel().items().refresh();
        AbstractEntityEditModel deptEditModel = this.departmentModel.editModel();
        EntityTableModel deptTableModel = this.departmentModel.tableModel();
        Entity.Key operationsKey = deptEditModel.entities().primaryKey(TestDomain.Department.TYPE, (Object)40);
        deptTableModel.select(Collections.singletonList(operationsKey));
        Assertions.assertTrue((boolean)deptTableModel.selection().empty().not().get());
        deptEditModel.value(TestDomain.Department.ID).set((Object)80);
        Assertions.assertFalse((boolean)deptTableModel.selection().empty().get());
        deptEditModel.update();
        Assertions.assertFalse((boolean)deptTableModel.selection().empty().get());
        Entity operations = (Entity)deptTableModel.selection().item().get();
        Assertions.assertEquals((int)80, (Integer)((Integer)operations.get(TestDomain.Department.ID)));
        deptTableModel.items().visible().predicate().set(item -> !Objects.equals(80, item.get(TestDomain.Department.ID)));
        deptEditModel.editor().set(operations);
        deptEditModel.value(TestDomain.Department.ID).set((Object)40);
        deptEditModel.update();
        deptTableModel.items().filter();
        Assertions.assertTrue((boolean)deptTableModel.items().filtered().get().isEmpty());
    }

    @Test
    public void testDetailModels() {
        Assertions.assertEquals((int)1, (int)this.departmentModel.detailModels().linked().size());
        this.departmentModel.detailModels().link((EntityModel)((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE))).active().set((Object)false);
        Assertions.assertTrue((boolean)this.departmentModel.detailModels().linked().isEmpty());
        this.departmentModel.detailModels().link((EntityModel)((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE))).active().set((Object)true);
    }

    @Test
    public void detailModelNotFound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.departmentModel.detailModels().get(TestDomain.Department.TYPE));
    }

    @Test
    public void clear() {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        this.departmentModel.tableModel().items().refresh();
        Assertions.assertTrue((this.departmentModel.tableModel().items().visible().count() > 0 ? 1 : 0) != 0);
        DefaultEntityModel employeeModel = (DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE);
        employeeModel.tableModel().items().refresh();
        Assertions.assertTrue((employeeModel.tableModel().items().visible().count() > 0 ? 1 : 0) != 0);
        this.departmentModel.detailModels().get().forEach(detailModel -> detailModel.tableModel().items().clear());
        Assertions.assertEquals((int)0, (int)employeeModel.tableModel().items().visible().count());
        this.departmentModel.tableModel().items().clear();
        Assertions.assertEquals((int)0, (int)this.departmentModel.tableModel().items().visible().count());
    }

    @Test
    public void constructorNullTableModel() {
        Assertions.assertThrows(NullPointerException.class, () -> new DefaultEntityModel((EntityTableModel)null));
    }

    @Test
    public void clearEditModelClearTableSelection() {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        this.departmentModel.tableModel().items().refresh();
        this.departmentModel.tableModel().selection().indexes().set(Arrays.asList(1, 2, 3));
        Assertions.assertFalse((boolean)this.departmentModel.tableModel().selection().empty().get());
        Assertions.assertTrue((boolean)this.departmentModel.editModel().editor().exists().get());
        this.departmentModel.editModel().editor().defaults();
        Assertions.assertTrue((boolean)this.departmentModel.tableModel().selection().empty().get());
    }

    @Test
    public void test() {
        Assertions.assertNotNull((Object)this.departmentModel.editModel());
    }

    @Test
    public void detailModel() {
        this.departmentModel.detailModels().get(((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE)).getClass());
        Assertions.assertTrue((boolean)this.departmentModel.detailModels().contains(TestDomain.Employee.TYPE));
        DefaultEntityModel detailModel = (DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE);
        Assertions.assertTrue((boolean)this.departmentModel.detailModels().contains((EntityModel)detailModel));
        Assertions.assertTrue((boolean)this.departmentModel.detailModels().contains(((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE)).getClass()));
        Assertions.assertEquals((int)1, (int)this.departmentModel.detailModels().get().size(), (String)"Only one detail model should be in DepartmentModel");
        Assertions.assertEquals((int)1, (int)this.departmentModel.detailModels().linked().size());
        this.departmentModel.detailModels().get(TestDomain.Employee.TYPE);
        Assertions.assertTrue((boolean)this.departmentModel.detailModels().linked().contains((Object)((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE))));
        Assertions.assertNotNull((Object)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE));
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        this.departmentModel.tableModel().items().refresh();
        ((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE)).tableModel().items().refresh();
        Assertions.assertTrue((((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE)).tableModel().items().visible().count() > 0 ? 1 : 0) != 0);
        EntityConnection connection = this.departmentModel.connection();
        Entity department = connection.selectSingle((Condition)TestDomain.Department.NAME.equalTo((Object)"SALES"));
        this.departmentModel.tableModel().selection().item().set((Object)department);
        List salesEmployees = connection.select(TestDomain.Employee.DEPARTMENT_FK.equalTo(department));
        Assertions.assertFalse((boolean)salesEmployees.isEmpty());
        this.departmentModel.tableModel().selection().item().set((Object)department);
        Collection employeesFromDetailModel = ((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE)).tableModel().items().get();
        Assertions.assertTrue((boolean)salesEmployees.containsAll(employeesFromDetailModel), (String)"Filtered list should contain all employees for department");
    }

    @Test
    public void addSameDetailModelTwice() {
        Object model = this.createDepartmentModelWithoutDetailModel();
        Object employeeModel = this.createEmployeeModel();
        Assertions.assertThrows(IllegalArgumentException.class, () -> model.detailModels().add((EntityModel[])new DefaultEntityModel[]{employeeModel, employeeModel}));
    }

    @Test
    public void addModelAsItsOwnDetailModel() {
        Object model = this.createDepartmentModelWithoutDetailModel();
        Assertions.assertThrows(IllegalArgumentException.class, () -> model.detailModels().add((EntityModel)model));
    }

    @Test
    public void activateDeactivateDetailModel() {
        this.departmentModel.detailModels().link((EntityModel)((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE))).active().set((Object)false);
        Assertions.assertTrue((boolean)((Set)this.departmentModel.detailModels().linked().get()).isEmpty());
        this.departmentModel.detailModels().link((EntityModel)((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE))).active().set((Object)true);
        Assertions.assertFalse((boolean)this.departmentModel.detailModels().linked().isEmpty());
        Assertions.assertTrue((boolean)this.departmentModel.detailModels().linked().contains((Object)((DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void foreignKeyDetailModelLink() {
        Entity inserted;
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        EntityConnection connection = this.connectionProvider.connection();
        DefaultEntityModel employeeModel = (DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE);
        ForeignKeyDetailModelLink detailModelLink = (ForeignKeyDetailModelLink)this.departmentModel.detailModels().link((EntityModel)employeeModel);
        EntityTableModel deptTableModel = this.departmentModel.tableModel();
        AbstractEntityEditModel deptEditModel = this.departmentModel.editModel();
        EntityTableModel empTableModel = employeeModel.tableModel();
        AbstractEntityEditModel empEditModel = employeeModel.editModel();
        EntityEditModel.ValueEditor departmentEditModelValue = empEditModel.value((Attribute)TestDomain.Employee.DEPARTMENT_FK);
        ConditionModel deptCondition = empTableModel.queryModel().conditions().get((Object)TestDomain.Employee.DEPARTMENT_FK);
        connection.startTransaction();
        try {
            detailModelLink.setForeignKeyConditionOnInsert().set((Object)true);
            deptEditModel.value(TestDomain.Department.ID).set((Object)-10);
            deptEditModel.value(TestDomain.Department.NAME).set((Object)"New dept");
            inserted = deptEditModel.insert();
            Assertions.assertEquals((Object)deptCondition.operands().in().get(), Collections.singleton(inserted));
            detailModelLink.setForeignKeyConditionOnInsert().set((Object)false);
            deptCondition.clear();
            deptEditModel.value(TestDomain.Department.ID).set((Object)-11);
            deptEditModel.value(TestDomain.Department.NAME).set((Object)"New dept2");
            deptEditModel.insert();
            Assertions.assertTrue((boolean)((Set)deptCondition.operands().in().get()).isEmpty());
        }
        finally {
            connection.rollbackTransaction();
        }
        connection.startTransaction();
        try {
            detailModelLink.setForeignKeyValueOnInsert().set((Object)true);
            deptEditModel.value(TestDomain.Department.ID).set((Object)-10);
            deptEditModel.value(TestDomain.Department.NAME).set((Object)"New dept");
            inserted = deptEditModel.insert();
            Assertions.assertEquals((Object)departmentEditModelValue.get(), (Object)inserted);
            empTableModel.queryModel().conditionRequired().set((Object)false);
            empTableModel.items().refresh();
            empTableModel.selection().index().set(0);
            Entity currentDept = (Entity)departmentEditModelValue.get();
            deptEditModel.value(TestDomain.Department.ID).set((Object)-12);
            deptEditModel.value(TestDomain.Department.NAME).set((Object)"New dept3");
            deptEditModel.insert();
            Assertions.assertSame((Object)currentDept, (Object)departmentEditModelValue.get());
            detailModelLink.setForeignKeyValueOnInsert().set((Object)false);
            empTableModel.selection().clear();
            departmentEditModelValue.clear();
            deptEditModel.value(TestDomain.Department.ID).set((Object)-11);
            deptEditModel.value(TestDomain.Department.NAME).set((Object)"New dept2");
            deptEditModel.insert();
            Assertions.assertTrue((boolean)departmentEditModelValue.isNull());
            detailModelLink.setForeignKeyValueOnInsert().set((Object)true);
        }
        finally {
            connection.rollbackTransaction();
        }
        detailModelLink.clearForeignKeyValueOnEmptySelection().set((Object)false);
        deptTableModel.items().refresh();
        deptTableModel.selection().index().set(0);
        Entity selected = (Entity)deptTableModel.selection().item().get();
        Assertions.assertSame((Object)selected, (Object)departmentEditModelValue.get());
        deptTableModel.selection().clear();
        Assertions.assertSame((Object)selected, (Object)departmentEditModelValue.get());
        detailModelLink.clearForeignKeyValueOnEmptySelection().set((Object)true);
        deptTableModel.selection().index().set(0);
        deptTableModel.selection().clear();
        Assertions.assertTrue((boolean)departmentEditModelValue.isNull());
        deptTableModel.selection().index().set(0);
        empTableModel.items().refresh();
        empTableModel.selection().index().set(0);
        deptTableModel.selection().clear();
        Assertions.assertFalse((boolean)departmentEditModelValue.isNull());
        detailModelLink.clearForeignKeyConditionOnEmptySelection().set((Object)false);
        deptTableModel.items().refresh();
        deptTableModel.selection().indexes().set(Arrays.asList(0, 1));
        List selectedEntities = deptTableModel.selection().items().get();
        Assertions.assertEquals(new HashSet(selectedEntities), (Object)deptCondition.operands().in().get());
        deptTableModel.selection().clear();
        Assertions.assertEquals(new HashSet(selectedEntities), (Object)deptCondition.operands().in().get());
        detailModelLink.clearForeignKeyConditionOnEmptySelection().set((Object)true);
        deptTableModel.selection().indexes().set(Arrays.asList(2, 3));
        selectedEntities = deptTableModel.selection().items().get();
        Assertions.assertEquals(new HashSet(selectedEntities), (Object)deptCondition.operands().in().get());
        deptTableModel.selection().clear();
        Assertions.assertTrue((boolean)((Set)deptCondition.operands().in().get()).isEmpty());
    }

    @Test
    public void searchByInsertedEntity() {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        DefaultEntityModel employeeModel = (DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE);
        ForeignKeyDetailModelLink link = (ForeignKeyDetailModelLink)this.departmentModel.detailModels().link((EntityModel)employeeModel);
        link.setForeignKeyConditionOnInsert().set((Object)true);
        Assertions.assertTrue((boolean)link.setForeignKeyConditionOnInsert().get());
        AbstractEntityEditModel editModel = this.departmentModel.editModel();
        editModel.value(TestDomain.Department.ID).set((Object)100);
        editModel.value(TestDomain.Department.NAME).set((Object)"Name");
        editModel.value(TestDomain.Department.LOCATION).set((Object)"Loc");
        Entity inserted = editModel.insert();
        Entity inValue = (Entity)employeeModel.tableModel().queryModel().conditions().attribute((Attribute)TestDomain.Employee.DEPARTMENT_FK).operands().in().iterator().next();
        Assertions.assertEquals((Object)inserted, (Object)inValue);
        editModel.delete();
    }

    @Test
    public void clearForeignKeyOnEmptySelection() {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        DefaultEntityModel employeeModel = (DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE);
        AbstractEntityEditModel employeeEditModel = employeeModel.editModel();
        ForeignKeyDetailModelLink link = (ForeignKeyDetailModelLink)this.departmentModel.detailModels().link((EntityModel)employeeModel);
        link.clearForeignKeyValueOnEmptySelection().set((Object)false);
        Entity dept = employeeModel.connection().selectSingle((Condition)TestDomain.Department.ID.equalTo((Object)10));
        this.departmentModel.tableModel().items().refresh();
        this.departmentModel.tableModel().selection().item().set((Object)dept);
        Assertions.assertEquals((Object)dept, (Object)employeeEditModel.value((Attribute)TestDomain.Employee.DEPARTMENT_FK).get());
        this.departmentModel.tableModel().selection().clear();
        Assertions.assertEquals((Object)dept, (Object)employeeEditModel.value((Attribute)TestDomain.Employee.DEPARTMENT_FK).get());
        link.clearForeignKeyValueOnEmptySelection().set((Object)true);
        this.departmentModel.tableModel().selection().item().set((Object)dept);
        Assertions.assertEquals((Object)dept, (Object)employeeEditModel.value((Attribute)TestDomain.Employee.DEPARTMENT_FK).get());
        this.departmentModel.tableModel().selection().clear();
        Assertions.assertTrue((boolean)employeeEditModel.editor().isNull((Attribute)TestDomain.Employee.DEPARTMENT_FK).get());
        link.clearForeignKeyValueOnEmptySelection().set((Object)false);
        this.departmentModel.tableModel().selection().item().set((Object)dept);
        Assertions.assertEquals((Object)dept, (Object)employeeEditModel.value((Attribute)TestDomain.Employee.DEPARTMENT_FK).get());
    }

    @Test
    public void refreshOnSelection() {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        DefaultEntityModel employeeModel = (DefaultEntityModel)this.departmentModel.detailModels().get(TestDomain.Employee.TYPE);
        EntityTableModel employeeTableModel = employeeModel.tableModel();
        ForeignKeyDetailModelLink link = (ForeignKeyDetailModelLink)this.departmentModel.detailModels().link((EntityModel)employeeModel);
        link.refreshOnSelection().set((Object)false);
        Entity dept = employeeModel.connection().selectSingle((Condition)TestDomain.Department.ID.equalTo((Object)10));
        this.departmentModel.tableModel().items().refresh();
        this.departmentModel.tableModel().selection().item().set((Object)dept);
        Assertions.assertEquals((int)0, (int)employeeTableModel.items().visible().count());
        link.refreshOnSelection().set((Object)true);
        this.departmentModel.tableModel().selection().item().set((Object)dept);
        Assertions.assertNotEquals((int)0, (int)employeeTableModel.items().visible().count());
    }

    @Test
    public void insertDifferentTypes() {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        Entity dept = this.departmentModel.entities().builder(TestDomain.Department.TYPE).with(TestDomain.Department.ID, (Object)-42).with(TestDomain.Department.NAME, (Object)"Name").with(TestDomain.Department.LOCATION, (Object)"Loc").build();
        Entity emp = this.connectionProvider.connection().selectSingle((Condition)TestDomain.Employee.ID.equalTo((Object)8)).clearPrimaryKey();
        emp.put(TestDomain.Employee.NAME, (Object)"NewName");
        Model model = this.createDepartmentModelWithoutDetailModel();
        model.editModel().insert(Arrays.asList(dept, emp));
        Assertions.assertTrue((boolean)model.tableModel().items().contains((Object)dept));
        Assertions.assertFalse((boolean)model.tableModel().items().contains((Object)emp));
        model.editModel().delete(Arrays.asList(dept, emp));
        Assertions.assertFalse((boolean)model.tableModel().items().contains((Object)dept));
    }

    protected final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    protected abstract Model createDepartmentModel();

    protected abstract Model createDepartmentModelWithoutDetailModel();

    protected abstract Model createEmployeeModel();
}

