/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model.test;

import is.codion.common.Operator;
import is.codion.common.model.condition.ConditionModel;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.db.local.LocalEntityConnectionProvider;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.framework.model.test.TestDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractEntityTableModelTest<EditModel extends EntityEditModel, TableModel extends EntityTableModel<EditModel>> {
    private static final User UNIT_TEST_USER = User.parse((String)System.getProperty("codion.test.user", "scott:tiger"));
    private static final EntityConnectionProvider CONNECTION_PROVIDER = ((LocalEntityConnectionProvider.Builder)LocalEntityConnectionProvider.builder().user(UNIT_TEST_USER)).domain((Domain)new TestDomain()).build();
    private final EntityConnectionProvider connectionProvider;
    protected final List<Entity> testEntities = AbstractEntityTableModelTest.initTestEntities(CONNECTION_PROVIDER.entities());
    protected final TableModel testModel;

    protected AbstractEntityTableModelTest() {
        this.connectionProvider = CONNECTION_PROVIDER;
        this.testModel = this.createTestTableModel();
    }

    @Test
    public void select() {
        TableModel tableModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        tableModel.items().refresh();
        List keys = tableModel.entities().primaryKeys(TestDomain.Employee.TYPE, (Object[])new Integer[]{1, 2});
        Entity.Key pk1 = (Entity.Key)keys.get(0);
        Entity.Key pk2 = (Entity.Key)keys.get(1);
        tableModel.select(Collections.singletonList(pk1));
        Entity selectedPK1 = (Entity)tableModel.selection().item().get();
        Assertions.assertEquals((Object)pk1, (Object)selectedPK1.primaryKey());
        Assertions.assertEquals((int)1, (int)tableModel.selection().count());
        tableModel.select(Collections.singletonList(pk2));
        Entity selectedPK2 = (Entity)tableModel.selection().item().get();
        Assertions.assertEquals((Object)pk2, (Object)selectedPK2.primaryKey());
        Assertions.assertEquals((int)1, (int)tableModel.selection().count());
        tableModel.select((Collection)keys);
        List selectedItems = tableModel.selection().items().get();
        for (Entity selected : selectedItems) {
            Assertions.assertTrue((boolean)keys.contains(selected.primaryKey()));
        }
        Assertions.assertEquals((int)2, (int)tableModel.selection().count());
    }

    @Test
    public void selectedEntitiesIterator() {
        TableModel tableModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        tableModel.items().refresh();
        tableModel.selection().indexes().set(Arrays.asList(0, 3, 5));
        Iterator iterator = tableModel.selection().items().get().iterator();
        Assertions.assertEquals(tableModel.items().visible().get().get(0), iterator.next());
        Assertions.assertEquals(tableModel.items().visible().get().get(3), iterator.next());
        Assertions.assertEquals(tableModel.items().visible().get().get(5), iterator.next());
    }

    @Test
    public void onInsert() {
        TableModel deptModel = this.createDepartmentTableModel();
        deptModel.items().refresh();
        Entities entities = deptModel.entities();
        deptModel.onInsert().set((Object)EntityTableModel.OnInsert.ADD_BOTTOM);
        Entity dept = entities.builder(TestDomain.Department.TYPE).with(TestDomain.Department.ID, (Object)-10).with(TestDomain.Department.LOCATION, (Object)"Nowhere1").with(TestDomain.Department.NAME, (Object)"HELLO").build();
        int count = deptModel.items().visible().count();
        deptModel.editModel().insert(Collections.singletonList(dept));
        Assertions.assertEquals((int)(count + 1), (int)deptModel.items().visible().count());
        Assertions.assertEquals((Object)dept, deptModel.items().visible().get().get(deptModel.items().visible().count() - 1));
        deptModel.onInsert().set((Object)EntityTableModel.OnInsert.ADD_TOP_SORTED);
        Entity dept2 = entities.builder(TestDomain.Department.TYPE).with(TestDomain.Department.ID, (Object)-20).with(TestDomain.Department.LOCATION, (Object)"Nowhere2").with(TestDomain.Department.NAME, (Object)"NONAME").build();
        deptModel.editModel().insert(Collections.singletonList(dept2));
        Assertions.assertEquals((int)(count + 2), (int)deptModel.items().visible().count());
        Assertions.assertEquals((Object)dept2, deptModel.items().visible().get().get(2));
        deptModel.onInsert().set((Object)EntityTableModel.OnInsert.DO_NOTHING);
        Entity dept3 = entities.builder(TestDomain.Department.TYPE).with(TestDomain.Department.ID, (Object)-30).with(TestDomain.Department.LOCATION, (Object)"Nowhere3").with(TestDomain.Department.NAME, (Object)"NONAME2").build();
        deptModel.editModel().insert(Collections.singletonList(dept3));
        Assertions.assertEquals((int)(count + 2), (int)deptModel.items().visible().count());
        deptModel.items().refresh();
        Assertions.assertEquals((int)(count + 3), (int)deptModel.items().visible().count());
        deptModel.editModel().delete(Arrays.asList(dept, dept2, dept3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeDeletedEntities() {
        TableModel tableModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        tableModel.items().refresh();
        Entities entities = tableModel.entities();
        Entity.Key pk1 = entities.primaryKey(TestDomain.Employee.TYPE, (Object)1);
        Entity.Key pk2 = entities.primaryKey(TestDomain.Employee.TYPE, (Object)2);
        tableModel.connection().startTransaction();
        try {
            tableModel.select(Collections.singletonList(pk1));
            tableModel.selection().index().set(0);
            Entity selected = (Entity)tableModel.selection().item().get();
            tableModel.removeDeleted().set((Object)true);
            tableModel.deleteSelected();
            Assertions.assertFalse((boolean)tableModel.items().contains((Object)selected));
            tableModel.select(Collections.singletonList(pk2));
            selected = (Entity)tableModel.selection().item().get();
            tableModel.removeDeleted().set((Object)false);
            Assertions.assertEquals((int)1, (int)tableModel.deleteSelected().size());
            Assertions.assertTrue((boolean)tableModel.items().contains((Object)selected));
        }
        finally {
            tableModel.connection().rollbackTransaction();
        }
    }

    @Test
    public void entityType() {
        Assertions.assertEquals((Object)TestDomain.Detail.TYPE, (Object)this.testModel.entityType());
    }

    @Test
    public void deleteNotEnabled() {
        this.testModel.editModel().deleteEnabled().set((Object)false);
        this.testModel.items().refresh();
        this.testModel.selection().indexes().set(Collections.singletonList(0));
        Assertions.assertThrows(IllegalStateException.class, () -> this.testModel.deleteSelected());
    }

    @Test
    public void testTheRest() {
        Assertions.assertNotNull((Object)this.testModel.connectionProvider());
        Assertions.assertNotNull((Object)this.testModel.editModel());
        Assertions.assertFalse((boolean)this.testModel.editModel().readOnly().get());
        this.testModel.items().refresh();
    }

    @Test
    public void attributes() {
        Object tableModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        Assertions.assertTrue((boolean)((Set)tableModel.queryModel().attributes().get()).isEmpty());
        tableModel.queryModel().attributes().addAll((Object[])new Attribute[]{TestDomain.Employee.NAME, TestDomain.Employee.HIREDATE});
        tableModel.items().refresh();
        Assertions.assertTrue((tableModel.items().visible().count() > 0 ? 1 : 0) != 0);
        tableModel.items().get().forEach(employee -> {
            Assertions.assertFalse((boolean)employee.contains(TestDomain.Employee.COMMISSION));
            Assertions.assertFalse((boolean)employee.contains(TestDomain.Employee.DEPARTMENT));
            Assertions.assertTrue((boolean)employee.contains(TestDomain.Employee.NAME));
            Assertions.assertTrue((boolean)employee.contains(TestDomain.Employee.HIREDATE));
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> tableModel.queryModel().attributes().add(TestDomain.Department.NAME));
    }

    @Test
    public void limit() {
        TableModel tableModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        tableModel.queryModel().limit().set((Object)6);
        tableModel.items().refresh();
        Assertions.assertEquals((int)6, (int)tableModel.items().visible().count());
        ConditionModel commissionCondition = tableModel.queryModel().conditions().attribute(TestDomain.Employee.COMMISSION);
        commissionCondition.operator().set((Object)Operator.EQUAL);
        commissionCondition.enabled().set((Object)true);
        tableModel.items().refresh();
        commissionCondition.enabled().set((Object)false);
        tableModel.items().refresh();
        Assertions.assertEquals((int)6, (int)tableModel.items().visible().count());
        tableModel.queryModel().limit().clear();
        tableModel.items().refresh();
        Assertions.assertEquals((int)16, (int)tableModel.items().visible().count());
    }

    @Test
    public void conditionChangedListener() {
        TableModel empModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        AtomicInteger counter = new AtomicInteger();
        Runnable conditionChangedListener = counter::incrementAndGet;
        empModel.queryModel().conditionChanged().addListener(conditionChangedListener);
        ConditionModel commissionModel = empModel.queryModel().conditions().attribute(TestDomain.Employee.COMMISSION);
        commissionModel.enabled().set((Object)true);
        Assertions.assertEquals((int)1, (int)counter.get());
        commissionModel.enabled().set((Object)false);
        Assertions.assertEquals((int)2, (int)counter.get());
        commissionModel.operator().set((Object)Operator.GREATER_THAN_OR_EQUAL);
        commissionModel.operands().lower().set((Object)1200.0);
        Assertions.assertEquals((int)3, (int)counter.get());
        empModel.queryModel().conditionChanged().removeListener(conditionChangedListener);
    }

    @Test
    public void testSearchState() {
        TableModel empModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        Assertions.assertFalse((boolean)empModel.queryModel().conditionChanged().get());
        ConditionModel jobModel = empModel.queryModel().conditions().attribute(TestDomain.Employee.JOB);
        jobModel.operands().equal().set((Object)"job");
        Assertions.assertTrue((boolean)empModel.queryModel().conditionChanged().get());
        jobModel.enabled().set((Object)false);
        Assertions.assertFalse((boolean)empModel.queryModel().conditionChanged().get());
        jobModel.enabled().set((Object)true);
        Assertions.assertTrue((boolean)empModel.queryModel().conditionChanged().get());
        empModel.items().refresh();
        Assertions.assertFalse((boolean)empModel.queryModel().conditionChanged().get());
    }

    protected final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    protected abstract TableModel createTestTableModel();

    protected abstract TableModel createDepartmentTableModel();

    protected abstract TableModel createTableModel(EntityType var1, EntityConnectionProvider var2);

    protected abstract TableModel createTableModel(EditModel var1);

    protected abstract EditModel createEditModel(EntityType var1, EntityConnectionProvider var2);

    private static List<Entity> initTestEntities(Entities entities) {
        ArrayList<Entity> testEntities = new ArrayList<Entity>(5);
        String[] stringValues = new String[]{"a", "b", "c", "d", "e"};
        for (int i = 0; i < 5; ++i) {
            testEntities.add(entities.builder(TestDomain.Detail.TYPE).with(TestDomain.Detail.ID, (Object)((long)i + 1L)).with(TestDomain.Detail.INT, (Object)(i + 1)).with(TestDomain.Detail.STRING, (Object)stringValues[i]).build());
        }
        return testEntities;
    }
}

