/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model.test;

import is.codion.common.item.Item;
import is.codion.framework.domain.DomainModel;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.KeyGenerator;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.DerivedAttribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.condition.ConditionType;
import is.codion.framework.domain.entity.query.SelectQuery;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

public final class TestDomain
extends DomainModel {
    public static final DomainType DOMAIN = DomainType.domainType(TestDomain.class);
    private static final String DETAIL_SELECT_TABLE_NAME = "test.entity_test_select";
    private static final List<Item<Integer>> ITEMS = Arrays.asList(Item.item((Object)0, (String)"0"), Item.item((Object)1, (String)"1"), Item.item((Object)2, (String)"2"), Item.item((Object)3, (String)"3"));

    public TestDomain() {
        super(DOMAIN);
        this.add(new EntityDefinition[]{this.master(), this.detail(), this.department(), this.employee(), this.enumEntity(), this.derived(), this.job()});
    }

    EntityDefinition master() {
        return Master.TYPE.define(new AttributeDefinition.Builder[]{Master.ID.define().primaryKey(), Master.NAME.define().column(), Master.CODE.define().column()}).comparator((o1, o2) -> {
            Integer code1 = (Integer)o1.get(Master.CODE);
            Integer code2 = (Integer)o2.get(Master.CODE);
            return code1.compareTo(code2);
        }).stringFactory(Master.NAME).build();
    }

    EntityDefinition detail() {
        return Detail.TYPE.define(new AttributeDefinition.Builder[]{Detail.ID.define().primaryKey(), Detail.INT.define().column().caption(Detail.INT.name()), Detail.DOUBLE.define().column().caption(Detail.DOUBLE.name()), Detail.STRING.define().column().caption("Detail string"), Detail.DATE.define().column().caption(Detail.DATE.name()), Detail.TIMESTAMP.define().column().caption(Detail.TIMESTAMP.name()), ((ColumnDefinition.Builder)((ColumnDefinition.Builder)((ColumnDefinition.Builder)Detail.BOOLEAN.define().column().caption(Detail.BOOLEAN.name())).nullable(false)).defaultValue((Object)true)).description("A boolean column"), ((ColumnDefinition.Builder)Detail.BOOLEAN_NULLABLE.define().column().caption(Detail.BOOLEAN_NULLABLE.name())).defaultValue((Object)true), Detail.MASTER_ID.define().column().readOnly(true), Detail.MASTER_FK.define().foreignKey().caption(Detail.MASTER_FK.name()), Detail.MASTER_NAME.define().denormalized((Attribute)Detail.MASTER_FK, Master.NAME).caption(Detail.MASTER_NAME.name()), Detail.MASTER_CODE.define().denormalized((Attribute)Detail.MASTER_FK, Master.CODE).caption(Detail.MASTER_CODE.name()), ((ColumnDefinition.Builder)Detail.INT_VALUE_LIST.define().column().items(ITEMS)).caption(Detail.INT_VALUE_LIST.name()), Detail.INT_DERIVED.define().derived((DerivedAttribute.Provider & Serializable)sourceValues -> {
            Integer intValue = (Integer)sourceValues.get(Detail.INT);
            if (intValue == null) {
                return null;
            }
            return intValue * 10;
        }, new Attribute[]{Detail.INT}).caption(Detail.INT_DERIVED.name())}).selectTableName(DETAIL_SELECT_TABLE_NAME).orderBy(OrderBy.ascending((Column[])new Column[]{Detail.STRING})).smallDataset(true).stringFactory(Detail.STRING).build();
    }

    EntityDefinition department() {
        return Department.TYPE.define(new AttributeDefinition.Builder[]{((ColumnDefinition.Builder)Department.ID.define().primaryKey().caption(Department.ID.name())).updatable(true).nullable(false), ((ColumnDefinition.Builder)((ColumnDefinition.Builder)Department.NAME.define().column().caption(Department.NAME.name())).searchable(true).maximumLength(14)).nullable(false), ((ColumnDefinition.Builder)Department.LOCATION.define().column().caption(Department.LOCATION.name())).maximumLength(13)}).smallDataset(true).orderBy(OrderBy.ascending((Column[])new Column[]{Department.NAME})).stringFactory(Department.NAME).caption("Department").build();
    }

    EntityDefinition employee() {
        return Employee.TYPE.define(new AttributeDefinition.Builder[]{Employee.ID.define().primaryKey().caption(Employee.ID.name()), ((ColumnDefinition.Builder)((ColumnDefinition.Builder)Employee.NAME.define().column().caption(Employee.NAME.name())).searchable(true).maximumLength(10)).nullable(false), Employee.DEPARTMENT.define().column().nullable(false), ((ForeignKeyDefinition.Builder)Employee.DEPARTMENT_FK.define().foreignKey().caption(Employee.DEPARTMENT_FK.name())).attributes(new Attribute[]{Department.NAME}), ((ColumnDefinition.Builder)((ColumnDefinition.Builder)Employee.JOB.define().column().items(Arrays.asList(Item.item((Object)"ANALYST"), Item.item((Object)"CLERK"), Item.item((Object)"MANAGER"), Item.item((Object)"PRESIDENT"), Item.item((Object)"SALESMAN")))).caption(Employee.JOB.name())).searchable(true), ((ColumnDefinition.Builder)((ColumnDefinition.Builder)((ColumnDefinition.Builder)Employee.SALARY.define().column().caption(Employee.SALARY.name())).nullable(false)).valueRange((Number)1000, (Number)10000)).maximumFractionDigits(2), ((ColumnDefinition.Builder)((ColumnDefinition.Builder)Employee.COMMISSION.define().column().caption(Employee.COMMISSION.name())).valueRange((Number)100, (Number)2000)).maximumFractionDigits(2), Employee.MGR.define().column(), Employee.MGR_FK.define().foreignKey().caption(Employee.MGR_FK.name()), ((ColumnDefinition.Builder)Employee.HIREDATE.define().column().caption(Employee.HIREDATE.name())).nullable(false), Employee.DEPARTMENT_LOCATION.define().denormalized((Attribute)Employee.DEPARTMENT_FK, Department.LOCATION).caption(Department.LOCATION.name())}).stringFactory(Employee.NAME).keyGenerator(KeyGenerator.sequence((String)"employees.employee_seq")).orderBy(OrderBy.ascending((Column[])new Column[]{Employee.DEPARTMENT, Employee.NAME})).condition(Employee.CONDITION_1_TYPE, (attributes, values) -> "1 = 2").condition(Employee.CONDITION_2_TYPE, (attributes, values) -> "1 = 1").condition(Employee.ENAME_CLARK, (attributes, values) -> " ename = 'CLARK'").caption("Employee").build();
    }

    EntityDefinition enumEntity() {
        return EnumEntity.TYPE.define(new AttributeDefinition.Builder[]{EnumEntity.ID.define().primaryKey(), EnumEntity.ENUM_TYPE.define().column()}).build();
    }

    EntityDefinition derived() {
        return Derived.TYPE.define(new AttributeDefinition.Builder[]{Derived.INT1.define().column(), Derived.INT2.define().derived((DerivedAttribute.Provider & Serializable)sourceValues -> sourceValues.optional(Derived.INT1).map(value -> value + 1).orElse(null), new Attribute[]{Derived.INT1}), Derived.INT3.define().derived((DerivedAttribute.Provider & Serializable)sourceValues -> sourceValues.optional(Derived.INT2).map(value -> value + 1).orElse(null), new Attribute[]{Derived.INT2}), Derived.INT4.define().derived((DerivedAttribute.Provider & Serializable)sourceValues -> sourceValues.optional(Derived.INT3).map(value -> value + 1).orElse(null), new Attribute[]{Derived.INT3})}).build();
    }

    EntityDefinition job() {
        return Job.TYPE.define(new AttributeDefinition.Builder[]{Job.JOB.define().primaryKey().groupBy(true), Job.MAX_SALARY.define().column().expression("max(sal)").aggregate(true), Job.MIN_SALARY.define().column().expression("min(sal)").aggregate(true), Job.MAX_COMMISSION.define().column().expression("max(comm)").aggregate(true), Job.MIN_COMMISSION.define().column().expression("min(comm)").aggregate(true)}).tableName("employees.employee").selectQuery(SelectQuery.builder().having("job <> 'PRESIDENT'").build()).condition(Job.ADDITIONAL_HAVING, (attributes, values) -> "count(*) > 1").build();
    }

    public static interface Master {
        public static final EntityType TYPE = DOMAIN.entityType("domain.master_entity");
        public static final Column<Long> ID = TYPE.longColumn("id");
        public static final Column<String> NAME = TYPE.stringColumn("name");
        public static final Column<Integer> CODE = TYPE.integerColumn("code");
    }

    public static interface Detail {
        public static final EntityType TYPE = DOMAIN.entityType("domain.detail_entity");
        public static final Column<Long> ID = TYPE.longColumn("id");
        public static final Column<Integer> INT = TYPE.integerColumn("int");
        public static final Column<Double> DOUBLE = TYPE.doubleColumn("double");
        public static final Column<String> STRING = TYPE.stringColumn("string");
        public static final Column<LocalDate> DATE = TYPE.localDateColumn("date");
        public static final Column<LocalDateTime> TIMESTAMP = TYPE.localDateTimeColumn("timestamp");
        public static final Column<Boolean> BOOLEAN = TYPE.booleanColumn("boolean");
        public static final Column<Boolean> BOOLEAN_NULLABLE = TYPE.booleanColumn("boolean_nullable");
        public static final Column<Long> MASTER_ID = TYPE.longColumn("master_id");
        public static final Column<String> MASTER_NAME = TYPE.stringColumn("master_name");
        public static final Column<Integer> MASTER_CODE = TYPE.integerColumn("master_code");
        public static final Column<Integer> INT_VALUE_LIST = TYPE.integerColumn("int_value_list");
        public static final Attribute<Integer> INT_DERIVED = TYPE.integerAttribute("int_derived");
        public static final ForeignKey MASTER_FK = TYPE.foreignKey("master_fk", MASTER_ID, Master.ID);
    }

    public static interface Department {
        public static final EntityType TYPE = DOMAIN.entityType("employees.department");
        public static final Column<Integer> ID = TYPE.integerColumn("deptno");
        public static final Column<String> LOCATION = TYPE.stringColumn("loc");
        public static final Column<String> NAME = TYPE.stringColumn("dname");
    }

    public static interface Employee {
        public static final EntityType TYPE = DOMAIN.entityType("employees.employee");
        public static final Column<Integer> ID = TYPE.integerColumn("empno");
        public static final Column<String> NAME = TYPE.stringColumn("ename");
        public static final Column<String> JOB = TYPE.stringColumn("job");
        public static final Column<Integer> MGR = TYPE.integerColumn("mgr");
        public static final Column<LocalDate> HIREDATE = TYPE.localDateColumn("hiredate");
        public static final Column<Double> SALARY = TYPE.doubleColumn("sal");
        public static final Column<Double> COMMISSION = TYPE.doubleColumn("comm");
        public static final Column<Integer> DEPARTMENT = TYPE.integerColumn("deptno");
        public static final Column<String> DEPARTMENT_LOCATION = TYPE.stringColumn("location");
        public static final ForeignKey DEPARTMENT_FK = TYPE.foreignKey("dept_fk", DEPARTMENT, Department.ID);
        public static final ForeignKey MGR_FK = TYPE.foreignKey("mgr_fk", MGR, ID);
        public static final ConditionType CONDITION_1_TYPE = TYPE.conditionType("condition1Id");
        public static final ConditionType CONDITION_2_TYPE = TYPE.conditionType("condition2Id");
        public static final ConditionType ENAME_CLARK = TYPE.conditionType("condition3Id");
    }

    public static interface EnumEntity {
        public static final EntityType TYPE = DOMAIN.entityType("enum_entity");
        public static final Column<Integer> ID = TYPE.integerColumn("id");
        public static final Column<EnumType> ENUM_TYPE = TYPE.column("enum_type", EnumType.class);

        public static enum EnumType {
            ONE,
            TWO,
            THREE;

        }
    }

    public static interface Derived {
        public static final EntityType TYPE = DOMAIN.entityType("derived");
        public static final Column<Integer> INT1 = TYPE.integerColumn("int1");
        public static final Column<Integer> INT2 = TYPE.integerColumn("int2");
        public static final Column<Integer> INT3 = TYPE.integerColumn("int3");
        public static final Column<Integer> INT4 = TYPE.integerColumn("int4");
    }

    public static interface Job {
        public static final EntityType TYPE = DOMAIN.entityType("job");
        public static final Column<String> JOB = TYPE.stringColumn("job");
        public static final Column<Double> MAX_SALARY = TYPE.doubleColumn("max_salary");
        public static final Column<Double> MIN_SALARY = TYPE.doubleColumn("min_salary");
        public static final Column<Double> MAX_COMMISSION = TYPE.doubleColumn("max_commission");
        public static final Column<Double> MIN_COMMISSION = TYPE.doubleColumn("min_commission");
        public static final ConditionType ADDITIONAL_HAVING = TYPE.conditionType("additional_having");
    }
}

