/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.db.exception.DatabaseException;
import is.codion.common.event.Event;
import is.codion.common.observable.Observer;
import is.codion.common.state.ObservableState;
import is.codion.common.state.State;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.DefaultEntityEditor;
import is.codion.framework.model.EntityEditEvents;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntitySearchModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityEditModel
implements EntityEditModel {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEntityEditModel.class);
    private final EntityDefinition entityDefinition;
    private final EntityConnectionProvider connectionProvider;
    private final DefaultEntityEditor editor;
    private final Map<ForeignKey, EntitySearchModel> searchModels = new HashMap<ForeignKey, EntitySearchModel>();
    private final Events events;
    private final States states;

    protected AbstractEntityEditModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        this.entityDefinition = Objects.requireNonNull(connectionProvider).entities().definition(Objects.requireNonNull(entityType));
        this.connectionProvider = connectionProvider;
        this.editor = new DefaultEntityEditor(this.entityDefinition);
        this.states = new States(this.entityDefinition.readOnly());
        this.events = new Events((ObservableState)this.states.postEditEvents);
    }

    @Override
    public final Entities entities() {
        return this.connectionProvider.entities();
    }

    @Override
    public final EntityDefinition entityDefinition() {
        return this.entityDefinition;
    }

    public final String toString() {
        return this.getClass() + ", " + this.entityType();
    }

    @Override
    public final State postEditEvents() {
        return this.states.postEditEvents;
    }

    @Override
    public final State readOnly() {
        return this.states.readOnly;
    }

    @Override
    public final State insertEnabled() {
        return this.states.insertEnabled;
    }

    @Override
    public final State updateEnabled() {
        return this.states.updateEnabled;
    }

    @Override
    public final State updateMultipleEnabled() {
        return this.states.updateMultipleEnabled;
    }

    @Override
    public final State deleteEnabled() {
        return this.states.deleteEnabled;
    }

    @Override
    public final EntityType entityType() {
        return this.entityDefinition.type();
    }

    @Override
    public final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public final EntityConnection connection() {
        return this.connectionProvider().connection();
    }

    @Override
    public final void replace(ForeignKey foreignKey, Collection<Entity> entities) {
        this.replaceForeignKey(Objects.requireNonNull(foreignKey), Objects.requireNonNull(entities));
    }

    @Override
    public final EntityEditModel.EntityEditor editor() {
        return this.editor;
    }

    @Override
    public final void refresh() {
        if (this.editor.exists().get().booleanValue()) {
            this.editor.set(this.connectionProvider.connection().select(((Entity)this.editor.getOrThrow()).copy().mutable().primaryKey()));
        }
    }

    @Override
    public final Entity insert() {
        return this.createInsert().prepare().perform().handle().iterator().next();
    }

    @Override
    public final Collection<Entity> insert(Collection<Entity> entities) {
        return this.createInsert(entities).prepare().perform().handle();
    }

    @Override
    public final Entity update() {
        return this.createUpdate().prepare().perform().handle().iterator().next();
    }

    @Override
    public final Collection<Entity> update(Collection<Entity> entities) {
        return this.createUpdate(entities).prepare().perform().handle();
    }

    @Override
    public final Entity delete() {
        return this.createDelete().prepare().perform().handle().iterator().next();
    }

    @Override
    public final Collection<Entity> delete(Collection<Entity> entities) {
        return this.createDelete(entities).prepare().perform().handle();
    }

    @Override
    public final EntityEditModel.InsertEntities createInsert() {
        return new DefaultInsertEntities();
    }

    @Override
    public final EntityEditModel.InsertEntities createInsert(Collection<Entity> entities) {
        return new DefaultInsertEntities(entities);
    }

    @Override
    public final EntityEditModel.UpdateEntities createUpdate() {
        return new DefaultUpdateEntities();
    }

    @Override
    public final EntityEditModel.UpdateEntities createUpdate(Collection<Entity> entities) {
        return new DefaultUpdateEntities(entities);
    }

    @Override
    public final EntityEditModel.DeleteEntities createDelete() {
        return new DefaultDeleteEntities();
    }

    @Override
    public final EntityEditModel.DeleteEntities createDelete(Collection<Entity> entities) {
        return new DefaultDeleteEntities(entities);
    }

    @Override
    public EntitySearchModel createSearchModel(ForeignKey foreignKey) {
        this.entityDefinition().foreignKeys().definition(foreignKey);
        Collection searchable = this.entities().definition(foreignKey.referencedType()).columns().searchable();
        if (searchable.isEmpty()) {
            throw new IllegalStateException("No searchable columns defined for entity: " + foreignKey.referencedType());
        }
        return EntitySearchModel.builder(foreignKey.referencedType(), this.connectionProvider()).singleSelection(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EntitySearchModel searchModel(ForeignKey foreignKey) {
        this.entityDefinition().foreignKeys().definition(foreignKey);
        Map<ForeignKey, EntitySearchModel> map = this.searchModels;
        synchronized (map) {
            EntitySearchModel entitySearchModel = this.searchModels.get(foreignKey);
            if (entitySearchModel == null) {
                entitySearchModel = this.createSearchModel(foreignKey);
                this.searchModels.put(foreignKey, entitySearchModel);
            }
            return entitySearchModel;
        }
    }

    @Override
    public final Observer<Collection<Entity>> beforeInsert() {
        return this.events.beforeInsert.observer();
    }

    @Override
    public final Observer<Collection<Entity>> afterInsert() {
        return this.events.afterInsert.observer();
    }

    @Override
    public final Observer<Collection<Entity>> beforeUpdate() {
        return this.events.beforeUpdate.observer();
    }

    @Override
    public final Observer<Map<Entity, Entity>> afterUpdate() {
        return this.events.afterUpdate.observer();
    }

    @Override
    public final Observer<Collection<Entity>> beforeDelete() {
        return this.events.beforeDelete.observer();
    }

    @Override
    public final Observer<Collection<Entity>> afterDelete() {
        return this.events.afterDelete.observer();
    }

    @Override
    public final Observer<?> afterInsertUpdateOrDelete() {
        return this.events.afterInsertUpdateOrDelete.observer();
    }

    protected Collection<Entity> insert(Collection<Entity> entities, EntityConnection connection) {
        return Objects.requireNonNull(connection).insertSelect(entities);
    }

    protected Collection<Entity> update(Collection<Entity> entities, EntityConnection connection) {
        return Objects.requireNonNull(connection).updateSelect(entities);
    }

    protected void delete(Collection<Entity> entities, EntityConnection connection) {
        Objects.requireNonNull(connection).delete(Entity.primaryKeys(entities));
    }

    protected void replaceForeignKey(ForeignKey foreignKey, Collection<Entity> values) {
        Entity currentForeignKeyValue = (Entity)this.editor.value(foreignKey).get();
        if (currentForeignKeyValue != null) {
            for (Entity replacementValue : values) {
                if (!currentForeignKeyValue.equals(replacementValue)) continue;
                this.editor.value(foreignKey).clear();
                this.editor.value(foreignKey).set(replacementValue);
            }
        }
    }

    protected final void notifyBeforeInsert(Collection<Entity> entitiesToInsert) {
        this.events.beforeInsert.accept(Objects.requireNonNull(entitiesToInsert));
    }

    protected final void notifyAfterInsert(Collection<Entity> insertedEntities) {
        this.events.afterInsert.accept(Objects.requireNonNull(insertedEntities));
    }

    protected final void notifyBeforeUpdate(Collection<Entity> entitiesToUpdate) {
        this.events.beforeUpdate.accept(Objects.requireNonNull(entitiesToUpdate));
    }

    protected final void notifyAfterUpdate(Map<Entity, Entity> updatedEntities) {
        this.events.afterUpdate.accept(Objects.requireNonNull(updatedEntities));
    }

    protected final void notifyBeforeDelete(Collection<Entity> entitiesToDelete) {
        this.events.beforeDelete.accept(Objects.requireNonNull(entitiesToDelete));
    }

    protected final void notifyAfterDelete(Collection<Entity> deletedEntities) {
        this.events.afterDelete.accept(Objects.requireNonNull(deletedEntities));
    }

    private static Map<Entity, Entity> originalEntityMap(Collection<Entity> entitiesBeforeUpdate, Collection<Entity> entitiesAfterUpdate) {
        ArrayList<Entity> entitiesAfterUpdateCopy = new ArrayList<Entity>(entitiesAfterUpdate);
        HashMap<Entity, Entity> keyMap = new HashMap<Entity, Entity>(entitiesBeforeUpdate.size());
        for (Entity entity : entitiesBeforeUpdate) {
            keyMap.put(entity.immutable(), AbstractEntityEditModel.findAndRemove(entity.primaryKey(), entitiesAfterUpdateCopy.listIterator()));
        }
        return Collections.unmodifiableMap(keyMap);
    }

    private static Entity findAndRemove(Entity.Key primaryKey, ListIterator<Entity> iterator) {
        while (iterator.hasNext()) {
            Entity current = iterator.next();
            if (!current.primaryKey().equals(primaryKey)) continue;
            iterator.remove();
            return current;
        }
        return null;
    }

    private static final class States {
        private final State readOnly;
        private final State insertEnabled = State.state((boolean)true);
        private final State updateEnabled = State.state((boolean)true);
        private final State updateMultipleEnabled = State.state((boolean)true);
        private final State deleteEnabled = State.state((boolean)true);
        private final State postEditEvents = State.state((boolean)((Boolean)EntityEditModel.POST_EDIT_EVENTS.getOrThrow()));

        private States(boolean readOnly) {
            this.readOnly = State.state((boolean)readOnly);
        }

        private void verifyInsertEnabled() {
            if (this.readOnly.get().booleanValue() || !this.insertEnabled.get().booleanValue()) {
                throw new IllegalStateException("Edit model is readOnly or inserting is not enabled!");
            }
        }

        private void verifyUpdateEnabled(int entityCount) {
            if (this.readOnly.get().booleanValue() || !this.updateEnabled.get().booleanValue()) {
                throw new IllegalStateException("Edit model is readOnly or updating is not enabled!");
            }
            if (entityCount > 1 && !this.updateMultipleEnabled.get().booleanValue()) {
                throw new IllegalStateException("Updating multiple entities is not enabled");
            }
        }

        private void verifyDeleteEnabled() {
            if (this.readOnly.get().booleanValue() || !this.deleteEnabled.get().booleanValue()) {
                throw new IllegalStateException("Edit model is readOnly or deleting is not enabled!");
            }
        }
    }

    private static final class Events {
        private final Event<Collection<Entity>> beforeInsert = Event.event();
        private final Event<Collection<Entity>> afterInsert = Event.event();
        private final Event<Collection<Entity>> beforeUpdate = Event.event();
        private final Event<Map<Entity, Entity>> afterUpdate = Event.event();
        private final Event<Collection<Entity>> beforeDelete = Event.event();
        private final Event<Collection<Entity>> afterDelete = Event.event();
        private final Event<?> afterInsertUpdateOrDelete = Event.event();

        private Events(ObservableState postEditEvents) {
            this.afterInsert.addListener(this.afterInsertUpdateOrDelete);
            this.afterUpdate.addListener(this.afterInsertUpdateOrDelete);
            this.afterDelete.addListener(this.afterInsertUpdateOrDelete);
            this.afterInsert.addConsumer(insertedEntities -> {
                if (postEditEvents.get().booleanValue()) {
                    EntityEditEvents.inserted(insertedEntities);
                }
            });
            this.afterUpdate.addConsumer(updatedEntities -> {
                if (postEditEvents.get().booleanValue()) {
                    EntityEditEvents.updated(updatedEntities);
                }
            });
            this.afterDelete.addConsumer(deletedEntities -> {
                if (postEditEvents.get().booleanValue()) {
                    EntityEditEvents.deleted(deletedEntities);
                }
            });
        }
    }

    private final class DefaultInsertEntities
    implements EntityEditModel.InsertEntities {
        private final Collection<Entity> entities;
        private final boolean activeEntity;

        private DefaultInsertEntities() {
            this.entities = this.entityForInsert();
            this.activeEntity = true;
            AbstractEntityEditModel.this.states.verifyInsertEnabled();
            AbstractEntityEditModel.this.editor.validate(this.entities);
        }

        private DefaultInsertEntities(Collection<Entity> entities) {
            this.entities = Collections.unmodifiableCollection(new ArrayList<Entity>(entities));
            this.activeEntity = false;
            AbstractEntityEditModel.this.states.verifyInsertEnabled();
            AbstractEntityEditModel.this.editor.validate(entities);
        }

        private Collection<Entity> entityForInsert() {
            Entity.Builder builder = ((Entity)AbstractEntityEditModel.this.editor.getOrThrow()).copy().builder();
            if (AbstractEntityEditModel.this.entityDefinition.primaryKey().generated()) {
                builder.clearPrimaryKey();
            }
            return Collections.singleton(builder.build());
        }

        @Override
        public EntityEditModel.InsertEntities.Task prepare() {
            AbstractEntityEditModel.this.notifyBeforeInsert(this.entities);
            return new InsertTask();
        }

        private final class InsertTask
        implements EntityEditModel.InsertEntities.Task {
            private InsertTask() {
            }

            @Override
            public EntityEditModel.InsertEntities.Result perform() {
                LOG.debug("{} - insert {}", (Object)this, DefaultInsertEntities.this.entities);
                Collection<Entity> inserted = Collections.unmodifiableCollection(AbstractEntityEditModel.this.insert(DefaultInsertEntities.this.entities, AbstractEntityEditModel.this.connection()));
                if (!DefaultInsertEntities.this.entities.isEmpty() && inserted.isEmpty()) {
                    throw new DatabaseException("Insert did not return an entity, usually caused by a misconfigured key generator");
                }
                return new InsertResult(inserted);
            }
        }

        private final class InsertResult
        implements EntityEditModel.InsertEntities.Result {
            private final Collection<Entity> insertedEntities;

            private InsertResult(Collection<Entity> insertedEntities) {
                this.insertedEntities = insertedEntities;
            }

            @Override
            public Collection<Entity> handle() {
                if (DefaultInsertEntities.this.activeEntity) {
                    AbstractEntityEditModel.this.editor.setOrDefaults(this.insertedEntities.iterator().next());
                }
                AbstractEntityEditModel.this.notifyAfterInsert(this.insertedEntities);
                return this.insertedEntities;
            }
        }
    }

    private final class DefaultUpdateEntities
    implements EntityEditModel.UpdateEntities {
        private final Collection<Entity> entities;

        private DefaultUpdateEntities() {
            this.entities = Collections.singleton(((Entity)AbstractEntityEditModel.this.editor.getOrThrow()).copy().mutable());
            AbstractEntityEditModel.this.states.verifyUpdateEnabled(this.entities.size());
            AbstractEntityEditModel.this.editor.validate(this.entities);
            this.verifyModified(this.entities);
        }

        private DefaultUpdateEntities(Collection<Entity> entities) {
            this.entities = Collections.unmodifiableCollection(new ArrayList<Entity>(entities));
            AbstractEntityEditModel.this.states.verifyUpdateEnabled(entities.size());
            AbstractEntityEditModel.this.editor.validate(entities);
            this.verifyModified(entities);
        }

        @Override
        public EntityEditModel.UpdateEntities.Task prepare() {
            AbstractEntityEditModel.this.notifyBeforeUpdate(this.entities);
            return new UpdateTask();
        }

        private void verifyModified(Collection<Entity> entities) {
            for (Entity entity : entities) {
                if (entity.modified()) continue;
                throw new IllegalStateException("Entity is not modified: " + entity);
            }
        }

        private final class UpdateTask
        implements EntityEditModel.UpdateEntities.Task {
            private UpdateTask() {
            }

            @Override
            public EntityEditModel.UpdateEntities.Result perform() {
                LOG.debug("{} - update {}", (Object)this, DefaultUpdateEntities.this.entities);
                return new UpdateResult(AbstractEntityEditModel.this.update(DefaultUpdateEntities.this.entities, AbstractEntityEditModel.this.connection()));
            }
        }

        private final class UpdateResult
        implements EntityEditModel.UpdateEntities.Result {
            private final Collection<Entity> updatedEntities;

            private UpdateResult(Collection<Entity> updatedEntities) {
                this.updatedEntities = updatedEntities;
            }

            @Override
            public Collection<Entity> handle() {
                Entity entity = AbstractEntityEditModel.this.editor.get();
                this.updatedEntities.stream().filter(updatedEntity -> updatedEntity.equals(entity)).findFirst().ifPresent(AbstractEntityEditModel.this.editor::setOrDefaults);
                AbstractEntityEditModel.this.notifyAfterUpdate(AbstractEntityEditModel.originalEntityMap(DefaultUpdateEntities.this.entities, this.updatedEntities));
                return this.updatedEntities;
            }
        }
    }

    private final class DefaultDeleteEntities
    implements EntityEditModel.DeleteEntities {
        private final Collection<Entity> entities;
        private final boolean activeEntity;

        private DefaultDeleteEntities() {
            this.entities = Collections.singleton(this.activeEntity());
            this.activeEntity = true;
            AbstractEntityEditModel.this.states.verifyDeleteEnabled();
        }

        private DefaultDeleteEntities(Collection<Entity> entities) {
            this.entities = Collections.unmodifiableCollection(new ArrayList<Entity>(entities));
            this.activeEntity = false;
            AbstractEntityEditModel.this.states.verifyDeleteEnabled();
        }

        @Override
        public EntityEditModel.DeleteEntities.Task prepare() {
            AbstractEntityEditModel.this.notifyBeforeDelete(this.entities);
            return new DeleteTask();
        }

        private Entity activeEntity() {
            Entity copy = ((Entity)AbstractEntityEditModel.this.editor.getOrThrow()).copy().mutable();
            copy.revert();
            return copy;
        }

        private final class DeleteTask
        implements EntityEditModel.DeleteEntities.Task {
            private DeleteTask() {
            }

            @Override
            public EntityEditModel.DeleteEntities.Result perform() {
                LOG.debug("{} - delete {}", (Object)this, DefaultDeleteEntities.this.entities);
                AbstractEntityEditModel.this.delete(DefaultDeleteEntities.this.entities, AbstractEntityEditModel.this.connection());
                return new DeleteResult(DefaultDeleteEntities.this.entities);
            }
        }

        private final class DeleteResult
        implements EntityEditModel.DeleteEntities.Result {
            private final Collection<Entity> deletedEntities;

            private DeleteResult(Collection<Entity> deletedEntities) {
                this.deletedEntities = deletedEntities;
            }

            @Override
            public Collection<Entity> handle() {
                if (DefaultDeleteEntities.this.activeEntity) {
                    AbstractEntityEditModel.this.editor.setOrDefaults(null);
                }
                AbstractEntityEditModel.this.notifyAfterDelete(this.deletedEntities);
                return this.deletedEntities;
            }
        }
    }
}

