/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.state.State;
import is.codion.common.value.ObservableValueSet;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.framework.model.ForeignKeyModelLink;
import is.codion.framework.model.ModelLink;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractEntityModel<M extends EntityModel<M, E, T>, E extends EntityEditModel, T extends EntityTableModel<E>>
implements EntityModel<M, E, T> {
    private final E editModel;
    private final T tableModel;
    private final EntityModel.DetailModels<M, E, T> detailModels = new DefaultDetailModels();

    protected AbstractEntityModel(E editModel) {
        this.editModel = (EntityEditModel)Objects.requireNonNull(editModel);
        this.tableModel = null;
        this.bindEventsInternal();
    }

    protected AbstractEntityModel(T tableModel) {
        this.editModel = ((EntityTableModel)Objects.requireNonNull(tableModel)).editModel();
        this.tableModel = tableModel;
        this.bindEventsInternal();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.entityType();
    }

    @Override
    public final EntityType entityType() {
        return this.editModel.entityType();
    }

    @Override
    public final EntityConnectionProvider connectionProvider() {
        return this.editModel.connectionProvider();
    }

    @Override
    public final EntityConnection connection() {
        return this.editModel.connection();
    }

    @Override
    public final Entities entities() {
        return this.editModel.connectionProvider().entities();
    }

    @Override
    public final EntityDefinition entityDefinition() {
        return this.editModel.entityDefinition();
    }

    @Override
    public final E editModel() {
        return this.editModel;
    }

    @Override
    public final T tableModel() {
        if (this.tableModel == null) {
            throw new IllegalStateException("Entity model " + this + " does not contain a table model");
        }
        return this.tableModel;
    }

    @Override
    public final boolean containsTableModel() {
        return this.tableModel != null;
    }

    @Override
    public final <B extends ForeignKeyModelLink.Builder<M, E, T, B>> ForeignKeyModelLink.Builder<M, E, T, B> link(M model) {
        Collection foreignKeys = ((EntityModel)Objects.requireNonNull(model)).editModel().entityDefinition().foreignKeys().get(this.editModel.entityType());
        if (foreignKeys.isEmpty()) {
            throw new IllegalArgumentException("Entity " + model.editModel().entityType() + " does not reference " + this.editModel.entityType() + " via a foreign key");
        }
        if (foreignKeys.size() > 1) {
            throw new IllegalArgumentException("Entity " + model.editModel().entityType() + " references " + this.editModel.entityType() + " via multiple foreign keys");
        }
        return ForeignKeyModelLink.builder(model, (ForeignKey)foreignKeys.iterator().next());
    }

    @Override
    public final EntityModel.DetailModels<M, E, T> detailModels() {
        return this.detailModels;
    }

    private void selectionChanged() {
        List<Entity> activeEntities = this.activeEntities();
        this.detailModels.get().values().forEach(link -> link.onSelection(activeEntities));
    }

    private List<Entity> activeEntities() {
        if (this.tableModel != null && this.tableModel.selection().empty().not().get().booleanValue()) {
            return (List)this.tableModel.selection().items().get();
        }
        if (this.editModel.editor().exists().not().get().booleanValue()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.editModel.editor().get());
    }

    private void bindEventsInternal() {
        this.editModel.afterInsert().addConsumer(this::onInsert);
        this.editModel.afterUpdate().addConsumer(this::onUpdate);
        this.editModel.afterDelete().addConsumer(this::onDelete);
        if (this.containsTableModel()) {
            this.tableModel.selection().indexes().addListener(this::selectionChanged);
        } else {
            this.editModel.editor().addListener(this::selectionChanged);
        }
    }

    private void onInsert(Collection<Entity> insertedEntities) {
        this.detailModels.get().values().forEach(link -> link.onInsert(insertedEntities));
    }

    private void onUpdate(Map<Entity, Entity> updatedEntities) {
        this.detailModels.get().values().forEach(link -> link.onUpdate(updatedEntities));
    }

    private void onDelete(Collection<Entity> deletedEntities) {
        this.detailModels.get().values().forEach(link -> link.onDelete(deletedEntities));
    }

    private final class DefaultDetailModels
    implements EntityModel.DetailModels<M, E, T> {
        private final Map<M, ModelLink<M, E, T>> models = new HashMap();
        private final ValueSet<M> active = ValueSet.valueSet();

        private DefaultDetailModels() {
        }

        @Override
        public void add(M ... detailModels) {
            for (EntityModel detailModel : (EntityModel[])Objects.requireNonNull(detailModels)) {
                this.add((M)detailModel);
            }
        }

        @Override
        public void add(M detailModel) {
            this.add(AbstractEntityModel.this.link(detailModel).build());
        }

        @Override
        public void add(M detailModel, ForeignKey foreignKey) {
            this.add(ForeignKeyModelLink.builder((EntityModel)Objects.requireNonNull(detailModel), Objects.requireNonNull(foreignKey)).build());
        }

        @Override
        public void add(ModelLink<M, E, T> modelLink) {
            if (AbstractEntityModel.this == Objects.requireNonNull(modelLink).model()) {
                throw new IllegalArgumentException("A model can not be its own detail model");
            }
            if (this.models.containsKey(modelLink.model())) {
                throw new IllegalArgumentException("Detail model " + modelLink.model() + " has already been added");
            }
            this.models.put(modelLink.model(), modelLink);
            if (modelLink.active().get().booleanValue()) {
                this.active.add(modelLink.model());
                modelLink.onSelection(AbstractEntityModel.this.activeEntities());
            }
            modelLink.active().addConsumer((Consumer)new ActiveChanged(modelLink));
        }

        @Override
        public boolean contains(M detailModel) {
            return this.models.containsKey(Objects.requireNonNull(detailModel));
        }

        @Override
        public Map<M, ModelLink<M, E, T>> get() {
            return Collections.unmodifiableMap(this.models);
        }

        @Override
        public State active(M detailModel) {
            if (!this.models.containsKey(Objects.requireNonNull(detailModel))) {
                throw new IllegalStateException("Detail model not found: " + detailModel);
            }
            return this.models.get(detailModel).active();
        }

        @Override
        public ObservableValueSet<M> active() {
            return this.active.observable();
        }

        @Override
        public <C extends M> C get(Class<C> modelClass) {
            Objects.requireNonNull(modelClass);
            return (C)this.models.keySet().stream().filter(detailModel -> detailModel.getClass().equals(modelClass)).findFirst().orElseThrow(() -> new IllegalArgumentException("Detail model of type " + modelClass.getName() + " not found in model: " + AbstractEntityModel.this));
        }

        @Override
        public M get(EntityType entityType) {
            Objects.requireNonNull(entityType);
            return this.models.keySet().stream().filter(detailModel -> detailModel.entityType().equals(entityType)).findFirst().orElseThrow(() -> new IllegalArgumentException("No detail model for entity " + entityType + " found in model: " + AbstractEntityModel.this));
        }

        private final class ActiveChanged
        implements Consumer<Boolean> {
            private final ModelLink<M, E, T> modelLink;

            private ActiveChanged(ModelLink<M, E, T> modelLink) {
                this.modelLink = modelLink;
            }

            @Override
            public void accept(Boolean isActive) {
                if (isActive.booleanValue()) {
                    DefaultDetailModels.this.active.add(this.modelLink.model());
                    this.modelLink.onSelection(AbstractEntityModel.this.activeEntities());
                } else {
                    DefaultDetailModels.this.active.remove(this.modelLink.model());
                }
            }
        }
    }
}

