/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.model.FilterModel;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.DefaultEntityQueryModel;
import is.codion.framework.model.EntityEditEvents;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityQueryModel;
import is.codion.framework.model.EntityTableConditionModel;
import is.codion.framework.model.EntityTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractEntityTableModel<E extends EntityEditModel>
implements EntityTableModel<E> {
    private final FilterModel<Entity> filterModel;
    private final E editModel;
    private final EntityQueryModel queryModel;
    private final State handleEditEvents = ((State.Builder)State.builder().consumer((Consumer)new HandleEditEventsChanged())).build();
    private final State editable = State.state();
    private final State removeDeleted = State.state((boolean)true);
    private final Value<EntityTableModel.OnInsert> onInsert = Value.nonNull((Object)((Object)((EntityTableModel.OnInsert)((Object)ON_INSERT.getOrThrow()))));
    private final Consumer<Map<Entity, Entity>> updateListener = new UpdateListener();

    protected AbstractEntityTableModel(E editModel, FilterModel<Entity> filterModel) {
        this(editModel, filterModel, new DefaultEntityQueryModel(EntityTableConditionModel.entityTableConditionModel(editModel.entityType(), editModel.connectionProvider())));
    }

    protected AbstractEntityTableModel(E editModel, FilterModel<Entity> filterModel, EntityQueryModel queryModel) {
        this.editModel = (EntityEditModel)Objects.requireNonNull(editModel);
        this.queryModel = Objects.requireNonNull(queryModel);
        this.filterModel = Objects.requireNonNull(filterModel);
        if (queryModel != null && !editModel.entityType().equals(queryModel.entityType())) {
            throw new IllegalArgumentException("Entity type mismatch, edit model: " + editModel.entities() + ", query model: " + queryModel.entityType());
        }
        this.bindEvents();
        this.handleEditEvents.set((Object)((Boolean)HANDLE_EDIT_EVENTS.get()));
    }

    @Override
    public final Entities entities() {
        return this.editModel.connectionProvider().entities();
    }

    @Override
    public final EntityDefinition entityDefinition() {
        return this.editModel.entityDefinition();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.editModel.entityType();
    }

    @Override
    public final Value<EntityTableModel.OnInsert> onInsert() {
        return this.onInsert;
    }

    @Override
    public final State removeDeleted() {
        return this.removeDeleted;
    }

    @Override
    public final State handleEditEvents() {
        return this.handleEditEvents;
    }

    @Override
    public final EntityType entityType() {
        return this.editModel.entityType();
    }

    @Override
    public final E editModel() {
        return this.editModel;
    }

    @Override
    public final EntityConnectionProvider connectionProvider() {
        return this.editModel.connectionProvider();
    }

    @Override
    public final EntityConnection connection() {
        return this.editModel.connection();
    }

    @Override
    public final EntityQueryModel queryModel() {
        return this.queryModel;
    }

    @Override
    public final State editable() {
        return this.editable;
    }

    @Override
    public final void replace(Collection<Entity> entities) {
        this.replaceEntitiesByKey(Entity.primaryKeyMap(entities));
    }

    @Override
    public final void refresh(Collection<Entity.Key> keys) {
        this.replace(this.connection().select(keys));
    }

    @Override
    public final void select(Collection<Entity.Key> keys) {
        this.selection().items().set((Predicate)new SelectByKeyPredicate(Objects.requireNonNull(keys)));
    }

    @Override
    public final Collection<Entity> deleteSelected() {
        return this.editModel.delete((Collection)this.selection().items().get());
    }

    @Override
    public final void replace(ForeignKey foreignKey, Collection<Entity> foreignKeyValues) {
        Objects.requireNonNull(foreignKey);
        Objects.requireNonNull(foreignKeyValues);
        this.entityDefinition().foreignKeys().definition(foreignKey);
        for (Entity entity : this.items().filtered().get()) {
            for (Entity foreignKeyValue : foreignKeyValues) {
                AbstractEntityTableModel.replace(foreignKey, entity, foreignKeyValue);
            }
        }
        List visibleItems = this.items().visible().get();
        for (int i = 0; i < visibleItems.size(); ++i) {
            Entity entity = (Entity)visibleItems.get(i);
            for (Entity foreignKeyValue : foreignKeyValues) {
                if (!AbstractEntityTableModel.replace(foreignKey, entity, foreignKeyValue)) continue;
                this.onRowsUpdated(i, i);
            }
        }
    }

    protected FilterModel<Entity> filterModel() {
        return this.filterModel;
    }

    protected abstract void onRowsUpdated(int var1, int var2);

    private void bindEvents() {
        this.editModel.afterInsert().addConsumer(this::onInsert);
        this.editModel.afterUpdate().addConsumer(this::onUpdate);
        this.editModel.afterDelete().addConsumer(this::onDelete);
        this.editModel.editor().addConsumer(this::onEntityChanged);
        this.selection().item().addConsumer(this.editModel.editor()::set);
    }

    private void onInsert(Collection<Entity> insertedEntities) {
        Collection entitiesToAdd = insertedEntities.stream().filter(entity -> entity.type().equals(this.entityType())).collect(Collectors.toList());
        EntityTableModel.OnInsert onInsertAction = (EntityTableModel.OnInsert)((Object)this.onInsert.getOrThrow());
        if (onInsertAction != EntityTableModel.OnInsert.DO_NOTHING && !entitiesToAdd.isEmpty()) {
            this.selection().clear();
            this.items().visible().add(onInsertAction == EntityTableModel.OnInsert.PREPEND ? 0 : this.items().visible().count(), entitiesToAdd);
        }
    }

    private void onUpdate(Map<Entity, Entity> updatedEntities) {
        this.replaceEntitiesByKey(updatedEntities.entrySet().stream().collect(Collectors.toMap(entry -> ((Entity)entry.getKey()).originalPrimaryKey(), Map.Entry::getValue)));
    }

    private void onDelete(Collection<Entity> deletedEntities) {
        if (this.removeDeleted.get().booleanValue()) {
            this.items().remove(deletedEntities);
        }
    }

    private void onEntityChanged(Entity entity) {
        if (entity == null) {
            this.selection().clear();
        }
    }

    private void replaceEntitiesByKey(Map<Entity.Key, Entity> entitiesByKey) {
        Map<Entity.Key, Integer> keyIndexes = this.keyIndexes(new HashSet<Entity.Key>(entitiesByKey.keySet()));
        keyIndexes.forEach((key, index) -> this.items().visible().set(index.intValue(), (Object)((Entity)entitiesByKey.remove(key))));
        if (!entitiesByKey.isEmpty()) {
            this.items().filtered().get().forEach(item -> {
                Entity replacement = (Entity)entitiesByKey.remove(item.primaryKey());
                if (replacement != null) {
                    item.set(replacement);
                }
            });
        }
    }

    private Map<Entity.Key, Integer> keyIndexes(Set<Entity.Key> keys) {
        List visibleItems = this.items().visible().get();
        HashMap<Entity.Key, Integer> keyIndexes = new HashMap<Entity.Key, Integer>();
        for (int index = 0; index < visibleItems.size(); ++index) {
            Entity.Key primaryKey = ((Entity)visibleItems.get(index)).primaryKey();
            if (!keys.remove(primaryKey)) continue;
            keyIndexes.put(primaryKey, index);
            if (keys.isEmpty()) break;
        }
        return keyIndexes;
    }

    private static boolean replace(ForeignKey foreignKey, Entity entity, Entity foreignKeyValue) {
        Entity currentForeignKeyValue = entity.entity(foreignKey);
        if (currentForeignKeyValue != null && currentForeignKeyValue.equals(foreignKeyValue)) {
            entity.put((Attribute)foreignKey, (Object)foreignKeyValue.immutable());
            return true;
        }
        return false;
    }

    private final class HandleEditEventsChanged
    implements Consumer<Boolean> {
        private HandleEditEventsChanged() {
        }

        @Override
        public void accept(Boolean handleEditEvents) {
            if (handleEditEvents.booleanValue()) {
                this.entityTypes().forEach(entityType -> EntityEditEvents.updateObserver(entityType).addWeakConsumer(AbstractEntityTableModel.this.updateListener));
            } else {
                this.entityTypes().forEach(entityType -> EntityEditEvents.updateObserver(entityType).removeWeakConsumer(AbstractEntityTableModel.this.updateListener));
            }
        }

        private Stream<EntityType> entityTypes() {
            return Stream.concat(AbstractEntityTableModel.this.entityDefinition().foreignKeys().get().stream().map(ForeignKey::referencedType), Stream.of(AbstractEntityTableModel.this.entityType()));
        }
    }

    private final class UpdateListener
    implements Consumer<Map<Entity, Entity>> {
        private UpdateListener() {
        }

        @Override
        public void accept(Map<Entity, Entity> updated) {
            updated.values().stream().collect(Collectors.groupingBy(Entity::type, HashMap::new, Collectors.toList())).forEach(this::handleUpdate);
        }

        private void handleUpdate(EntityType entityType, List<Entity> entities) {
            if (entityType.equals(AbstractEntityTableModel.this.entityType())) {
                AbstractEntityTableModel.this.replace(entities);
            }
            AbstractEntityTableModel.this.entityDefinition().foreignKeys().get(entityType).forEach(foreignKey -> AbstractEntityTableModel.this.replace((ForeignKey)foreignKey, (Collection<Entity>)entities));
        }
    }

    private static final class SelectByKeyPredicate
    implements Predicate<Entity> {
        private final List<Entity.Key> keyList;

        private SelectByKeyPredicate(Collection<Entity.Key> keys) {
            this.keyList = new ArrayList<Entity.Key>(keys);
        }

        @Override
        public boolean test(Entity entity) {
            if (this.keyList.isEmpty()) {
                return false;
            }
            int index = this.keyList.indexOf(entity.primaryKey());
            if (index >= 0) {
                this.keyList.remove(index);
                return true;
            }
            return false;
        }
    }
}

