/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.user.User;
import is.codion.common.version.Version;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.model.EntityApplicationModel;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityModel;
import is.codion.framework.model.EntityTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DefaultEntityApplicationModel<M extends EntityModel<M, E, T>, E extends EntityEditModel, T extends EntityTableModel<E>>
implements EntityApplicationModel<M, E, T> {
    private final EntityConnectionProvider connectionProvider;
    private final Version version;
    private final DefaultEntityModels<M, E, T> models = new DefaultEntityModels();

    public DefaultEntityApplicationModel(EntityConnectionProvider connectionProvider) {
        this(connectionProvider, null);
    }

    public DefaultEntityApplicationModel(EntityConnectionProvider connectionProvider, Version version) {
        this.connectionProvider = Objects.requireNonNull(connectionProvider);
        this.version = version;
    }

    @Override
    public final User user() {
        return this.connectionProvider.connection().user();
    }

    @Override
    public final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public final EntityConnection connection() {
        return this.connectionProvider.connection();
    }

    @Override
    public final Optional<Version> version() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public final Entities entities() {
        return this.connectionProvider.entities();
    }

    @Override
    public final EntityApplicationModel.EntityModels<M, E, T> entityModels() {
        return this.models;
    }

    @Override
    public final void refresh() {
        for (EntityModel entityModel : this.models.entityModels) {
            if (!entityModel.containsTableModel()) continue;
            entityModel.tableModel().items().refresh();
        }
    }

    private final class DefaultEntityModels<M extends EntityModel<M, E, T>, E extends EntityEditModel, T extends EntityTableModel<E>>
    implements EntityApplicationModel.EntityModels<M, E, T> {
        private final List<M> entityModels = new ArrayList<M>();

        private DefaultEntityModels() {
        }

        @Override
        public void add(M ... entityModels) {
            for (EntityModel entityModel : (EntityModel[])Objects.requireNonNull(entityModels)) {
                this.add((M)entityModel);
            }
        }

        @Override
        public void add(M entityModel) {
            if (this.entityModels.contains(Objects.requireNonNull(entityModel))) {
                throw new IllegalArgumentException("Entity model " + entityModel + " has already been added");
            }
            this.entityModels.add(entityModel);
        }

        @Override
        public boolean contains(Class<? extends M> modelClass) {
            return this.entityModels.stream().anyMatch(entityModel -> entityModel.getClass().equals(modelClass));
        }

        @Override
        public boolean contains(EntityType entityType) {
            return this.entityModels.stream().anyMatch(entityModel -> entityModel.entityType().equals(entityType));
        }

        @Override
        public boolean contains(M entityModel) {
            return this.entityModels.contains(entityModel);
        }

        @Override
        public List<M> get() {
            return Collections.unmodifiableList(this.entityModels);
        }

        @Override
        public <C extends M> C get(Class<C> modelClass) {
            for (EntityModel model : this.entityModels) {
                if (!model.getClass().equals(modelClass)) continue;
                return (C)model;
            }
            throw new IllegalArgumentException("EntityModel of type: " + modelClass + " not found");
        }

        @Override
        public M get(EntityType entityType) {
            for (EntityModel entityModel : this.entityModels) {
                if (!entityModel.entityType().equals(entityType)) continue;
                return (M)entityModel;
            }
            throw new IllegalArgumentException("EntityModel for type " + entityType + " not  found in model: " + DefaultEntityApplicationModel.this);
        }
    }
}

