/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.event.Event;
import is.codion.common.observable.Observer;
import is.codion.common.state.ObservableState;
import is.codion.common.state.State;
import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityValidator;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.attribute.TransientAttributeDefinition;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.model.EntityEditModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class DefaultEntityEditor
implements EntityEditModel.EntityEditor {
    private final Map<Attribute<?>, Event<?>> editEvents = new HashMap();
    private final Event<Attribute<?>> valueChanged = Event.event();
    private final Event<Entity> changing = Event.event();
    private final Event<Entity> changed = Event.event();
    private final Map<Attribute<?>, DefaultValueEditor<?>> valueEditors = new HashMap();
    private final Map<Attribute<?>, State> persistValues = new HashMap();
    private final Map<Attribute<?>, State> attributeModified = new HashMap();
    private final Map<Attribute<?>, State> attributeNull = new HashMap();
    private final Map<Attribute<?>, State> attributeValid = new HashMap();
    private final EntityDefinition entityDefinition;
    private final State primaryKeyNull = State.state((boolean)true);
    private final State entityValid = State.state();
    private final DefaultExists exists;
    private final DefaultModified modified;
    private final Value<EntityValidator> validator;
    private final Entity entity;

    DefaultEntityEditor(EntityDefinition entityDefinition) {
        this.entityDefinition = Objects.requireNonNull(entityDefinition);
        this.entity = this.createEntity(AttributeDefinition::defaultValue);
        this.exists = new DefaultExists(entityDefinition);
        this.modified = new DefaultModified();
        this.validator = Value.builder().nonNull((Object)entityDefinition.validator()).listener(this::updateValidState).build();
        this.configurePersistentForeignKeys();
    }

    @Override
    public void set(Entity entity) {
        this.changing.accept((Object)(entity == null ? null : entity.immutable()));
        this.setOrDefaults(entity);
    }

    @Override
    public Entity get() {
        return this.entity.immutable();
    }

    @Override
    public void clear() {
        this.set(this.entityDefinition.entity());
    }

    public Observer<Entity> observer() {
        return this.changed.observer();
    }

    @Override
    public void defaults() {
        this.set(null);
    }

    @Override
    public void revert() {
        this.entityDefinition.attributes().get().forEach(attribute -> this.value((Attribute)attribute).revert());
    }

    @Override
    public EntityEditModel.EntityEditor.Exists exists() {
        return this.exists;
    }

    @Override
    public EntityEditModel.EntityEditor.Modified modified() {
        return this.modified;
    }

    @Override
    public Observer<Entity> changing() {
        return this.changing.observer();
    }

    @Override
    public Observer<Attribute<?>> valueChanged() {
        return this.valueChanged.observer();
    }

    @Override
    public boolean nullable(Attribute<?> attribute) {
        return ((EntityValidator)this.validator.getOrThrow()).nullable(this.entity, attribute);
    }

    @Override
    public ObservableState isNull(Attribute<?> attribute) {
        return this.attributeNull.computeIfAbsent(attribute, k -> State.state((boolean)this.entity.isNull(attribute))).observable();
    }

    @Override
    public ObservableState isNotNull(Attribute<?> attribute) {
        return this.attributeNull.computeIfAbsent(attribute, k -> State.state((boolean)this.entity.isNull(attribute))).observable().not();
    }

    @Override
    public ObservableState primaryKeyNull() {
        return this.primaryKeyNull.observable();
    }

    @Override
    public Value<EntityValidator> validator() {
        return this.validator;
    }

    @Override
    public ObservableState valid() {
        return this.entityValid.observable();
    }

    @Override
    public void validate() {
        this.validate(this.entity);
    }

    @Override
    public void validate(Attribute<?> attribute) {
        ((EntityValidator)this.validator.getOrThrow()).validate(this.entity, attribute);
    }

    @Override
    public void validate(Collection<Entity> entities) {
        for (Entity entityToValidate : Objects.requireNonNull(entities)) {
            this.validate(entityToValidate);
        }
    }

    @Override
    public void validate(Entity entity) {
        if (entity.type().equals(this.entityDefinition.type())) {
            ((EntityValidator)this.validator.getOrThrow()).validate(entity);
        } else {
            entity.definition().validator().validate(entity);
        }
    }

    @Override
    public <T> EntityEditModel.ValueEditor<T> value(Attribute<T> attribute) {
        return this.valueEditors.computeIfAbsent(attribute, this::createValueEditor);
    }

    void setOrDefaults(Entity entity) {
        Map affectedAttributes = this.entity.set(entity == null ? this.createEntity(this::defaultValue) : entity);
        for (Attribute affectedAttribute : affectedAttributes.keySet()) {
            this.notifyValueChange(affectedAttribute);
        }
        if (affectedAttributes.isEmpty()) {
            this.updateStates();
        }
        this.attributeModified.forEach(this::updateAttributeModifiedState);
        this.changed.accept((Object)entity);
    }

    private <T> T defaultValue(AttributeDefinition<T> attributeDefinition) {
        if (this.value(attributeDefinition.attribute()).persist().get().booleanValue()) {
            if (attributeDefinition instanceof ForeignKeyDefinition) {
                return (T)this.entity.entity((ForeignKey)attributeDefinition.attribute());
            }
            return (T)this.entity.get(attributeDefinition.attribute());
        }
        return ((Supplier)this.value(attributeDefinition.attribute()).defaultValue().getOrThrow()).get();
    }

    private <T> void notifyValueEdit(Attribute<T> attribute, T value, Map<Attribute<?>, Object> dependingValues) {
        this.notifyValueChange(attribute);
        Event<?> editEvent = this.editEvents.get(attribute);
        if (editEvent != null) {
            editEvent.accept(value);
        }
        dependingValues.forEach((dependingAttribute, previousValue) -> {
            Object currentValue = this.entity.get(dependingAttribute);
            if (!Objects.equals(previousValue, currentValue)) {
                this.notifyValueEdit((Attribute)dependingAttribute, (Object)currentValue, Collections.emptyMap());
            }
        });
    }

    private void notifyValueChange(Attribute<?> attribute) {
        this.updateStates();
        this.updateAttributeStates(attribute);
        DefaultValueEditor<?> valueEditor = this.valueEditors.get(attribute);
        if (valueEditor != null) {
            valueEditor.valueChanged();
        }
        this.valueChanged.accept(attribute);
    }

    private void updateStates() {
        this.exists.update();
        this.modified.update();
        this.updateValidState();
        this.updatePrimaryKeyNullState();
    }

    private <T> void updateAttributeStates(Attribute<T> attribute) {
        State modifiedState;
        State validState;
        State nullState = this.attributeNull.get(attribute);
        if (nullState != null) {
            nullState.set((Object)this.entity.isNull(attribute));
        }
        if ((validState = this.attributeValid.get(attribute)) != null) {
            validState.set((Object)this.isValid(attribute));
        }
        if ((modifiedState = this.attributeModified.get(attribute)) != null) {
            this.updateAttributeModifiedState(attribute, modifiedState);
        }
    }

    private boolean isValid(Attribute<?> attribute) {
        try {
            ((EntityValidator)this.validator.getOrThrow()).validate(this.entity, attribute);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    private void updateAttributeModifiedState(Attribute<?> attribute, State modifiedState) {
        modifiedState.set((Object)(((Predicate)this.exists.predicate.getOrThrow()).test(this.entity) && this.entity.modified(attribute) ? 1 : 0));
    }

    private void updateValidState() {
        this.entityValid.set((Object)((EntityValidator)this.validator.getOrThrow()).valid(this.entity));
    }

    private void updatePrimaryKeyNullState() {
        this.primaryKeyNull.set((Object)this.entity.primaryKey().isNull());
    }

    private Entity createEntity(ValueSupplier valueSupplier) {
        Entity newEntity = this.entityDefinition.entity();
        this.addColumnValues(valueSupplier, newEntity);
        this.addTransientValues(valueSupplier, newEntity);
        this.addForeignKeyValues(valueSupplier, newEntity);
        newEntity.save();
        return newEntity;
    }

    private void addColumnValues(ValueSupplier valueSupplier, Entity newEntity) {
        this.entityDefinition.columns().definitions().stream().filter(columnDefinition -> !this.entityDefinition.foreignKeys().foreignKeyColumn(columnDefinition.attribute())).filter(columnDefinition -> !columnDefinition.columnHasDefaultValue() || columnDefinition.hasDefaultValue()).map(columnDefinition -> columnDefinition).forEach(attributeDefinition -> newEntity.put(attributeDefinition.attribute(), valueSupplier.get(attributeDefinition)));
    }

    private void addTransientValues(ValueSupplier valueSupplier, Entity newEntity) {
        this.entityDefinition.attributes().definitions().stream().filter(TransientAttributeDefinition.class::isInstance).filter(attributeDefinition -> !attributeDefinition.derived()).map(attributeDefinition -> attributeDefinition).forEach(attributeDefinition -> newEntity.put(attributeDefinition.attribute(), valueSupplier.get(attributeDefinition)));
    }

    private void addForeignKeyValues(ValueSupplier valueSupplier, Entity newEntity) {
        this.entityDefinition.foreignKeys().definitions().forEach(foreignKeyDefinition -> newEntity.put((Attribute)foreignKeyDefinition.attribute(), (Object)((Entity)valueSupplier.get(foreignKeyDefinition))));
    }

    private void configurePersistentForeignKeys() {
        if (((Boolean)PERSIST_FOREIGN_KEYS.getOrThrow()).booleanValue()) {
            this.entityDefinition.foreignKeys().get().forEach(foreignKey -> this.value((Attribute)foreignKey).persist().set((Object)this.foreignKeyWritable((ForeignKey)foreignKey)));
        }
    }

    private boolean foreignKeyWritable(ForeignKey foreignKey) {
        return foreignKey.references().stream().map(ForeignKey.Reference::column).map(arg_0 -> ((EntityDefinition.Columns)this.entityDefinition.columns()).definition(arg_0)).map(ColumnDefinition.class::cast).anyMatch(columnDefinition -> !columnDefinition.readOnly());
    }

    private <T> DefaultValueEditor<?> createValueEditor(Attribute<T> attribute) {
        this.entityDefinition.attributes().definition(attribute);
        return new DefaultValueEditor<T>(attribute);
    }

    private static interface ValueSupplier {
        public <T> T get(AttributeDefinition<T> var1);
    }

    private final class DefaultExists
    implements EntityEditModel.EntityEditor.Exists {
        private final State exists = State.state((boolean)false);
        private final Value<Predicate<Entity>> predicate;

        private DefaultExists(EntityDefinition definition) {
            this.predicate = Value.builder().nonNull((Object)definition.exists()).listener(this::update).build();
        }

        @Override
        public Value<Predicate<Entity>> predicate() {
            return this.predicate;
        }

        public ObservableState not() {
            return this.exists.not();
        }

        public Boolean get() {
            return this.exists.get();
        }

        public Observer<Boolean> observer() {
            return this.exists.observer();
        }

        private void update() {
            this.exists.set((Object)((Predicate)this.predicate.getOrThrow()).test(DefaultEntityEditor.this.entity));
        }
    }

    private final class DefaultModified
    implements EntityEditModel.EntityEditor.Modified {
        private final State modified = State.state();
        private final Value<Predicate<Entity>> predicate = Value.builder().nonNull(Entity::modified).listener(this::update).build();

        private DefaultModified() {
        }

        @Override
        public Value<Predicate<Entity>> predicate() {
            return this.predicate;
        }

        public ObservableState not() {
            return this.modified.not();
        }

        public Boolean get() {
            return this.modified.get();
        }

        @Override
        public void update() {
            this.modified.set((Object)(((Predicate)DefaultEntityEditor.this.exists.predicate.getOrThrow()).test(DefaultEntityEditor.this.entity) && ((Predicate)this.predicate.getOrThrow()).test(DefaultEntityEditor.this.entity) ? 1 : 0));
        }

        public Observer<Boolean> observer() {
            return this.modified.observer();
        }
    }

    private final class DefaultValueEditor<T>
    extends AbstractValue<T>
    implements EntityEditModel.ValueEditor<T> {
        private final Attribute<T> attribute;
        private final Value<Supplier<T>> defaultValue;

        private DefaultValueEditor(Attribute<T> attribute) {
            this.attribute = attribute;
            this.defaultValue = Value.nonNull(() -> ((AttributeDefinition)DefaultEntityEditor.this.entityDefinition.attributes().definition(attribute)).defaultValue());
        }

        @Override
        public void revert() {
            if (this.modified().get().booleanValue()) {
                super.set(DefaultEntityEditor.this.entity.original(this.attribute));
            }
        }

        @Override
        public State persist() {
            return DefaultEntityEditor.this.persistValues.computeIfAbsent(this.attribute, k -> State.state());
        }

        @Override
        public ObservableState valid() {
            return DefaultEntityEditor.this.attributeValid.computeIfAbsent(this.attribute, k -> State.state((boolean)DefaultEntityEditor.this.isValid(this.attribute))).observable();
        }

        @Override
        public ObservableState modified() {
            return DefaultEntityEditor.this.attributeModified.computeIfAbsent(this.attribute, k -> State.state((DefaultEntityEditor.this.exists.get() != false && DefaultEntityEditor.this.entity.modified(this.attribute) ? 1 : 0) != 0)).observable();
        }

        @Override
        public Observer<T> edited() {
            return DefaultEntityEditor.this.editEvents.computeIfAbsent(this.attribute, k -> Event.event()).observer();
        }

        @Override
        public Value<Supplier<T>> defaultValue() {
            return this.defaultValue;
        }

        protected T getValue() {
            return (T)DefaultEntityEditor.this.entity.get(this.attribute);
        }

        protected void setValue(T value) {
            Map<Attribute<?>, Object> dependingValues = this.dependingValues(this.attribute);
            Object previousValue = DefaultEntityEditor.this.entity.put(this.attribute, value);
            if (!Objects.equals(value, previousValue)) {
                DefaultEntityEditor.this.notifyValueEdit(this.attribute, value, dependingValues);
            }
        }

        private Map<Attribute<?>, Object> dependingValues(Attribute<?> attribute) {
            return this.dependingValues(attribute, new LinkedHashMap());
        }

        private Map<Attribute<?>, Object> dependingValues(Attribute<?> attribute, Map<Attribute<?>, Object> dependingValues) {
            this.addDependingDerivedAttributes(attribute, dependingValues);
            if (attribute instanceof Column) {
                this.addDependingForeignKeys((Column)attribute, dependingValues);
            } else if (attribute instanceof ForeignKey) {
                this.addDependingReferencedColumns((ForeignKey)attribute, dependingValues);
            }
            return dependingValues;
        }

        private void addDependingDerivedAttributes(Attribute<?> attribute, Map<Attribute<?>, Object> dependingValues) {
            DefaultEntityEditor.this.entityDefinition.attributes().derivedFrom(attribute).forEach(derivedAttribute -> {
                dependingValues.put((Attribute<?>)derivedAttribute, DefaultEntityEditor.this.entity.get(derivedAttribute));
                this.addDependingDerivedAttributes((Attribute<?>)derivedAttribute, dependingValues);
            });
        }

        private void addDependingForeignKeys(Column<?> column, Map<Attribute<?>, Object> dependingValues) {
            DefaultEntityEditor.this.entityDefinition.foreignKeys().definitions(column).forEach(foreignKeyDefinition -> dependingValues.put((Attribute<?>)foreignKeyDefinition.attribute(), DefaultEntityEditor.this.entity.get((Attribute)foreignKeyDefinition.attribute())));
        }

        private void addDependingReferencedColumns(ForeignKey foreignKey, Map<Attribute<?>, Object> dependingValues) {
            foreignKey.references().forEach(reference -> dependingValues.put((Attribute<?>)reference.column(), DefaultEntityEditor.this.entity.get((Attribute)reference.column())));
        }

        private void valueChanged() {
            this.notifyListeners();
        }
    }
}

