/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Conjunction;
import is.codion.common.state.ObservableState;
import is.codion.common.state.State;
import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntityQueryModel;
import is.codion.framework.model.EntityTableConditionModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

final class DefaultEntityQueryModel
implements EntityQueryModel {
    private static final Supplier<Condition> NULL_CONDITION_SUPPLIER = () -> null;
    private final EntityTableConditionModel conditionModel;
    private final EntityQueryModel.AdditionalCondition additionalWhere = new DefaultAdditionalCondition();
    private final EntityQueryModel.AdditionalCondition additionalHaving = new DefaultAdditionalCondition();
    private final Value<ObservableState> conditionEnabled;
    private final State conditionRequired = State.state();
    private final State conditionChanged = State.state();
    private final ValueSet<Attribute<?>> attributes = ((ValueSet.Builder)ValueSet.builder().validator((Value.Validator)new AttributeValidator())).build();
    private final Value<OrderBy> orderBy;
    private final Value<Integer> limit = Value.nullable();
    private final Value<Function<EntityQueryModel, List<Entity>>> query = Value.nonNull((Object)new DefaultQuery());
    private volatile RefreshConditions refreshConditions;

    DefaultEntityQueryModel(EntityTableConditionModel conditionModel) {
        this.conditionModel = Objects.requireNonNull(conditionModel);
        this.conditionEnabled = Value.nonNull((Object)conditionModel.enabled());
        this.orderBy = this.createOrderBy();
        this.resetConditionChanged();
        Runnable conditionListener = this::onConditionChanged;
        conditionModel.changed().addListener(conditionListener);
        this.additionalWhere.addListener(conditionListener);
        this.additionalWhere.conjunction().addListener(conditionListener);
        this.additionalHaving.addListener(conditionListener);
        this.additionalHaving.conjunction().addListener(conditionListener);
    }

    @Override
    public EntityType entityType() {
        return this.conditionModel.entityType();
    }

    @Override
    public EntityConnectionProvider connectionProvider() {
        return this.conditionModel.connectionProvider();
    }

    @Override
    public List<Entity> get() {
        return (List)((Function)this.query.getOrThrow()).apply(this);
    }

    @Override
    public EntityTableConditionModel conditions() {
        return this.conditionModel;
    }

    @Override
    public ValueSet<Attribute<?>> attributes() {
        return this.attributes;
    }

    @Override
    public Value<Integer> limit() {
        return this.limit;
    }

    @Override
    public Value<OrderBy> orderBy() {
        return this.orderBy;
    }

    @Override
    public State conditionRequired() {
        return this.conditionRequired;
    }

    @Override
    public ObservableState conditionChanged() {
        return this.conditionChanged.observable();
    }

    @Override
    public Value<ObservableState> conditionEnabled() {
        return this.conditionEnabled;
    }

    @Override
    public Value<Function<EntityQueryModel, List<Entity>>> query() {
        return this.query;
    }

    @Override
    public EntityQueryModel.AdditionalCondition where() {
        return this.additionalWhere;
    }

    @Override
    public EntityQueryModel.AdditionalCondition having() {
        return this.additionalHaving;
    }

    EntityConnection.Select createSelect() {
        return EntityConnection.Select.where((Condition)DefaultEntityQueryModel.createCondition(this.conditionModel.where(Conjunction.AND), this.additionalWhere)).having(DefaultEntityQueryModel.createCondition(this.conditionModel.having(Conjunction.AND), this.additionalHaving)).attributes(this.attributes.get()).limit((Integer)this.limit.get()).orderBy((OrderBy)this.orderBy.get()).build();
    }

    private static Condition createCondition(Condition entityCondition, EntityQueryModel.AdditionalCondition additional) {
        return additional.optional().map(Supplier::get).map(condition -> Condition.combination((Conjunction)((Conjunction)additional.conjunction().getOrThrow()), (Condition[])new Condition[]{entityCondition, condition})).map(Condition.class::cast).orElse(entityCondition);
    }

    private Value<OrderBy> createOrderBy() {
        EntityDefinition definition = this.conditionModel.connectionProvider().entities().definition(this.conditionModel.entityType());
        return definition.orderBy().map(Value::nonNull).orElse(Value.nullable());
    }

    private void resetConditionChanged() {
        this.refreshConditions = new RefreshConditions();
        this.conditionChanged.set((Object)false);
    }

    private void onConditionChanged() {
        this.conditionChanged.set((Object)(!Objects.equals(this.refreshConditions, new RefreshConditions()) ? 1 : 0));
    }

    private static final class DefaultAdditionalCondition
    extends AbstractValue<Supplier<Condition>>
    implements EntityQueryModel.AdditionalCondition {
        private Supplier<Condition> condition = NULL_CONDITION_SUPPLIER;
        private final Value<Conjunction> conjunction = Value.nonNull((Object)Conjunction.AND);

        private DefaultAdditionalCondition() {
            super(NULL_CONDITION_SUPPLIER, Value.Notify.WHEN_SET);
        }

        @Override
        public Value<Conjunction> conjunction() {
            return this.conjunction;
        }

        protected Supplier<Condition> getValue() {
            return this.condition;
        }

        protected void setValue(Supplier<Condition> condition) {
            this.condition = condition;
        }
    }

    private class AttributeValidator
    implements Value.Validator<Set<Attribute<?>>> {
        private AttributeValidator() {
        }

        public void validate(Set<Attribute<?>> attributes) {
            for (Attribute<?> attribute : attributes) {
                if (attribute.entityType().equals(DefaultEntityQueryModel.this.conditionModel.entityType())) continue;
                throw new IllegalArgumentException(attribute + " is not part of entity:  " + DefaultEntityQueryModel.this.conditionModel.entityType());
            }
        }
    }

    private final class DefaultQuery
    implements Function<EntityQueryModel, List<Entity>> {
        private DefaultQuery() {
        }

        @Override
        public List<Entity> apply(EntityQueryModel queryModel) {
            EntityConnection.Select select = DefaultEntityQueryModel.this.createSelect();
            if (DefaultEntityQueryModel.this.conditionRequired.get().booleanValue() && !((ObservableState)DefaultEntityQueryModel.this.conditionEnabled.getOrThrow()).get().booleanValue()) {
                DefaultEntityQueryModel.this.resetConditionChanged();
                return Collections.emptyList();
            }
            List items = DefaultEntityQueryModel.this.conditionModel.connectionProvider().connection().select(select);
            DefaultEntityQueryModel.this.resetConditionChanged();
            return items;
        }
    }

    private final class RefreshConditions {
        private final Condition where;
        private final Condition having;

        private RefreshConditions() {
            this.where = DefaultEntityQueryModel.createCondition(DefaultEntityQueryModel.this.conditionModel.where(Conjunction.AND), DefaultEntityQueryModel.this.additionalWhere);
            this.having = DefaultEntityQueryModel.createCondition(DefaultEntityQueryModel.this.conditionModel.having(Conjunction.AND), DefaultEntityQueryModel.this.additionalHaving);
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RefreshConditions that = (RefreshConditions)object;
            return Objects.equals(this.where, that.where) && Objects.equals(this.having, that.having);
        }

        public int hashCode() {
            return Objects.hash(this.where, this.having);
        }
    }
}

