/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.state.ObservableState;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntitySearchModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class DefaultEntitySearchModel
implements EntitySearchModel {
    private static final Supplier<Condition> NULL_CONDITION = () -> null;
    private static final String WILDCARD_MULTIPLE = "%";
    private static final String WILDCARD_SINGLE = "_";
    private final State selectionEmpty = State.state((boolean)true);
    private final EntityDefinition entityDefinition;
    private final Collection<Column<String>> searchColumns;
    private final Collection<Attribute<?>> attributes;
    private final OrderBy orderBy;
    private final DefaultSearch search = new DefaultSearch();
    private final DefaultSelection selection = new DefaultSelection();
    private final EntityConnectionProvider connectionProvider;
    private final Map<Column<String>, EntitySearchModel.Settings> settings;
    private final boolean singleSelection;
    private final Value<Supplier<Condition>> condition;
    private final Value<Integer> limit;

    private DefaultEntitySearchModel(DefaultBuilder builder) {
        this.entityDefinition = builder.entityDefinition;
        this.connectionProvider = builder.connectionProvider;
        this.searchColumns = Collections.unmodifiableCollection(builder.searchColumns);
        this.condition = Value.nonNull(builder.condition);
        this.attributes = builder.attributes;
        this.orderBy = builder.orderBy;
        this.settings = Collections.unmodifiableMap(this.searchColumns.stream().collect(Collectors.toMap(Function.identity(), column -> new DefaultSettings())));
        this.singleSelection = builder.singleSelection;
        this.limit = Value.nullable((Object)builder.limit);
    }

    @Override
    public EntityDefinition entityDefinition() {
        return this.entityDefinition;
    }

    @Override
    public EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public Collection<Column<String>> columns() {
        return this.searchColumns;
    }

    @Override
    public EntitySearchModel.Search search() {
        return this.search;
    }

    @Override
    public EntitySearchModel.Selection selection() {
        return this.selection;
    }

    @Override
    public Map<Column<String>, EntitySearchModel.Settings> settings() {
        return this.settings;
    }

    @Override
    public Value<Integer> limit() {
        return this.limit;
    }

    @Override
    public Value<Supplier<Condition>> condition() {
        return this.condition;
    }

    @Override
    public boolean singleSelection() {
        return this.singleSelection;
    }

    private void validateType(Entity entity) {
        if (!entity.type().equals(this.entityDefinition.type())) {
            throw new IllegalArgumentException("Entities of type " + this.entityDefinition.type() + " exptected, got " + entity.type());
        }
    }

    private static boolean containsWildcards(String value) {
        return value.contains(WILDCARD_MULTIPLE) || value.contains(WILDCARD_SINGLE);
    }

    private final class DefaultSearch
    implements EntitySearchModel.Search {
        private final ValueSet<String> strings = ((ValueSet.Builder)ValueSet.builder().notify(Value.Notify.WHEN_SET)).build();

        private DefaultSearch() {
        }

        @Override
        public ValueSet<String> strings() {
            return this.strings;
        }

        @Override
        public List<Entity> result() {
            List result = DefaultEntitySearchModel.this.connectionProvider.connection().select(this.select());
            result.sort(DefaultEntitySearchModel.this.entityDefinition.comparator());
            return result;
        }

        private EntityConnection.Select select() {
            if (DefaultEntitySearchModel.this.searchColumns.isEmpty()) {
                throw new IllegalStateException("No search columns provided for search model: " + DefaultEntitySearchModel.this.entityDefinition.type());
            }
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            for (Column<String> column : DefaultEntitySearchModel.this.searchColumns) {
                EntitySearchModel.Settings columnSettings = DefaultEntitySearchModel.this.settings.get(column);
                for (String rawSearchString : (Set)this.strings.get()) {
                    String preparedSearchString = this.prepareSearchString(rawSearchString, columnSettings);
                    boolean containsWildcards = DefaultEntitySearchModel.containsWildcards(preparedSearchString);
                    if (columnSettings.caseSensitive().get().booleanValue()) {
                        conditions.add((Condition)(containsWildcards ? column.like(preparedSearchString) : column.equalTo((Object)preparedSearchString)));
                        continue;
                    }
                    conditions.add((Condition)(containsWildcards ? column.likeIgnoreCase(preparedSearchString) : column.equalToIgnoreCase(preparedSearchString)));
                }
            }
            return EntityConnection.Select.where((Condition)this.createCombinedCondition(conditions)).attributes(DefaultEntitySearchModel.this.attributes).limit((Integer)DefaultEntitySearchModel.this.limit.get()).orderBy(DefaultEntitySearchModel.this.orderBy).build();
        }

        private String prepareSearchString(String rawSearchString, EntitySearchModel.Settings settings) {
            boolean wildcardPrefix = settings.wildcardPrefix().get();
            boolean wildcardPostfix = settings.wildcardPostfix().get();
            String string = rawSearchString = settings.spaceAsWildcard().get() != false ? rawSearchString.replace(' ', '%') : rawSearchString;
            return rawSearchString.equals(DefaultEntitySearchModel.WILDCARD_MULTIPLE) ? DefaultEntitySearchModel.WILDCARD_MULTIPLE : (wildcardPrefix ? DefaultEntitySearchModel.WILDCARD_MULTIPLE : "") + rawSearchString.trim() + (wildcardPostfix ? DefaultEntitySearchModel.WILDCARD_MULTIPLE : "");
        }

        private Condition createCombinedCondition(Collection<Condition> conditions) {
            Condition.Combination conditionCombination = Condition.or(conditions);
            Condition additionalCondition = (Condition)((Supplier)DefaultEntitySearchModel.this.condition.getOrThrow()).get();
            return additionalCondition == null ? conditionCombination : Condition.and((Condition[])new Condition[]{additionalCondition, conditionCombination});
        }
    }

    private final class DefaultSelection
    implements EntitySearchModel.Selection {
        private final ValueSet<Entity> entities;

        private DefaultSelection() {
            this.entities = ((ValueSet.Builder)((ValueSet.Builder)((ValueSet.Builder)ValueSet.builder().notify(Value.Notify.WHEN_SET)).validator((Value.Validator)new EntityValidator())).consumer(selectedEntities -> DefaultEntitySearchModel.this.selectionEmpty.set((Object)selectedEntities.isEmpty()))).build();
        }

        @Override
        public Value<Entity> entity() {
            return this.entities.value();
        }

        @Override
        public ValueSet<Entity> entities() {
            return this.entities;
        }

        @Override
        public ObservableState empty() {
            return DefaultEntitySearchModel.this.selectionEmpty.observable();
        }

        @Override
        public void clear() {
            this.entities.clear();
        }
    }

    static final class DefaultBuilder
    implements EntitySearchModel.Builder {
        private final EntityDefinition entityDefinition;
        private final EntityConnectionProvider connectionProvider;
        private Collection<Column<String>> searchColumns;
        private Supplier<Condition> condition = NULL_CONDITION;
        private Collection<Attribute<?>> attributes = Collections.emptyList();
        private boolean singleSelection = false;
        private Integer limit = (Integer)EntitySearchModel.DEFAULT_LIMIT.get();
        private OrderBy orderBy;

        DefaultBuilder(EntityType entityType, EntityConnectionProvider connectionProvider) {
            this.connectionProvider = Objects.requireNonNull(connectionProvider);
            this.entityDefinition = connectionProvider.entities().definition(entityType);
            this.searchColumns = this.entityDefinition.columns().searchable();
            this.orderBy = this.entityDefinition.orderBy().orElse(null);
        }

        @Override
        public EntitySearchModel.Builder searchColumns(Collection<Column<String>> searchColumns) {
            if (Objects.requireNonNull(searchColumns).isEmpty()) {
                throw new IllegalArgumentException("One or more search column is required");
            }
            this.validateAttributes(searchColumns);
            this.searchColumns = searchColumns;
            return this;
        }

        @Override
        public EntitySearchModel.Builder condition(Supplier<Condition> condition) {
            this.condition = Objects.requireNonNull(condition);
            return this;
        }

        @Override
        public EntitySearchModel.Builder attributes(Collection<Attribute<?>> attributes) {
            this.validateAttributes(Objects.requireNonNull(attributes));
            this.attributes = attributes;
            return this;
        }

        @Override
        public EntitySearchModel.Builder orderBy(OrderBy orderBy) {
            this.validateAttributes(Objects.requireNonNull(orderBy).orderByColumns().stream().map(OrderBy.OrderByColumn::column).collect(Collectors.toList()));
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public EntitySearchModel.Builder singleSelection(boolean singleSelection) {
            this.singleSelection = singleSelection;
            return this;
        }

        @Override
        public EntitySearchModel.Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public EntitySearchModel build() {
            return new DefaultEntitySearchModel(this);
        }

        private void validateAttributes(Collection<? extends Attribute<?>> attributes) {
            for (Attribute<?> attribute : attributes) {
                if (this.entityDefinition.type().equals(attribute.entityType())) continue;
                throw new IllegalArgumentException("Attribute '" + attribute + "' is not part of entity " + this.entityDefinition.type());
            }
        }
    }

    private static final class DefaultSettings
    implements EntitySearchModel.Settings {
        private final State wildcardPrefixState = State.state((boolean)true);
        private final State wildcardPostfixState = State.state((boolean)true);
        private final State caseSensitiveState = State.state((boolean)false);
        private final State spaceAsWildcard = State.state((boolean)true);

        private DefaultSettings() {
        }

        @Override
        public State wildcardPrefix() {
            return this.wildcardPrefixState;
        }

        @Override
        public State wildcardPostfix() {
            return this.wildcardPostfixState;
        }

        @Override
        public State spaceAsWildcard() {
            return this.spaceAsWildcard;
        }

        @Override
        public State caseSensitive() {
            return this.caseSensitiveState;
        }
    }

    private final class EntityValidator
    implements Value.Validator<Set<Entity>> {
        private EntityValidator() {
        }

        public void validate(Set<Entity> entitySet) {
            if (entitySet != null) {
                if (entitySet.size() > 1 && DefaultEntitySearchModel.this.singleSelection) {
                    throw new IllegalArgumentException("This EntitySearchModel does not allow the selection of multiple entities");
                }
                entitySet.forEach(DefaultEntitySearchModel.this::validateType);
            }
        }
    }
}

