/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Conjunction;
import is.codion.common.Operator;
import is.codion.common.event.Event;
import is.codion.common.model.condition.ConditionModel;
import is.codion.common.model.condition.TableConditionModel;
import is.codion.common.observable.Observer;
import is.codion.common.state.ObservableState;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntityTableConditionModel;
import is.codion.framework.model.ForeignKeyConditionModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class DefaultEntityTableConditionModel
implements EntityTableConditionModel {
    private final EntityDefinition entityDefinition;
    private final EntityConnectionProvider connectionProvider;
    private final TableConditionModel<Attribute<?>> tableConditionModel;
    private final Event<?> conditionChangedEvent = Event.event();
    private final NoneAggregateColumn noneAggregateColumn = new NoneAggregateColumn();
    private final AggregateColumn aggregateColumn = new AggregateColumn();

    DefaultEntityTableConditionModel(EntityType entityType, EntityConnectionProvider connectionProvider, Supplier<Map<Attribute<?>, ConditionModel<?>>> conditionModels) {
        this.entityDefinition = connectionProvider.entities().definition(Objects.requireNonNull(entityType));
        this.connectionProvider = Objects.requireNonNull(connectionProvider);
        this.tableConditionModel = TableConditionModel.tableConditionModel(conditionModels);
        this.bindEvents();
    }

    @Override
    public EntityType entityType() {
        return this.entityDefinition.type();
    }

    @Override
    public EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public Condition where(Conjunction conjunction) {
        return this.createCondition(conjunction, this.noneAggregateColumn);
    }

    @Override
    public Condition having(Conjunction conjunction) {
        return this.createCondition(conjunction, this.aggregateColumn);
    }

    @Override
    public TableConditionModel<Attribute<?>> conditionModel() {
        return this.tableConditionModel;
    }

    @Override
    public Map<Attribute<?>, ConditionModel<?>> get() {
        return this.tableConditionModel.get();
    }

    @Override
    public <T> Optional<ConditionModel<T>> optional(Attribute<T> attribute) {
        return this.tableConditionModel.optional(Objects.requireNonNull(attribute));
    }

    @Override
    public <T> ConditionModel<T> get(Column<T> column) {
        return this.tableConditionModel.get(column);
    }

    @Override
    public ForeignKeyConditionModel get(ForeignKey foreignKey) {
        ConditionModel model = this.tableConditionModel.get((Object)foreignKey);
        return (ForeignKeyConditionModel)model;
    }

    @Override
    public ObservableState enabled() {
        return this.tableConditionModel.enabled();
    }

    @Override
    public Observer<?> changed() {
        return this.tableConditionModel.changed();
    }

    @Override
    public ValueSet<Attribute<?>> persist() {
        return this.tableConditionModel.persist();
    }

    @Override
    public void clear() {
        this.tableConditionModel.clear();
    }

    private Condition createCondition(Conjunction conjunction, Predicate<Attribute<?>> columnType) {
        List conditions = this.tableConditionModel.get().entrySet().stream().filter(entry -> columnType.test((Attribute)entry.getKey())).filter(entry -> ((ConditionModel)entry.getValue()).enabled().get()).map(entry -> DefaultEntityTableConditionModel.condition((ConditionModel)entry.getValue(), (Attribute)entry.getKey())).collect(Collectors.toList());
        switch (conditions.size()) {
            case 0: {
                return Condition.all((EntityType)this.entityDefinition.type());
            }
            case 1: {
                return (Condition)conditions.get(0);
            }
        }
        return Condition.combination((Conjunction)conjunction, conditions);
    }

    private void bindEvents() {
        this.tableConditionModel.get().values().forEach(conditionModel -> conditionModel.changed().addListener(this.conditionChangedEvent));
    }

    private static Condition condition(ConditionModel<?> conditionModel, Attribute<?> identifier) {
        if (identifier instanceof ForeignKey) {
            return DefaultEntityTableConditionModel.foreignKeyCondition(conditionModel, (ForeignKey)identifier);
        }
        return DefaultEntityTableConditionModel.columnCondition(conditionModel, identifier);
    }

    private static Condition foreignKeyCondition(ConditionModel<Entity> conditionModel, ForeignKey foreignKey) {
        Entity equalOperand = (Entity)conditionModel.operands().equal().get();
        Collection inOperands = conditionModel.operands().in().get();
        switch ((Operator)conditionModel.operator().getOrThrow()) {
            case EQUAL: {
                return equalOperand == null ? foreignKey.isNull() : foreignKey.equalTo(equalOperand);
            }
            case IN: {
                return inOperands.isEmpty() ? foreignKey.isNull() : foreignKey.in(inOperands);
            }
            case NOT_EQUAL: {
                return equalOperand == null ? foreignKey.isNotNull() : foreignKey.notEqualTo(equalOperand);
            }
            case NOT_IN: {
                return inOperands.isEmpty() ? foreignKey.isNotNull() : foreignKey.notIn(inOperands);
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + conditionModel.operator().get() + " for foreign key condition");
    }

    private static <T> ColumnCondition<T> columnCondition(ConditionModel<T> conditionModel, Attribute<?> identifier) {
        Column column = (Column)identifier;
        ConditionModel.Operands operands = conditionModel.operands();
        switch ((Operator)conditionModel.operator().getOrThrow()) {
            case EQUAL: {
                return DefaultEntityTableConditionModel.equalCondition(conditionModel, column);
            }
            case NOT_EQUAL: {
                return DefaultEntityTableConditionModel.notEqualCondition(conditionModel, column);
            }
            case LESS_THAN: {
                return column.lessThan(operands.upper().get());
            }
            case LESS_THAN_OR_EQUAL: {
                return column.lessThanOrEqualTo(operands.upper().get());
            }
            case GREATER_THAN: {
                return column.greaterThan(operands.lower().get());
            }
            case GREATER_THAN_OR_EQUAL: {
                return column.greaterThanOrEqualTo(operands.lower().get());
            }
            case BETWEEN_EXCLUSIVE: {
                return DefaultEntityTableConditionModel.betweenExclusiveCondition(operands.lower().get(), operands.upper().get(), column);
            }
            case BETWEEN: {
                return DefaultEntityTableConditionModel.betweenCondition(operands.lower().get(), operands.upper().get(), column);
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return DefaultEntityTableConditionModel.notBetweenExclusiveCondition(operands.lower().get(), operands.upper().get(), column);
            }
            case NOT_BETWEEN: {
                return DefaultEntityTableConditionModel.notBetweenCondition(operands.lower().get(), operands.upper().get(), column);
            }
            case IN: {
                return DefaultEntityTableConditionModel.inCondition(conditionModel, column);
            }
            case NOT_IN: {
                return DefaultEntityTableConditionModel.notInCondition(conditionModel, column);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + conditionModel.operator().get());
    }

    private static <T> ColumnCondition<T> equalCondition(ConditionModel<T> conditionModel, Column<T> column) {
        Object equalOperand = conditionModel.operands().equal().get();
        if (equalOperand == null) {
            return column.isNull();
        }
        if (column.type().isString()) {
            return DefaultEntityTableConditionModel.singleStringEqualCondition(conditionModel, column, conditionModel.operands().equalWildcards());
        }
        if (column.type().isCharacter()) {
            return DefaultEntityTableConditionModel.singleCharacterEqualCondition(conditionModel, column, (Character)equalOperand);
        }
        return column.equalTo(equalOperand);
    }

    private static <T> ColumnCondition<T> notEqualCondition(ConditionModel<T> conditionModel, Column<T> column) {
        Object equalOperand = conditionModel.operands().equal().get();
        if (equalOperand == null) {
            return column.isNotNull();
        }
        if (column.type().isString()) {
            return DefaultEntityTableConditionModel.singleStringNotEqualCondition(conditionModel, column, conditionModel.operands().equalWildcards());
        }
        if (column.type().isCharacter()) {
            return DefaultEntityTableConditionModel.singleCharacterNotEqualCondition(conditionModel, column, (Character)equalOperand);
        }
        return column.notEqualTo(equalOperand);
    }

    private static <T> ColumnCondition<T> singleStringEqualCondition(ConditionModel<T> conditionModel, Column<T> column, String value) {
        boolean caseSensitive = conditionModel.caseSensitive().get();
        if (DefaultEntityTableConditionModel.containsWildcards(value)) {
            return caseSensitive ? column.like(value) : column.likeIgnoreCase(value);
        }
        return caseSensitive ? column.equalTo((Object)value) : column.equalToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> singleCharacterEqualCondition(ConditionModel<T> conditionModel, Column<T> column, Character value) {
        return conditionModel.caseSensitive().get() != false ? column.equalTo((Object)value) : column.equalToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> singleStringNotEqualCondition(ConditionModel<T> conditionModel, Column<T> column, String value) {
        boolean caseSensitive = conditionModel.caseSensitive().get();
        if (DefaultEntityTableConditionModel.containsWildcards(value)) {
            return caseSensitive ? column.notLike(value) : column.notLikeIgnoreCase(value);
        }
        return caseSensitive ? column.notEqualTo((Object)value) : column.notEqualToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> singleCharacterNotEqualCondition(ConditionModel<T> conditionModel, Column<T> column, Character value) {
        return conditionModel.caseSensitive().get() != false ? column.notEqualTo((Object)value) : column.notEqualToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> betweenExclusiveCondition(T lower, T upper, Column<T> column) {
        if (lower == null && upper != null) {
            return column.lessThan(upper);
        }
        if (upper == null && lower != null) {
            return column.greaterThan(lower);
        }
        return column.betweenExclusive(lower, upper);
    }

    private static <T> ColumnCondition<T> betweenCondition(T lower, T upper, Column<T> column) {
        if (lower == null && upper != null) {
            return column.lessThanOrEqualTo(upper);
        }
        if (upper == null && lower != null) {
            return column.greaterThanOrEqualTo(lower);
        }
        return column.between(lower, upper);
    }

    private static <T> ColumnCondition<T> notBetweenExclusiveCondition(T lower, T upper, Column<T> column) {
        if (lower == null && upper != null) {
            return column.greaterThan(upper);
        }
        if (upper == null && lower != null) {
            return column.lessThan(lower);
        }
        return column.notBetweenExclusive(lower, upper);
    }

    private static <T> ColumnCondition<T> notBetweenCondition(T lower, T upper, Column<T> column) {
        if (lower == null && upper != null) {
            return column.greaterThanOrEqualTo(upper);
        }
        if (upper == null && lower != null) {
            return column.lessThanOrEqualTo(lower);
        }
        return column.notBetween(lower, upper);
    }

    private static <T> ColumnCondition<T> inCondition(ConditionModel<T> conditionModel, Column<T> column) {
        Set operands = (Set)conditionModel.operands().in().get();
        if (operands.isEmpty()) {
            return column.isNull();
        }
        if (column.type().isString()) {
            Column<T> stringColumn = column;
            Set inOperands = operands;
            return conditionModel.caseSensitive().get() != false ? stringColumn.in((Collection)inOperands) : stringColumn.inIgnoreCase((Collection)inOperands);
        }
        return column.in((Collection)operands);
    }

    private static <T> ColumnCondition<T> notInCondition(ConditionModel<T> conditionModel, Column<T> column) {
        Set operands = (Set)conditionModel.operands().in().get();
        if (operands.isEmpty()) {
            return column.isNotNull();
        }
        if (column.type().isString()) {
            Column<T> stringColumn = column;
            Set inOperands = operands;
            return conditionModel.caseSensitive().get() != false ? stringColumn.notIn((Collection)inOperands) : stringColumn.notInIgnoreCase((Collection)inOperands);
        }
        return column.notIn((Collection)operands);
    }

    private static boolean containsWildcards(String value) {
        return value != null && (value.contains("%") || value.contains("_"));
    }

    private final class NoneAggregateColumn
    implements Predicate<Attribute<?>> {
        private NoneAggregateColumn() {
        }

        @Override
        public boolean test(Attribute<?> attribute) {
            return !(attribute instanceof Column) || !DefaultEntityTableConditionModel.this.entityDefinition.columns().definition((Column)attribute).aggregate();
        }
    }

    private final class AggregateColumn
    implements Predicate<Attribute<?>> {
        private AggregateColumn() {
        }

        @Override
        public boolean test(Attribute<?> attribute) {
            return attribute instanceof Column && DefaultEntityTableConditionModel.this.entityDefinition.columns().definition((Column)attribute).aggregate();
        }
    }
}

