/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Operator;
import is.codion.common.model.condition.ConditionModel;
import is.codion.common.observable.Observer;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.model.EntitySearchModel;
import is.codion.framework.model.ForeignKeyConditionModel;
import java.text.Format;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class DefaultForeignKeyConditionModel
implements ForeignKeyConditionModel {
    private final ConditionModel<Entity> condition;
    private final EntitySearchModel equalSearchModel;
    private final EntitySearchModel inSearchModel;

    private DefaultForeignKeyConditionModel(DefaultBuilder builder) {
        this.equalSearchModel = builder.equalSearchModel;
        this.inSearchModel = builder.inSearchModel;
        this.condition = ConditionModel.builder(Entity.class).operators(builder.operators()).operator(builder.inSearchModel == null ? Operator.EQUAL : Operator.IN).operands((ConditionModel.Operands)new ForeignKeyOperands()).build();
    }

    public State caseSensitive() {
        return this.condition.caseSensitive();
    }

    public Optional<Format> format() {
        return this.condition.format();
    }

    public Optional<String> dateTimePattern() {
        return this.condition.dateTimePattern();
    }

    public State autoEnable() {
        return this.condition.autoEnable();
    }

    public State locked() {
        return this.condition.locked();
    }

    public Class<Entity> valueClass() {
        return this.condition.valueClass();
    }

    public List<Operator> operators() {
        return this.condition.operators();
    }

    public State enabled() {
        return this.condition.enabled();
    }

    public void clear() {
        this.condition.clear();
    }

    public Value<Operator> operator() {
        return this.condition.operator();
    }

    public ConditionModel.Operands<Entity> operands() {
        return this.condition.operands();
    }

    public ConditionModel.SetCondition<Entity> set() {
        return this.condition.set();
    }

    public boolean accepts(Comparable<Entity> value) {
        return this.condition.accepts(value);
    }

    public Observer<?> changed() {
        return this.condition.changed();
    }

    @Override
    public EntitySearchModel equalSearchModel() {
        if (this.equalSearchModel == null) {
            throw new IllegalStateException("No EntitySearchModel available for the EQUAL operand");
        }
        return this.equalSearchModel;
    }

    @Override
    public EntitySearchModel inSearchModel() {
        if (this.inSearchModel == null) {
            throw new IllegalStateException("No EntitySearchModel available for the IN operand");
        }
        return this.inSearchModel;
    }

    static final class DefaultBuilder
    implements ForeignKeyConditionModel.Builder {
        private EntitySearchModel equalSearchModel;
        private EntitySearchModel inSearchModel;

        DefaultBuilder() {
        }

        @Override
        public ForeignKeyConditionModel.Builder equalSearchModel(EntitySearchModel equalSearchModel) {
            this.equalSearchModel = Objects.requireNonNull(equalSearchModel);
            return this;
        }

        @Override
        public ForeignKeyConditionModel.Builder inSearchModel(EntitySearchModel inSearchModel) {
            this.inSearchModel = Objects.requireNonNull(inSearchModel);
            return this;
        }

        @Override
        public ForeignKeyConditionModel build() {
            return new DefaultForeignKeyConditionModel(this);
        }

        private List<Operator> operators() {
            if (this.equalSearchModel == null && this.inSearchModel == null) {
                throw new IllegalStateException("Neither EQUAL nor IN operator specified");
            }
            if (this.equalSearchModel != null && this.inSearchModel != null) {
                return Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL, Operator.IN, Operator.NOT_IN);
            }
            if (this.equalSearchModel != null) {
                return Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL);
            }
            return Arrays.asList(Operator.IN, Operator.NOT_IN);
        }
    }

    private final class ForeignKeyOperands
    implements ConditionModel.Operands<Entity> {
        private ForeignKeyOperands() {
        }

        public Value<Entity> equal() {
            return DefaultForeignKeyConditionModel.this.equalSearchModel == null ? super.equal() : DefaultForeignKeyConditionModel.this.equalSearchModel.selection().entity();
        }

        public ValueSet<Entity> in() {
            return DefaultForeignKeyConditionModel.this.inSearchModel == null ? super.in() : DefaultForeignKeyConditionModel.this.inSearchModel.selection().entities();
        }
    }
}

