/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.state.State;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.framework.model.ForeignKeyModelLink;
import is.codion.framework.model.ModelLink;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class DefaultForeignKeyModelLink<M extends EntityModel<M, E, T>, E extends EntityEditModel, T extends EntityTableModel<E>>
implements ForeignKeyModelLink<M, E, T> {
    private final ForeignKey foreignKey;
    private final ModelLink<M, E, T> modelLink;
    private final boolean clearValueOnEmptySelection;
    private final boolean clearConditionOnEmptySelection;
    private final boolean setValueOnInsert;
    private final boolean setConditionOnInsert;
    private final boolean refreshOnSelection;

    private DefaultForeignKeyModelLink(DefaultBuilder<M, E, T, ?> builder) {
        this.modelLink = ModelLink.builder(builder.model).onSelection(builder.onSelection == null ? new OnSelection() : builder.onSelection).onInsert(builder.onInsert == null ? new OnInsert() : builder.onInsert).onUpdate(builder.onUpdate == null ? new OnUpdate() : builder.onUpdate).onDelete(builder.onDelete == null ? new OnDelete() : builder.onDelete).active(builder.active).build();
        this.foreignKey = builder.foreignKey;
        this.clearValueOnEmptySelection = builder.clearValueOnEmptySelection;
        this.clearConditionOnEmptySelection = builder.clearConditionOnEmptySelection;
        this.setValueOnInsert = builder.setValueOnInsert;
        this.setConditionOnInsert = builder.setConditionOnInsert;
        this.refreshOnSelection = builder.refreshOnSelection;
        if (this.modelLink.model().containsTableModel()) {
            this.modelLink.model().tableModel().queryModel().conditions().persist().add((Object)this.foreignKey);
        }
    }

    @Override
    public ForeignKey foreignKey() {
        return this.foreignKey;
    }

    @Override
    public M model() {
        return this.modelLink.model();
    }

    @Override
    public State active() {
        return this.modelLink.active();
    }

    @Override
    public void onSelection(Collection<Entity> selectedEntities) {
        this.modelLink.onSelection(selectedEntities);
    }

    @Override
    public void onInsert(Collection<Entity> insertedEntities) {
        this.modelLink.onInsert(insertedEntities);
    }

    @Override
    public void onUpdate(Map<Entity, Entity> updatedEntities) {
        this.modelLink.onUpdate(updatedEntities);
    }

    @Override
    public void onDelete(Collection<Entity> deletedEntities) {
        this.modelLink.onDelete(deletedEntities);
    }

    private Collection<Entity> ofReferencedType(Collection<Entity> entities) {
        return entities.stream().filter(entity -> entity.type().equals(this.foreignKey.referencedType())).collect(Collectors.toList());
    }

    static final class DefaultBuilder<M extends EntityModel<M, E, T>, E extends EntityEditModel, T extends EntityTableModel<E>, B extends ForeignKeyModelLink.Builder<M, E, T, B>>
    implements ForeignKeyModelLink.Builder<M, E, T, B> {
        private final M model;
        private final ForeignKey foreignKey;
        private Consumer<Collection<Entity>> onSelection;
        private Consumer<Collection<Entity>> onInsert;
        private Consumer<Map<Entity, Entity>> onUpdate;
        private Consumer<Collection<Entity>> onDelete;
        private boolean clearValueOnEmptySelection = (Boolean)ForeignKeyModelLink.CLEAR_VALUE_ON_EMPTY_SELECTION.getOrThrow();
        private boolean clearConditionOnEmptySelection = (Boolean)ForeignKeyModelLink.CLEAR_CONDITION_ON_EMPTY_SELECTION.getOrThrow();
        private boolean setValueOnInsert = (Boolean)ForeignKeyModelLink.SET_VALUE_ON_INSERT.getOrThrow();
        private boolean setConditionOnInsert = (Boolean)ForeignKeyModelLink.SET_CONDITION_ON_INSERT.getOrThrow();
        private boolean refreshOnSelection = (Boolean)ForeignKeyModelLink.REFRESH_ON_SELECTION.getOrThrow();
        private boolean active = false;

        DefaultBuilder(M model, ForeignKey foreignKey) {
            this.model = (EntityModel)Objects.requireNonNull(model);
            this.foreignKey = Objects.requireNonNull(foreignKey);
        }

        @Override
        public B onSelection(Consumer<Collection<Entity>> onSelection) {
            this.onSelection = Objects.requireNonNull(onSelection);
            return (B)this;
        }

        @Override
        public B onInsert(Consumer<Collection<Entity>> onInsert) {
            this.onInsert = Objects.requireNonNull(onInsert);
            return (B)this;
        }

        @Override
        public B onUpdate(Consumer<Map<Entity, Entity>> onUpdate) {
            this.onUpdate = Objects.requireNonNull(onUpdate);
            return (B)this;
        }

        @Override
        public B onDelete(Consumer<Collection<Entity>> onDelete) {
            this.onDelete = Objects.requireNonNull(onDelete);
            return (B)this;
        }

        @Override
        public B setConditionOnInsert(boolean setConditionOnInsert) {
            this.setConditionOnInsert = setConditionOnInsert;
            return (B)this;
        }

        @Override
        public B setValueOnInsert(boolean setValueOnInsert) {
            this.setValueOnInsert = setValueOnInsert;
            return (B)this;
        }

        @Override
        public B refreshOnSelection(boolean refreshOnSelection) {
            this.refreshOnSelection = refreshOnSelection;
            return (B)this;
        }

        @Override
        public B clearValueOnEmptySelection(boolean clearValueOnEmptySelection) {
            this.clearValueOnEmptySelection = clearValueOnEmptySelection;
            return (B)this;
        }

        @Override
        public B clearConditionOnEmptySelection(boolean clearConditionOnEmptySelection) {
            this.clearConditionOnEmptySelection = clearConditionOnEmptySelection;
            return (B)this;
        }

        @Override
        public B active(boolean active) {
            this.active = active;
            return (B)this;
        }

        @Override
        public ForeignKeyModelLink<M, E, T> build() {
            return new DefaultForeignKeyModelLink(this);
        }
    }

    private final class OnSelection
    implements Consumer<Collection<Entity>> {
        private OnSelection() {
        }

        @Override
        public void accept(Collection<Entity> selectedEntities) {
            if (DefaultForeignKeyModelLink.this.model().containsTableModel() && this.setConditionOnSelection(selectedEntities) && DefaultForeignKeyModelLink.this.refreshOnSelection) {
                DefaultForeignKeyModelLink.this.model().tableModel().items().refresh(result -> this.setValueOnSelection(selectedEntities));
            } else {
                this.setValueOnSelection(selectedEntities);
            }
        }

        private boolean setConditionOnSelection(Collection<Entity> selectedEntities) {
            if (!selectedEntities.isEmpty() || DefaultForeignKeyModelLink.this.clearConditionOnEmptySelection) {
                return DefaultForeignKeyModelLink.this.model().tableModel().queryModel().conditions().get(DefaultForeignKeyModelLink.this.foreignKey).set().in(selectedEntities);
            }
            return false;
        }

        private void setValueOnSelection(Collection<Entity> entities) {
            Entity foreignKeyValue;
            Entity entity = foreignKeyValue = entities.isEmpty() ? null : entities.iterator().next();
            if (DefaultForeignKeyModelLink.this.model().editModel().editor().exists().not().get().booleanValue() && (foreignKeyValue != null || DefaultForeignKeyModelLink.this.clearValueOnEmptySelection)) {
                DefaultForeignKeyModelLink.this.model().editModel().editor().value(DefaultForeignKeyModelLink.this.foreignKey).set(foreignKeyValue);
            }
        }
    }

    private final class OnInsert
    implements Consumer<Collection<Entity>> {
        private OnInsert() {
        }

        @Override
        public void accept(Collection<Entity> insertedEntities) {
            Collection<Entity> entities = DefaultForeignKeyModelLink.this.ofReferencedType(insertedEntities);
            if (!entities.isEmpty()) {
                DefaultForeignKeyModelLink.this.model().editModel().add(DefaultForeignKeyModelLink.this.foreignKey, entities);
                Entity insertedEntity = entities.iterator().next();
                this.setValueOnInsert(insertedEntity);
                if (DefaultForeignKeyModelLink.this.model().containsTableModel() && this.setConditionOnInsert(insertedEntity)) {
                    DefaultForeignKeyModelLink.this.model().tableModel().items().refresh();
                }
            }
        }

        private void setValueOnInsert(Entity foreignKeyValue) {
            if (DefaultForeignKeyModelLink.this.model().editModel().editor().exists().not().get().booleanValue() && DefaultForeignKeyModelLink.this.setValueOnInsert) {
                DefaultForeignKeyModelLink.this.model().editModel().editor().value(DefaultForeignKeyModelLink.this.foreignKey).set(foreignKeyValue);
            }
        }

        private boolean setConditionOnInsert(Entity insertedEntity) {
            if (DefaultForeignKeyModelLink.this.setConditionOnInsert) {
                return DefaultForeignKeyModelLink.this.model().tableModel().queryModel().conditions().get(DefaultForeignKeyModelLink.this.foreignKey).set().in((Object[])new Entity[]{insertedEntity});
            }
            return false;
        }
    }

    private final class OnUpdate
    implements Consumer<Map<Entity, Entity>> {
        private OnUpdate() {
        }

        @Override
        public void accept(Map<Entity, Entity> updatedEntities) {
            Collection<Entity> entities = DefaultForeignKeyModelLink.this.ofReferencedType(updatedEntities.values());
            DefaultForeignKeyModelLink.this.model().editModel().replace(DefaultForeignKeyModelLink.this.foreignKey, entities);
            if (DefaultForeignKeyModelLink.this.model().containsTableModel() && DefaultForeignKeyModelLink.this.model().tableModel().handleEditEvents().not().get().booleanValue()) {
                DefaultForeignKeyModelLink.this.model().tableModel().replace(DefaultForeignKeyModelLink.this.foreignKey, entities);
            }
        }
    }

    private final class OnDelete
    implements Consumer<Collection<Entity>> {
        private OnDelete() {
        }

        @Override
        public void accept(Collection<Entity> deletedEntities) {
            DefaultForeignKeyModelLink.this.model().editModel().remove(DefaultForeignKeyModelLink.this.foreignKey, DefaultForeignKeyModelLink.this.ofReferencedType(deletedEntities));
        }
    }
}

