/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.state.State;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.framework.model.ModelLink;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

final class DefaultModelLink<M extends EntityModel<M, E, T>, E extends EntityEditModel, T extends EntityTableModel<E>>
implements ModelLink<M, E, T> {
    private final M model;
    private final State active;
    private final Consumer<Collection<Entity>> onSelection;
    private final Consumer<Collection<Entity>> onInsert;
    private final Consumer<Map<Entity, Entity>> onUpdate;
    private final Consumer<Collection<Entity>> onDelete;

    private DefaultModelLink(DefaultBuilder<M, E, T, ?> builder) {
        this.model = builder.model;
        this.active = State.state((boolean)builder.active);
        this.onSelection = builder.onSelection;
        this.onInsert = builder.onInsert;
        this.onUpdate = builder.onUpdate;
        this.onDelete = builder.onDelete;
        if (this.model.containsTableModel()) {
            this.model.tableModel().queryModel().conditionRequired().set((Object)true);
        }
    }

    @Override
    public M model() {
        return this.model;
    }

    @Override
    public State active() {
        return this.active;
    }

    @Override
    public void onSelection(Collection<Entity> selectedEntities) {
        if (this.active.get().booleanValue()) {
            this.onSelection.accept(selectedEntities);
        }
    }

    @Override
    public void onInsert(Collection<Entity> insertedEntities) {
        this.onInsert.accept(insertedEntities);
    }

    @Override
    public void onUpdate(Map<Entity, Entity> updatedEntities) {
        this.onUpdate.accept(updatedEntities);
    }

    @Override
    public void onDelete(Collection<Entity> deletedEntities) {
        this.onDelete.accept(deletedEntities);
    }

    static class DefaultBuilder<M extends EntityModel<M, E, T>, E extends EntityEditModel, T extends EntityTableModel<E>, B extends ModelLink.Builder<M, E, T, B>>
    implements ModelLink.Builder<M, E, T, B> {
        private static final Consumer<?> EMPTY_CONSUMER = new EmptyConsumer();
        private final M model;
        private Consumer<Collection<Entity>> onSelection = EMPTY_CONSUMER;
        private Consumer<Collection<Entity>> onInsert = EMPTY_CONSUMER;
        private Consumer<Map<Entity, Entity>> onUpdate = EMPTY_CONSUMER;
        private Consumer<Collection<Entity>> onDelete = EMPTY_CONSUMER;
        private boolean active = false;

        DefaultBuilder(M model) {
            this.model = (EntityModel)Objects.requireNonNull(model);
        }

        @Override
        public B onSelection(Consumer<Collection<Entity>> onSelection) {
            this.onSelection = Objects.requireNonNull(onSelection);
            return (B)this;
        }

        @Override
        public B onInsert(Consumer<Collection<Entity>> onInsert) {
            this.onInsert = Objects.requireNonNull(onInsert);
            return (B)this;
        }

        @Override
        public B onUpdate(Consumer<Map<Entity, Entity>> onUpdate) {
            this.onUpdate = Objects.requireNonNull(onUpdate);
            return (B)this;
        }

        @Override
        public B onDelete(Consumer<Collection<Entity>> onDelete) {
            this.onDelete = Objects.requireNonNull(onDelete);
            return (B)this;
        }

        @Override
        public B active(boolean active) {
            this.active = active;
            return (B)this;
        }

        @Override
        public ModelLink<M, E, T> build() {
            return new DefaultModelLink(this);
        }
    }

    private static final class EmptyConsumer<T>
    implements Consumer<T> {
        private EmptyConsumer() {
        }

        @Override
        public void accept(T result) {
        }
    }
}

