/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.model.condition.ConditionModel;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.EntitySearchModel;
import is.codion.framework.model.ForeignKeyConditionModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class EntityConditionModelFactory
implements Supplier<Map<Attribute<?>, ConditionModel<?>>> {
    private final EntityType entityType;
    private final EntityConnectionProvider connectionProvider;

    public EntityConditionModelFactory(EntityType entityType, EntityConnectionProvider connectionProvider) {
        this.entityType = Objects.requireNonNull(entityType);
        this.connectionProvider = Objects.requireNonNull(connectionProvider);
    }

    @Override
    public final Map<Attribute<?>, ConditionModel<?>> get() {
        HashMap models = new HashMap();
        models.putAll(this.definition().columns().get().stream().filter(this::include).collect(Collectors.toMap(Function.identity(), this::conditionModel)));
        models.putAll(this.definition().foreignKeys().get().stream().filter(this::include).collect(Collectors.toMap(Function.identity(), this::conditionModel)));
        return Collections.unmodifiableMap(models);
    }

    protected boolean include(Column<?> column) {
        return true;
    }

    protected boolean include(ForeignKey foreignKey) {
        return true;
    }

    protected <T> ConditionModel<T> conditionModel(Column<T> column) {
        ColumnDefinition definition = this.definition().columns().definition(column);
        return ConditionModel.builder((Class)column.type().valueClass()).format(definition.format()).dateTimePattern(definition.dateTimePattern()).operands(new ColumnOperands(definition)).build();
    }

    protected ForeignKeyConditionModel conditionModel(ForeignKey foreignKey) {
        return ForeignKeyConditionModel.builder().equalSearchModel(this.createEqualSearchModel(foreignKey)).inSearchModel(this.createInSearchModel(foreignKey)).build();
    }

    protected EntitySearchModel createEqualSearchModel(ForeignKey foreignKey) {
        return EntitySearchModel.builder(Objects.requireNonNull(foreignKey).referencedType(), this.connectionProvider).singleSelection(true).build();
    }

    protected EntitySearchModel createInSearchModel(ForeignKey foreignKey) {
        return EntitySearchModel.builder(Objects.requireNonNull(foreignKey).referencedType(), this.connectionProvider).build();
    }

    protected final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    protected final EntityDefinition definition() {
        return this.definition(this.entityType);
    }

    protected final EntityDefinition definition(EntityType entityType) {
        return this.connectionProvider.entities().definition(entityType);
    }

    private static final class ColumnOperands<T>
    implements ConditionModel.Operands<T> {
        private final ColumnDefinition<T> definition;

        private ColumnOperands(ColumnDefinition<T> definition) {
            this.definition = definition;
        }

        public Value<T> equal() {
            if (this.definition.attribute().type().isBoolean() && !this.definition.nullable()) {
                return Value.builder().nonNull((Object)false).notify(Value.Notify.WHEN_SET).build();
            }
            return super.equal();
        }
    }
}

