/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.event.Event;
import is.codion.common.observable.Observer;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class EntityEditEvents {
    private static final EntityEditListener EDIT_LISTENER = new EntityEditListener();

    private EntityEditEvents() {
    }

    public static Observer<Collection<Entity>> insertObserver(EntityType entityType) {
        return EDIT_LISTENER.insertObserver(Objects.requireNonNull(entityType));
    }

    public static Observer<Map<Entity, Entity>> updateObserver(EntityType entityType) {
        return EDIT_LISTENER.updateObserver(Objects.requireNonNull(entityType));
    }

    public static Observer<Collection<Entity>> deleteObserver(EntityType entityType) {
        return EDIT_LISTENER.deleteObserver(Objects.requireNonNull(entityType));
    }

    public static void inserted(Collection<Entity> insertedEntities) {
        EDIT_LISTENER.notifyInserted(Objects.requireNonNull(insertedEntities));
    }

    public static void updated(Map<Entity, Entity> updatedEntities) {
        EDIT_LISTENER.notifyUpdated(Objects.requireNonNull(updatedEntities));
    }

    public static void deleted(Collection<Entity> deletedEntities) {
        EDIT_LISTENER.notifyDeleted(Objects.requireNonNull(deletedEntities));
    }

    private static final class EntityEditListener {
        private final Map<EntityType, Event<Collection<Entity>>> insertEvents = Collections.synchronizedMap(new LinkedHashMap());
        private final Map<EntityType, Event<Map<Entity, Entity>>> updateEvents = Collections.synchronizedMap(new LinkedHashMap());
        private final Map<EntityType, Event<Collection<Entity>>> deleteEvents = Collections.synchronizedMap(new LinkedHashMap());

        private EntityEditListener() {
        }

        private Observer<Collection<Entity>> insertObserver(EntityType entityType) {
            return this.insertEvents.computeIfAbsent(entityType, k -> Event.event()).observer();
        }

        private Observer<Map<Entity, Entity>> updateObserver(EntityType entityType) {
            return this.updateEvents.computeIfAbsent(entityType, k -> Event.event()).observer();
        }

        private Observer<Collection<Entity>> deleteObserver(EntityType entityType) {
            return this.deleteEvents.computeIfAbsent(entityType, k -> Event.event()).observer();
        }

        private void notifyInserted(Collection<Entity> inserted) {
            Entity.groupByType(inserted).forEach(this::notifyInserted);
        }

        private void notifyInserted(EntityType entityType, Collection<Entity> inserted) {
            Event<Collection<Entity>> event = this.insertEvents.get(entityType);
            if (event != null) {
                event.accept(inserted);
            }
        }

        private void notifyUpdated(Map<Entity, Entity> updated) {
            updated.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Entity)entry.getKey()).type(), LinkedHashMap::new, Collectors.toList())).forEach(this::notifyUpdated);
        }

        private void notifyUpdated(EntityType entityType, List<Map.Entry<Entity, Entity>> updated) {
            Event<Map<Entity, Entity>> event = this.updateEvents.get(entityType);
            if (event != null) {
                event.accept(updated.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
        }

        private void notifyDeleted(Collection<Entity> deleted) {
            Entity.groupByType(deleted).forEach(this::notifyDeleted);
        }

        private void notifyDeleted(EntityType entityType, Collection<Entity> deleted) {
            Event<Collection<Entity>> event = this.deleteEvents.get(entityType);
            if (event != null) {
                event.accept(deleted);
            }
        }
    }
}

