/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.ObservableState;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.DefaultEntitySearchModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface EntitySearchModel {
    public static final PropertyValue<Integer> DEFAULT_LIMIT = Configuration.integerValue((String)(EntitySearchModel.class.getName() + ".defaultLimit"));

    public EntityDefinition entityDefinition();

    public EntityConnectionProvider connectionProvider();

    public Search search();

    public Selection selection();

    public Collection<Column<String>> columns();

    public Value<Integer> limit();

    public Value<Supplier<Condition>> condition();

    public Map<Column<String>, Settings> settings();

    public boolean singleSelection();

    public static Builder builder(EntityType entityType, EntityConnectionProvider connectionProvider) {
        return new DefaultEntitySearchModel.DefaultBuilder(entityType, connectionProvider);
    }

    public static interface Builder {
        public Builder searchColumns(Collection<Column<String>> var1);

        public Builder condition(Supplier<Condition> var1);

        public Builder attributes(Collection<Attribute<?>> var1);

        public Builder orderBy(OrderBy var1);

        public Builder singleSelection(boolean var1);

        public Builder limit(int var1);

        public EntitySearchModel build();
    }

    public static interface Settings {
        public State wildcardPrefix();

        public State wildcardPostfix();

        public State spaceAsWildcard();

        public State caseSensitive();
    }

    public static interface Selection {
        public Value<Entity> entity();

        public ValueSet<Entity> entities();

        public ObservableState empty();

        public void clear();
    }

    public static interface Search {
        public ValueSet<String> strings();

        public List<Entity> result();
    }
}

