/*
 * Decompiled with CFR 0.152.
 */
package is.codion.plugin.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import is.codion.common.logging.LoggerProxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.LoggerFactory;

public final class LogbackProxy
implements LoggerProxy {
    public Object getLogLevel() {
        return ((Logger)LoggerFactory.getLogger((String)"ROOT")).getLevel();
    }

    public void setLogLevel(Object logLevel) {
        if (!(logLevel instanceof Level)) {
            throw new IllegalArgumentException("logLevel should be of type " + Level.class.getName());
        }
        ((Logger)LoggerFactory.getLogger((String)"ROOT")).setLevel((Level)logLevel);
    }

    public List<Object> levels() {
        return Arrays.asList(Level.OFF, Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR);
    }

    public Collection<String> files() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        return context.getLoggerList().stream().flatMap(LogbackProxy::appenders).filter(FileAppender.class::isInstance).map(FileAppender.class::cast).map(FileAppender::getFile).collect(Collectors.toList());
    }

    private static Stream<Appender<ILoggingEvent>> appenders(Logger logger) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(logger.iteratorForAppenders(), 0), false);
    }
}

