/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.combobox;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Normalizer;
import java.util.Objects;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

class CompletionDocument
extends PlainDocument {
    private final JComboBox<?> comboBox;
    private final ComboBoxModel<?> comboBoxModel;
    private final boolean normalize;
    private boolean selecting = false;
    private boolean hitBackspace = false;
    private boolean hitBackspaceOnSelection;
    private JTextComponent editorComponent;

    protected CompletionDocument(JComboBox<?> comboBox, boolean normalize) {
        this.comboBox = Objects.requireNonNull(comboBox);
        this.comboBox.setEditable(true);
        this.normalize = normalize;
        this.comboBoxModel = comboBox.getModel();
        this.setEditorComponent((JTextComponent)comboBox.getEditor().getEditorComponent());
        comboBox.addPropertyChangeListener("editor", new EditorChangedListener());
        comboBox.addActionListener(new HighlightCompletedOnActionPerformedListener());
        this.setTextAccordingToSelectedItem();
        this.highlightCompletedText(0);
    }

    @Override
    public final void remove(int offset, int len) throws BadLocationException {
        int offs = offset;
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            this.hitBackspace = false;
            boolean selectFirst = false;
            if (offs > 0) {
                if (this.hitBackspaceOnSelection && --offs == 0) {
                    selectFirst = true;
                }
            } else {
                selectFirst = true;
            }
            if (selectFirst && this.comboBoxModel.getSize() > 0) {
                this.setSelectedItem(this.comboBoxModel.getElementAt(0));
                this.setTextAccordingToSelectedItem();
            }
            this.highlightCompletedText(offs);
        } else {
            super.remove(offs, len);
        }
    }

    protected final JComboBox<?> comboBox() {
        return this.comboBox;
    }

    protected final ComboBoxModel<?> comboBoxModel() {
        return this.comboBoxModel;
    }

    protected final boolean normalize() {
        return this.normalize;
    }

    protected final boolean selecting() {
        return this.selecting;
    }

    protected final void setTextAccordingToSelectedItem() {
        Object item = this.comboBox.getSelectedItem();
        String text = item == null ? "" : item.toString();
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void highlightCompletedText(int start) {
        this.editorComponent.setCaretPosition(this.getLength());
        this.editorComponent.moveCaretPosition(start);
    }

    protected final void setSelectedItem(Object item) {
        this.selecting = true;
        this.comboBoxModel.setSelectedItem(item);
        this.selecting = false;
    }

    protected final Object lookupItem(String pattern) {
        Object selectedItem = this.comboBoxModel.getSelectedItem();
        if (selectedItem != null && CompletionDocument.startsWithIgnoreCase(selectedItem.toString(), pattern, this.normalize)) {
            return selectedItem;
        }
        for (int i = 0; i < this.comboBoxModel.getSize(); ++i) {
            Object currentItem = this.comboBoxModel.getElementAt(i);
            if (currentItem == null || !CompletionDocument.startsWithIgnoreCase(currentItem.toString(), pattern, this.normalize)) continue;
            return currentItem;
        }
        return null;
    }

    protected static boolean startsWithIgnoreCase(String str1, String str2, boolean normalize) {
        String one = normalize ? CompletionDocument.normalize(str1) : str1;
        String two = normalize ? CompletionDocument.normalize(str2) : str2;
        return one.toUpperCase().startsWith(two.toUpperCase());
    }

    protected static String normalize(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    private void setEditorComponent(JTextComponent component) {
        this.editorComponent = component;
        if (this.editorComponent.getDocument() instanceof CompletionDocument) {
            throw new IllegalStateException("Completion has already been set for combo box");
        }
        this.editorComponent.setDocument(this);
        this.editorComponent.addKeyListener(new MatchKeyAdapter());
        this.editorComponent.addFocusListener(new HighlightCompletedOnFocusGainedListener());
    }

    private final class EditorChangedListener
    implements PropertyChangeListener {
        private EditorChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            ComboBoxEditor editor = (ComboBoxEditor)event.getNewValue();
            if (editor != null) {
                CompletionDocument.this.setEditorComponent((JTextComponent)editor.getEditorComponent());
            }
        }
    }

    private final class HighlightCompletedOnActionPerformedListener
    implements ActionListener {
        private HighlightCompletedOnActionPerformedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!CompletionDocument.this.selecting) {
                CompletionDocument.this.highlightCompletedText(0);
            }
        }
    }

    private final class MatchKeyAdapter
    extends KeyAdapter {
        private MatchKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            CompletionDocument.this.hitBackspace = false;
            switch (e.getKeyCode()) {
                case 8: {
                    CompletionDocument.this.hitBackspace = true;
                    CompletionDocument.this.hitBackspaceOnSelection = CompletionDocument.this.editorComponent.getSelectionStart() != CompletionDocument.this.editorComponent.getSelectionEnd();
                    break;
                }
                case 127: {
                    e.consume();
                    break;
                }
            }
        }
    }

    private final class HighlightCompletedOnFocusGainedListener
    extends FocusAdapter {
        private HighlightCompletedOnFocusGainedListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            CompletionDocument.this.highlightCompletedText(0);
        }
    }
}

