/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.list;

import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListModel;

final class ListValue<T>
extends AbstractComponentValue<Set<T>, JList<T>> {
    ListValue(JList<T> list) {
        super(list);
        list.addListSelectionListener(e -> this.notifyListeners());
    }

    @Override
    protected Set<T> getComponentValue() {
        return new HashSet(((JList)this.component()).getSelectedValuesList());
    }

    @Override
    protected void setComponentValue(Set<T> value) {
        ListValue.selectValues((JList)this.component(), value);
    }

    static <T> void selectValues(JList<T> list, Set<T> valueSet) {
        list.setSelectedIndices(valueSet.stream().map(value -> ListValue.indexOf(list, value)).filter(Optional::isPresent).map(Optional::get).mapToInt(Integer::intValue).toArray());
    }

    private static <T> Optional<Integer> indexOf(JList<T> list, T element) {
        ListModel<T> model = list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!Objects.equals(model.getElementAt(i), element)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }
}

