/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.spinner;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.spinner.AbstractSpinnerBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.component.spinner.SpinnerNumberValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.util.Objects;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;

final class DefaultNumberSpinnerBuilder<T extends Number>
extends AbstractSpinnerBuilder<T, NumberSpinnerBuilder<T>>
implements NumberSpinnerBuilder<T> {
    private final Class<T> valueClass;
    private T minimum;
    private T maximum;
    private T stepSize;
    private boolean groupingUsed = true;
    private String decimalFormatPattern;
    boolean commitOnValidEdit = true;

    DefaultNumberSpinnerBuilder(SpinnerNumberModel spinnerNumberModel, Class<T> valueClass, Value<T> linkedValue) {
        super(spinnerNumberModel, linkedValue);
        this.valueClass = Objects.requireNonNull(valueClass);
        if (!valueClass.equals(Integer.class) && !valueClass.equals(Double.class)) {
            throw new IllegalStateException("NumberSpinnerBuilder not implemented for type: " + valueClass);
        }
    }

    @Override
    public NumberSpinnerBuilder<T> minimum(T minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public NumberSpinnerBuilder<T> maximum(T maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public NumberSpinnerBuilder<T> stepSize(T stepSize) {
        this.stepSize = stepSize;
        return this;
    }

    @Override
    public NumberSpinnerBuilder<T> groupingUsed(boolean groupingUsed) {
        this.groupingUsed = groupingUsed;
        return this;
    }

    @Override
    public NumberSpinnerBuilder<T> decimalFormatPattern(String decimalFormatPattern) {
        this.decimalFormatPattern = Objects.requireNonNull(decimalFormatPattern);
        return this;
    }

    @Override
    public NumberSpinnerBuilder<T> commitOnValidEdit(boolean commitOnValidEdit) {
        this.commitOnValidEdit = commitOnValidEdit;
        return this;
    }

    @Override
    protected ComponentValue<T, JSpinner> createComponentValue(JSpinner component) {
        if (this.valueClass.equals(Integer.class) || this.valueClass.equals(Double.class)) {
            return new SpinnerNumberValue(component);
        }
        throw new IllegalStateException("NumberSpinnerBuilder not implemented for type: " + this.valueClass);
    }

    @Override
    protected JSpinner createSpinner() {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.spinnerModel;
        if (this.minimum != null) {
            spinnerNumberModel.setMinimum((Comparable)this.minimum);
        }
        if (this.maximum != null) {
            spinnerNumberModel.setMaximum((Comparable)this.maximum);
        }
        if (this.stepSize != null) {
            spinnerNumberModel.setStepSize((Number)this.stepSize);
        }
        JSpinner spinner = super.createSpinner();
        JSpinner.NumberEditor numberEditor = this.decimalFormatPattern == null ? new JSpinner.NumberEditor(spinner) : new JSpinner.NumberEditor(spinner, this.decimalFormatPattern);
        numberEditor.getFormat().setGroupingUsed(this.groupingUsed);
        if (this.commitOnValidEdit) {
            ((DefaultFormatter)numberEditor.getTextField().getFormatter()).setCommitsOnValidEdit(true);
        }
        spinner.setEditor(numberEditor);
        return spinner;
    }
}

